/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key;

import java.security.KeyStore;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.skeleton.key.i18n.Messages;
import org.jboss.resteasy.skeleton.key.representations.AccessTokenResponse;
import org.jboss.resteasy.util.BasicAuthHelper;

public class AbstractOAuthClient {
    private static final Logger LOG = Logger.getLogger(AbstractOAuthClient.class);
    protected String clientId;
    protected String password;
    protected KeyStore truststore;
    protected String authUrl;
    protected String codeUrl;
    protected String stateCookieName = "OAuth_Token_Request_State";
    protected Client client;
    protected final AtomicLong counter = new AtomicLong();

    protected String getStateCode() {
        return this.counter.getAndIncrement() + "/" + UUID.randomUUID().toString();
    }

    public void start() {
        if (this.client == null) {
            this.client = new ResteasyClientBuilder().trustStore(this.truststore).hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.ANY).connectionPoolSize(10).build();
        }
    }

    public void stop() {
        this.client.close();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public KeyStore getTruststore() {
        return this.truststore;
    }

    public void setTruststore(KeyStore truststore) {
        this.truststore = truststore;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public String getCodeUrl() {
        return this.codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public String getStateCookieName() {
        return this.stateCookieName;
    }

    public void setStateCookieName(String stateCookieName) {
        this.stateCookieName = stateCookieName;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveBearerToken(String redirectUri, String code) {
        redirectUri = this.stripOauthParametersFromRedirect(redirectUri);
        String authHeader = BasicAuthHelper.createHeader((String)this.clientId, (String)this.password);
        Form codeForm = new Form().param("grant_type", "authorization_code").param("code", code).param("redirect_uri", redirectUri);
        try (Response res = this.client.target(this.codeUrl).request().header("Authorization", (Object)authHeader).post(Entity.form((Form)codeForm));){
            if (res.getStatus() == 400) {
                throw new BadRequestException();
            }
            if (res.getStatus() != 200) {
                throw new InternalServerErrorException((Throwable)new Exception(Messages.MESSAGES.unknownErrorGettingAccessToken()));
            }
            AccessTokenResponse tokenResponse = (AccessTokenResponse)res.readEntity(AccessTokenResponse.class);
            String string = tokenResponse.getToken();
            return string;
        }
    }

    protected String stripOauthParametersFromRedirect(String uri) {
        LOG.info(Messages.MESSAGES.redirectUri(uri));
        UriBuilder builder = UriBuilder.fromUri((String)uri).replaceQueryParam("code", null).replaceQueryParam("state", null);
        return builder.build(new Object[0]).toString();
    }
}

