/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.interception.jaxrs.ClientRequestFilterRegistry;
import org.jboss.resteasy.core.interception.jaxrs.ClientResponseFilterRegistry;
import org.jboss.resteasy.core.interception.jaxrs.ContainerRequestFilterRegistry;
import org.jboss.resteasy.core.interception.jaxrs.ContainerResponseFilterRegistry;
import org.jboss.resteasy.core.interception.jaxrs.ReaderInterceptorRegistry;
import org.jboss.resteasy.core.interception.jaxrs.WriterInterceptorRegistry;
import org.jboss.resteasy.plugins.delegates.CacheControlDelegate;
import org.jboss.resteasy.plugins.delegates.CookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.DateDelegate;
import org.jboss.resteasy.plugins.delegates.EntityTagDelegate;
import org.jboss.resteasy.plugins.delegates.LinkDelegate;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.LocaleDelegate;
import org.jboss.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.NewCookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.UriHeaderDelegate;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.LinkBuilderImpl;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.specimpl.VariantListBuilderImpl;
import org.jboss.resteasy.spi.AsyncClientResponseProvider;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.ContextInjector;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClassProcessor;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.FeatureContextDelegate;
import org.jboss.resteasy.util.PickConstructor;
import org.jboss.resteasy.util.ThreadLocalStack;
import org.jboss.resteasy.util.Types;

public class ResteasyProviderFactory
extends RuntimeDelegate
implements Providers,
HeaderValueProcessor,
Configurable<ResteasyProviderFactory>,
Configuration {
    private static final ThreadLocalStack<Map<Class<?>, Object>> contextualData = new ThreadLocalStack();
    private static final int maxForwards = 20;
    private static volatile ResteasyProviderFactory instance;
    private static boolean registerBuiltinByDefault;
    private MediaTypeMap<SortedKey<MessageBodyReader>> serverMessageBodyReaders;
    private MediaTypeMap<SortedKey<MessageBodyWriter>> serverMessageBodyWriters;
    private MediaTypeMap<SortedKey<MessageBodyReader>> clientMessageBodyReaders;
    private MediaTypeMap<SortedKey<MessageBodyWriter>> clientMessageBodyWriters;
    private Map<Class<?>, SortedKey<ExceptionMapper>> sortedExceptionMappers;
    private Map<Class<?>, ExceptionMapper> exceptionMappers;
    private Map<Class<?>, AsyncResponseProvider> asyncResponseProviders;
    private Map<Class<?>, AsyncClientResponseProvider> asyncClientResponseProviders;
    private Map<Class<?>, AsyncStreamProvider> asyncStreamProviders;
    private Map<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> contextResolvers;
    private Map<Type, ContextInjector> contextInjectors;
    private Map<Type, ContextInjector> asyncContextInjectors;
    private Set<ExtSortedKey<ParamConverterProvider>> sortedParamConverterProviders;
    private Map<Class<?>, Class<? extends StringParameterUnmarshaller>> stringParameterUnmarshallers;
    protected Map<Class<?>, Map<Class<?>, Integer>> classContracts;
    private Map<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates;
    private ReaderInterceptorRegistry serverReaderInterceptorRegistry;
    private WriterInterceptorRegistry serverWriterInterceptorRegistry;
    private ContainerRequestFilterRegistry containerRequestFilterRegistry;
    private ContainerResponseFilterRegistry containerResponseFilterRegistry;
    private ClientRequestFilterRegistry clientRequestFilterRegistry;
    private ClientResponseFilterRegistry clientResponseFilters;
    private ReaderInterceptorRegistry clientReaderInterceptorRegistry;
    private WriterInterceptorRegistry clientWriterInterceptorRegistry;
    private boolean builtinsRegistered = false;
    private boolean registerBuiltins = true;
    private InjectorFactory injectorFactory;
    private ResteasyProviderFactory parent;
    private Set<DynamicFeature> serverDynamicFeatures;
    private Set<DynamicFeature> clientDynamicFeatures;
    private Map<String, Object> properties;
    private Map<Class<?>, Class<? extends RxInvokerProvider<?>>> reactiveClasses;
    private ResourceBuilder resourceBuilder;
    protected Set<Feature> enabledFeatures;
    protected Set<Class<?>> providerClasses;
    protected Set<Object> providerInstances;
    static final Object RD_LOCK;

    public ResteasyProviderFactory() {
        this.initialize();
    }

    public ResteasyProviderFactory(ResteasyProviderFactory parent) {
        this(parent, false);
    }

    public ResteasyProviderFactory(ResteasyProviderFactory parent, boolean local) {
        this.parent = parent;
        this.providerClasses = new CopyOnWriteArraySet();
        this.providerInstances = new CopyOnWriteArraySet<Object>();
        this.properties = new ConcurrentHashMap<String, Object>();
        this.properties.putAll(parent.getProperties());
        this.enabledFeatures = new CopyOnWriteArraySet<Feature>();
        this.reactiveClasses = new ConcurrentHashMap();
        if (local) {
            this.classContracts = new ConcurrentHashMap();
            if (parent != null) {
                this.providerClasses.addAll(parent.providerClasses);
                this.providerInstances.addAll(parent.providerInstances);
                this.classContracts.putAll(parent.classContracts);
                this.properties.putAll(parent.properties);
                this.enabledFeatures.addAll(parent.enabledFeatures);
                this.reactiveClasses.putAll(parent.reactiveClasses);
            }
        }
        this.resourceBuilder = new ResourceBuilder();
    }

    protected void initialize() {
        this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>();
        this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>();
        this.enabledFeatures = new CopyOnWriteArraySet<Feature>();
        this.properties = new ConcurrentHashMap<String, Object>();
        this.providerClasses = new CopyOnWriteArraySet();
        this.providerInstances = new CopyOnWriteArraySet<Object>();
        this.classContracts = new ConcurrentHashMap();
        this.serverMessageBodyReaders = new MediaTypeMap();
        this.serverMessageBodyWriters = new MediaTypeMap();
        this.clientMessageBodyReaders = new MediaTypeMap();
        this.clientMessageBodyWriters = new MediaTypeMap();
        this.sortedExceptionMappers = new ConcurrentHashMap();
        this.asyncResponseProviders = new ConcurrentHashMap();
        this.asyncClientResponseProviders = new ConcurrentHashMap();
        this.asyncStreamProviders = new ConcurrentHashMap();
        this.contextResolvers = new ConcurrentHashMap();
        this.contextInjectors = new ConcurrentHashMap<Type, ContextInjector>();
        this.asyncContextInjectors = new ConcurrentHashMap<Type, ContextInjector>();
        this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet());
        this.stringParameterUnmarshallers = new ConcurrentHashMap();
        this.reactiveClasses = new ConcurrentHashMap();
        this.headerDelegates = new ConcurrentHashMap();
        this.resourceBuilder = new ResourceBuilder();
        this.initializeRegistriesAndFilters();
        this.builtinsRegistered = false;
        this.registerBuiltins = true;
        this.injectorFactory = new InjectorFactoryImpl();
        this.addHeaderDelegate(MediaType.class, new MediaTypeHeaderDelegate());
        this.addHeaderDelegate(NewCookie.class, new NewCookieHeaderDelegate());
        this.addHeaderDelegate(Cookie.class, new CookieHeaderDelegate());
        this.addHeaderDelegate(URI.class, new UriHeaderDelegate());
        this.addHeaderDelegate(EntityTag.class, new EntityTagDelegate());
        this.addHeaderDelegate(CacheControl.class, new CacheControlDelegate());
        this.addHeaderDelegate(Locale.class, new LocaleDelegate());
        this.addHeaderDelegate(LinkHeader.class, new LinkHeaderDelegate());
        this.addHeaderDelegate(Link.class, new LinkDelegate());
        this.addHeaderDelegate(Date.class, new DateDelegate());
    }

    private void initializeRegistriesAndFilters() {
        this.serverReaderInterceptorRegistry = new ReaderInterceptorRegistry(this);
        this.serverWriterInterceptorRegistry = new WriterInterceptorRegistry(this);
        this.containerRequestFilterRegistry = new ContainerRequestFilterRegistry(this);
        this.containerResponseFilterRegistry = new ContainerResponseFilterRegistry(this);
        this.clientRequestFilterRegistry = new ClientRequestFilterRegistry(this);
        this.clientResponseFilters = new ClientResponseFilterRegistry(this);
        this.clientReaderInterceptorRegistry = new ReaderInterceptorRegistry(this);
        this.clientWriterInterceptorRegistry = new WriterInterceptorRegistry(this);
    }

    public Set<DynamicFeature> getServerDynamicFeatures() {
        if (this.serverDynamicFeatures == null && this.parent != null) {
            return this.parent.getServerDynamicFeatures();
        }
        return this.serverDynamicFeatures;
    }

    public Set<DynamicFeature> getClientDynamicFeatures() {
        if (this.clientDynamicFeatures == null && this.parent != null) {
            return this.parent.getClientDynamicFeatures();
        }
        return this.clientDynamicFeatures;
    }

    private MediaTypeMap<SortedKey<MessageBodyReader>> getServerMessageBodyReaders() {
        if (this.serverMessageBodyReaders == null && this.parent != null) {
            return this.parent.getServerMessageBodyReaders();
        }
        return this.serverMessageBodyReaders;
    }

    private MediaTypeMap<SortedKey<MessageBodyWriter>> getServerMessageBodyWriters() {
        if (this.serverMessageBodyWriters == null && this.parent != null) {
            return this.parent.getServerMessageBodyWriters();
        }
        return this.serverMessageBodyWriters;
    }

    private MediaTypeMap<SortedKey<MessageBodyReader>> getClientMessageBodyReaders() {
        if (this.clientMessageBodyReaders == null && this.parent != null) {
            return this.parent.getClientMessageBodyReaders();
        }
        return this.clientMessageBodyReaders;
    }

    private MediaTypeMap<SortedKey<MessageBodyWriter>> getClientMessageBodyWriters() {
        if (this.clientMessageBodyWriters == null && this.parent != null) {
            return this.parent.getClientMessageBodyWriters();
        }
        return this.clientMessageBodyWriters;
    }

    public Map<Class<?>, ExceptionMapper> getExceptionMappers() {
        if (this.exceptionMappers != null) {
            return this.exceptionMappers;
        }
        ConcurrentHashMap map = new ConcurrentHashMap();
        for (Map.Entry<Class<?>, SortedKey<ExceptionMapper>> entry : this.getSortedExceptionMappers().entrySet()) {
            map.put(entry.getKey(), entry.getValue().getObj());
        }
        this.exceptionMappers = map;
        return map;
    }

    private Map<Class<?>, SortedKey<ExceptionMapper>> getSortedExceptionMappers() {
        if (this.sortedExceptionMappers == null && this.parent != null) {
            return this.parent.getSortedExceptionMappers();
        }
        return this.sortedExceptionMappers;
    }

    public Map<Class<?>, AsyncResponseProvider> getAsyncResponseProviders() {
        if (this.asyncResponseProviders == null && this.parent != null) {
            return this.parent.getAsyncResponseProviders();
        }
        return this.asyncResponseProviders;
    }

    public Map<Class<?>, AsyncClientResponseProvider> getAsyncClientResponseProviders() {
        if (this.asyncClientResponseProviders == null && this.parent != null) {
            return this.parent.getAsyncClientResponseProviders();
        }
        return this.asyncClientResponseProviders;
    }

    public Map<Class<?>, AsyncStreamProvider> getAsyncStreamProviders() {
        if (this.asyncStreamProviders == null && this.parent != null) {
            return this.parent.getAsyncStreamProviders();
        }
        return this.asyncStreamProviders;
    }

    public Map<Type, ContextInjector> getContextInjectors() {
        if (this.contextInjectors == null && this.parent != null) {
            return this.parent.getContextInjectors();
        }
        return this.contextInjectors;
    }

    public Map<Type, ContextInjector> getAsyncContextInjectors() {
        if (this.asyncContextInjectors == null && this.parent != null) {
            return this.parent.getAsyncContextInjectors();
        }
        return this.asyncContextInjectors;
    }

    private Map<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> getContextResolvers() {
        if (this.contextResolvers == null && this.parent != null) {
            return this.parent.getContextResolvers();
        }
        return this.contextResolvers;
    }

    private Set<ExtSortedKey<ParamConverterProvider>> getSortedParamConverterProviders() {
        if (this.sortedParamConverterProviders == null && this.parent != null) {
            return this.parent.getSortedParamConverterProviders();
        }
        return this.sortedParamConverterProviders;
    }

    private Map<Class<?>, Class<? extends StringParameterUnmarshaller>> getStringParameterUnmarshallers() {
        if (this.stringParameterUnmarshallers == null && this.parent != null) {
            return this.parent.getStringParameterUnmarshallers();
        }
        return this.stringParameterUnmarshallers;
    }

    public Set<Class<?>> getProviderClasses() {
        if (this.providerClasses == null && this.parent != null) {
            return this.parent.getProviderClasses();
        }
        HashSet set = new HashSet();
        if (this.parent != null) {
            set.addAll(this.parent.getProviderClasses());
        }
        set.addAll(this.providerClasses);
        return set;
    }

    public Set<Object> getProviderInstances() {
        if (this.providerInstances == null && this.parent != null) {
            return this.parent.getProviderInstances();
        }
        HashSet<Object> set = new HashSet<Object>();
        if (this.parent != null) {
            set.addAll(this.parent.getProviderInstances());
        }
        set.addAll(this.providerInstances);
        return set;
    }

    private Map<Class<?>, Map<Class<?>, Integer>> getClassContracts() {
        if (this.classContracts != null) {
            return this.classContracts;
        }
        ConcurrentHashMap map = new ConcurrentHashMap();
        if (this.parent != null) {
            for (Map.Entry<Class<?>, Map<Class<?>, Integer>> entry : this.parent.getClassContracts().entrySet()) {
                HashMap mapEntry = new HashMap();
                mapEntry.putAll(entry.getValue());
                map.put(entry.getKey(), mapEntry);
            }
        }
        this.classContracts = map;
        return this.classContracts;
    }

    public static <T> void pushContext(Class<T> type, T data) {
        ResteasyProviderFactory.getContextDataMap().put(type, data);
    }

    public static void pushContextDataMap(Map<Class<?>, Object> map) {
        contextualData.push(map);
    }

    public static Map<Class<?>, Object> getContextDataMap() {
        return ResteasyProviderFactory.getContextDataMap(true);
    }

    public static <T> T getContextData(Class<T> type) {
        return (T)ResteasyProviderFactory.getContextDataMap().get(type);
    }

    public boolean hasAsyncContextData(Type genericType) {
        return this.getAsyncContextInjectors().containsKey(Types.boxPrimitives(genericType));
    }

    public <T> T getContextData(Class<T> rawType, Type genericType, Annotation[] annotations, boolean unwrapAsync) {
        Object ret = ResteasyProviderFactory.getContextDataMap().get(rawType);
        if (ret != null) {
            return (T)ret;
        }
        ContextInjector contextInjector = this.getContextInjectors().get(genericType);
        boolean async = false;
        if (contextInjector == null && unwrapAsync) {
            contextInjector = this.getAsyncContextInjectors().get(Types.boxPrimitives(genericType));
            async = true;
        }
        if (contextInjector != null) {
            ret = contextInjector.resolve(rawType, genericType, annotations);
            if (async && ret != null) {
                Type wrappedType = Types.getActualTypeArgumentsOfAnInterface(contextInjector.getClass(), ContextInjector.class)[0];
                Class<?> rawWrappedType = Types.getRawType(wrappedType);
                AsyncResponseProvider<?> converter = this.getAsyncResponseProvider(rawWrappedType);
                ret = converter.toCompletionStage(ret);
            }
        }
        return (T)ret;
    }

    public static <T> T popContextData(Class<T> type) {
        return (T)ResteasyProviderFactory.getContextDataMap().remove(type);
    }

    public static void clearContextData() {
        contextualData.clear();
    }

    private static Map<Class<?>, Object> getContextDataMap(boolean create) {
        Map<Class<?>, Object> map = contextualData.get();
        if (map == null) {
            map = new HashMap();
            contextualData.setLast(map);
        }
        return map;
    }

    public static Map<Class<?>, Object> addContextDataLevel() {
        if (ResteasyProviderFactory.getContextDataLevelCount() == 20) {
            throw new BadRequestException(Messages.MESSAGES.excededMaximumForwards(ResteasyProviderFactory.getContextData(UriInfo.class).getPath()));
        }
        HashMap map = new HashMap();
        contextualData.push(map);
        return map;
    }

    public static int getContextDataLevelCount() {
        return contextualData.size();
    }

    public static void removeContextDataLevel() {
        contextualData.pop();
    }

    public static ResteasyProviderFactory peekInstance() {
        return instance;
    }

    public static synchronized void clearInstanceIfEqual(ResteasyProviderFactory factory) {
        if (instance == factory) {
            instance = null;
            RuntimeDelegate.setInstance(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setInstance(ResteasyProviderFactory factory) {
        Object object = RD_LOCK;
        synchronized (object) {
            instance = factory;
        }
        RuntimeDelegate.setInstance((RuntimeDelegate)factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResteasyProviderFactory getInstance() {
        ResteasyProviderFactory result = instance;
        if (result == null) {
            Object object = RD_LOCK;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    RuntimeDelegate runtimeDelegate = RuntimeDelegate.getInstance();
                    instance = runtimeDelegate instanceof ResteasyProviderFactory ? (result = (ResteasyProviderFactory)runtimeDelegate) : (result = new ResteasyProviderFactory());
                    if (registerBuiltinByDefault) {
                        RegisterBuiltin.register(instance);
                    }
                }
            }
        }
        return instance;
    }

    public static ResteasyProviderFactory newInstance() {
        return new ResteasyProviderFactory();
    }

    public static void setRegisterBuiltinByDefault(boolean registerBuiltinByDefault) {
        ResteasyProviderFactory.registerBuiltinByDefault = registerBuiltinByDefault;
    }

    public boolean isRegisterBuiltins() {
        return this.registerBuiltins;
    }

    public void setRegisterBuiltins(boolean registerBuiltins) {
        this.registerBuiltins = registerBuiltins;
    }

    public InjectorFactory getInjectorFactory() {
        if (this.injectorFactory == null && this.parent != null) {
            return this.parent.getInjectorFactory();
        }
        return this.injectorFactory;
    }

    public void setInjectorFactory(InjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
    }

    public ReaderInterceptorRegistry getServerReaderInterceptorRegistry() {
        if (this.serverReaderInterceptorRegistry == null && this.parent != null) {
            return this.parent.getServerReaderInterceptorRegistry();
        }
        return this.serverReaderInterceptorRegistry;
    }

    public WriterInterceptorRegistry getServerWriterInterceptorRegistry() {
        if (this.serverWriterInterceptorRegistry == null && this.parent != null) {
            return this.parent.getServerWriterInterceptorRegistry();
        }
        return this.serverWriterInterceptorRegistry;
    }

    public ContainerRequestFilterRegistry getContainerRequestFilterRegistry() {
        if (this.containerRequestFilterRegistry == null && this.parent != null) {
            return this.parent.getContainerRequestFilterRegistry();
        }
        return this.containerRequestFilterRegistry;
    }

    public ContainerResponseFilterRegistry getContainerResponseFilterRegistry() {
        if (this.containerResponseFilterRegistry == null && this.parent != null) {
            return this.parent.getContainerResponseFilterRegistry();
        }
        return this.containerResponseFilterRegistry;
    }

    public ReaderInterceptorRegistry getClientReaderInterceptorRegistry() {
        if (this.clientReaderInterceptorRegistry == null && this.parent != null) {
            return this.parent.getClientReaderInterceptorRegistry();
        }
        return this.clientReaderInterceptorRegistry;
    }

    public WriterInterceptorRegistry getClientWriterInterceptorRegistry() {
        if (this.clientWriterInterceptorRegistry == null && this.parent != null) {
            return this.parent.getClientWriterInterceptorRegistry();
        }
        return this.clientWriterInterceptorRegistry;
    }

    public ClientRequestFilterRegistry getClientRequestFilterRegistry() {
        if (this.clientRequestFilterRegistry == null && this.parent != null) {
            return this.parent.getClientRequestFilterRegistry();
        }
        return this.clientRequestFilterRegistry;
    }

    public ClientResponseFilterRegistry getClientResponseFilters() {
        if (this.clientResponseFilters == null && this.parent != null) {
            return this.parent.getClientResponseFilters();
        }
        return this.clientResponseFilters;
    }

    public boolean isBuiltinsRegistered() {
        return this.builtinsRegistered;
    }

    public void setBuiltinsRegistered(boolean builtinsRegistered) {
        this.builtinsRegistered = builtinsRegistered;
    }

    public UriBuilder createUriBuilder() {
        return new ResteasyUriBuilder();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> tClass) {
        if (tClass == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.tClassParameterNull());
        }
        if (this.headerDelegates == null && this.parent != null) {
            return this.parent.createHeaderDelegate(tClass);
        }
        for (Class<T> clazz = tClass; clazz != null; clazz = clazz.getSuperclass()) {
            RuntimeDelegate.HeaderDelegate<T> delegate = this.headerDelegates.get(clazz);
            if (delegate != null) {
                return delegate;
            }
            delegate = this.createHeaderDelegateFromInterfaces(clazz.getInterfaces());
            if (delegate == null) continue;
            return delegate;
        }
        return this.createHeaderDelegateFromInterfaces(tClass.getInterfaces());
    }

    private <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegateFromInterfaces(Class<?>[] interfaces) {
        RuntimeDelegate.HeaderDelegate<T> delegate = null;
        for (int i = 0; i < interfaces.length; ++i) {
            delegate = this.headerDelegates.get(interfaces[i]);
            if (delegate != null) {
                return delegate;
            }
            delegate = this.createHeaderDelegateFromInterfaces(interfaces[i].getInterfaces());
            if (delegate == null) continue;
            return delegate;
        }
        return null;
    }

    private Map<Class<?>, RuntimeDelegate.HeaderDelegate> getHeaderDelegates() {
        if (this.headerDelegates == null && this.parent != null) {
            return this.parent.getHeaderDelegates();
        }
        return this.headerDelegates;
    }

    public void addHeaderDelegate(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        if (this.headerDelegates == null) {
            this.headerDelegates = new ConcurrentHashMap();
            this.headerDelegates.putAll(this.parent.getHeaderDelegates());
        }
        this.headerDelegates.put(clazz, header);
    }

    private void addMessageBodyReader(MessageBodyReader provider, Class<?> providerClass, int priority, boolean isBuiltin) {
        SortedKey<MessageBodyReader> key = new SortedKey<MessageBodyReader>(MessageBodyReader.class, provider, providerClass, priority, isBuiltin);
        this.injectProperties(providerClass, provider);
        Consumes consumeMime = provider.getClass().getAnnotation(Consumes.class);
        RuntimeType type = null;
        ConstrainedTo constrainedTo = providerClass.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null) {
            type = constrainedTo.value();
        }
        if ((type == null || type == RuntimeType.CLIENT) && this.clientMessageBodyReaders == null) {
            this.clientMessageBodyReaders = this.parent.getClientMessageBodyReaders().clone();
        }
        if ((type == null || type == RuntimeType.SERVER) && this.serverMessageBodyReaders == null) {
            this.serverMessageBodyReaders = this.parent.getServerMessageBodyReaders().clone();
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                if (type == null) {
                    this.clientMessageBodyReaders.add(MediaType.valueOf((String)consume), key);
                    this.serverMessageBodyReaders.add(MediaType.valueOf((String)consume), key);
                    continue;
                }
                if (type == RuntimeType.CLIENT) {
                    this.clientMessageBodyReaders.add(MediaType.valueOf((String)consume), key);
                    continue;
                }
                this.serverMessageBodyReaders.add(MediaType.valueOf((String)consume), key);
            }
        } else if (type == null) {
            this.clientMessageBodyReaders.add(new MediaType("*", "*"), key);
            this.serverMessageBodyReaders.add(new MediaType("*", "*"), key);
        } else if (type == RuntimeType.CLIENT) {
            this.clientMessageBodyReaders.add(new MediaType("*", "*"), key);
        } else {
            this.serverMessageBodyReaders.add(new MediaType("*", "*"), key);
        }
    }

    private void addMessageBodyWriter(MessageBodyWriter provider, Class<?> providerClass, int priority, boolean isBuiltin) {
        this.injectProperties(providerClass, provider);
        Produces consumeMime = provider.getClass().getAnnotation(Produces.class);
        SortedKey<MessageBodyWriter> key = new SortedKey<MessageBodyWriter>(MessageBodyWriter.class, provider, providerClass, priority, isBuiltin);
        RuntimeType type = null;
        ConstrainedTo constrainedTo = providerClass.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null) {
            type = constrainedTo.value();
        }
        if ((type == null || type == RuntimeType.CLIENT) && this.clientMessageBodyWriters == null) {
            this.clientMessageBodyWriters = this.parent.getClientMessageBodyWriters().clone();
        }
        if ((type == null || type == RuntimeType.SERVER) && this.serverMessageBodyWriters == null) {
            this.serverMessageBodyWriters = this.parent.getServerMessageBodyWriters().clone();
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                if (type == null) {
                    this.clientMessageBodyWriters.add(MediaType.valueOf((String)consume), key);
                    this.serverMessageBodyWriters.add(MediaType.valueOf((String)consume), key);
                    continue;
                }
                if (type == RuntimeType.CLIENT) {
                    this.clientMessageBodyWriters.add(MediaType.valueOf((String)consume), key);
                    continue;
                }
                this.serverMessageBodyWriters.add(MediaType.valueOf((String)consume), key);
            }
        } else if (type == null) {
            this.clientMessageBodyWriters.add(new MediaType("*", "*"), key);
            this.serverMessageBodyWriters.add(new MediaType("*", "*"), key);
        } else if (type == RuntimeType.CLIENT) {
            this.clientMessageBodyWriters.add(new MediaType("*", "*"), key);
        } else {
            this.serverMessageBodyWriters.add(new MediaType("*", "*"), key);
        }
    }

    @Deprecated
    public <T> MessageBodyReader<T> getServerMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
    }

    public <T> MessageBodyReader<T> getServerMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, RESTEasyTracingLogger tracingLogger) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders, tracingLogger);
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        MessageBodyReader<T> reader = this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
        if (reader != null) {
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", reader.getClass().getName());
        }
        return reader;
    }

    public <T> MessageBodyReader<T> getClientMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getClientMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
    }

    @Deprecated
    private <T> MessageBodyReader<T> resolveMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders) {
        List<SortedKey<MessageBodyReader>> readers = availableReaders.getPossible(mediaType, type);
        for (SortedKey<MessageBodyReader> reader : readers) {
            if (!((MessageBodyReader)((SortedKey)reader).obj).isReadable(type, genericType, annotations, mediaType)) continue;
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", reader.getClass().getName());
            return (MessageBodyReader)((SortedKey)reader).obj;
        }
        return null;
    }

    protected <T> MessageBodyReader<T> resolveMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders, RESTEasyTracingLogger tracingLogger) {
        SortedKey<MessageBodyReader> reader;
        List<SortedKey<MessageBodyReader>> readers = availableReaders.getPossible(mediaType, type);
        if (tracingLogger.isLogEnabled("MBR_FIND")) {
            tracingLogger.log("MBR_FIND", type.getName(), genericType instanceof Class ? ((Class)genericType).getName() : genericType, mediaType, Arrays.toString(annotations));
        }
        MessageBodyReader result = null;
        Iterator<SortedKey<MessageBodyReader>> iterator = readers.iterator();
        while (iterator.hasNext()) {
            reader = iterator.next();
            if (((MessageBodyReader)((SortedKey)reader).obj).isReadable(type, genericType, annotations, mediaType)) {
                LogMessages.LOGGER.debugf("MessageBodyReader: %s", reader.getClass().getName());
                result = (MessageBodyReader)((SortedKey)reader).obj;
                tracingLogger.log("MBR_SELECTED", reader);
                break;
            }
            tracingLogger.log("MBR_NOT_READABLE", result);
        }
        if (tracingLogger.isLogEnabled("MBR_SKIPPED")) {
            while (iterator.hasNext()) {
                reader = iterator.next();
                tracingLogger.log("MBR_SKIPPED", ((SortedKey)reader).obj);
            }
        }
        return result;
    }

    private void addExceptionMapper(ExceptionMapper provider, Class providerClass, boolean isBuiltin) {
        if (providerClass.isSynthetic()) {
            providerClass = providerClass.getSuperclass();
        }
        Type exceptionType = Types.getActualTypeArgumentsOfAnInterface(providerClass, ExceptionMapper.class)[0];
        this.injectProperties(providerClass, provider);
        Class<?> exceptionClass = Types.getRawType(exceptionType);
        if (!Throwable.class.isAssignableFrom(exceptionClass)) {
            throw new RuntimeException(Messages.MESSAGES.incorrectTypeParameterExceptionMapper());
        }
        if (this.sortedExceptionMappers == null) {
            this.sortedExceptionMappers = new ConcurrentHashMap();
            this.sortedExceptionMappers.putAll(this.parent.getSortedExceptionMappers());
        }
        int priority = ResteasyProviderFactory.getPriority(null, null, ExceptionMapper.class, providerClass);
        SortedKey<ExceptionMapper> candidateExceptionMapper = new SortedKey<ExceptionMapper>(null, provider, providerClass, priority, isBuiltin);
        SortedKey<ExceptionMapper> registeredExceptionMapper = this.sortedExceptionMappers.get(exceptionClass);
        if (registeredExceptionMapper != null && candidateExceptionMapper.compareTo(registeredExceptionMapper) > 0) {
            return;
        }
        this.sortedExceptionMappers.put(exceptionClass, candidateExceptionMapper);
        this.exceptionMappers = null;
    }

    private void addAsyncResponseProvider(AsyncResponseProvider provider, Class providerClass) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface(providerClass, AsyncResponseProvider.class)[0];
        this.injectProperties(provider.getClass(), provider);
        Class<?> asyncClass = Types.getRawType(asyncType);
        if (this.asyncResponseProviders == null) {
            this.asyncResponseProviders = new ConcurrentHashMap();
            this.asyncResponseProviders.putAll(this.parent.getAsyncResponseProviders());
        }
        this.asyncResponseProviders.put(asyncClass, provider);
    }

    private void addAsyncClientResponseProvider(AsyncClientResponseProvider provider, Class providerClass) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface(providerClass, AsyncClientResponseProvider.class)[0];
        this.injectProperties(provider.getClass(), provider);
        Class<?> asyncClass = Types.getRawType(asyncType);
        if (this.asyncClientResponseProviders == null) {
            this.asyncClientResponseProviders = new ConcurrentHashMap();
            this.asyncClientResponseProviders.putAll(this.parent.getAsyncClientResponseProviders());
        }
        this.asyncClientResponseProviders.put(asyncClass, provider);
    }

    private void addAsyncStreamProvider(AsyncStreamProvider provider, Class providerClass) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface(providerClass, AsyncStreamProvider.class)[0];
        this.injectProperties(provider.getClass(), provider);
        Class<?> asyncClass = Types.getRawType(asyncType);
        if (this.asyncStreamProviders == null) {
            this.asyncStreamProviders = new ConcurrentHashMap();
            this.asyncStreamProviders.putAll(this.parent.getAsyncStreamProviders());
        }
        this.asyncStreamProviders.put(asyncClass, provider);
    }

    private void addContextInjector(ContextInjector provider, Class providerClass) {
        Type[] typeArgs = Types.getActualTypeArgumentsOfAnInterface(providerClass, ContextInjector.class);
        this.injectProperties(provider.getClass(), provider);
        if (this.contextInjectors == null) {
            this.contextInjectors = new ConcurrentHashMap<Type, ContextInjector>();
            this.contextInjectors.putAll(this.parent.getContextInjectors());
        }
        this.contextInjectors.put(typeArgs[0], provider);
        if (!Objects.equals(typeArgs[0], typeArgs[1])) {
            if (this.asyncContextInjectors == null) {
                this.asyncContextInjectors = new ConcurrentHashMap<Type, ContextInjector>();
                this.asyncContextInjectors.putAll(this.parent.getAsyncContextInjectors());
            }
            this.asyncContextInjectors.put(typeArgs[1], provider);
        }
    }

    private void addContextResolver(ContextResolver provider, Class providerClass, boolean builtin) {
        MediaTypeMap<SortedKey<Object>> resolvers;
        if (providerClass.getName().contains("$$Lambda$")) {
            throw new RuntimeException(Messages.MESSAGES.registeringContextResolverAsLambda());
        }
        Type typeParameter = Types.getActualTypeArgumentsOfAnInterface(providerClass, ContextResolver.class)[0];
        this.injectProperties(providerClass, provider);
        Class<?> parameterClass = Types.getRawType(typeParameter);
        if (this.contextResolvers == null) {
            this.contextResolvers = new ConcurrentHashMap();
            for (Map.Entry<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> entry : this.parent.getContextResolvers().entrySet()) {
                this.contextResolvers.put(entry.getKey(), (MediaTypeMap<SortedKey<ContextResolver>>)entry.getValue().clone());
            }
        }
        if ((resolvers = this.contextResolvers.get(parameterClass)) == null) {
            resolvers = new MediaTypeMap();
            this.contextResolvers.put(parameterClass, resolvers);
        }
        Produces produces = provider.getClass().getAnnotation(Produces.class);
        int priority = ResteasyProviderFactory.getPriority(null, null, ContextResolver.class, providerClass);
        SortedKey<ContextResolver> key = new SortedKey<ContextResolver>(ContextResolver.class, provider, providerClass, priority, builtin);
        if (produces != null) {
            for (String produce : produces.value()) {
                MediaType mime = MediaType.valueOf((String)produce);
                resolvers.add(mime, key);
            }
        } else {
            resolvers.add(new MediaType("*", "*"), key);
        }
    }

    private void addStringParameterUnmarshaller(Class<? extends StringParameterUnmarshaller> provider) {
        Type[] intfs;
        if (this.stringParameterUnmarshallers == null) {
            this.stringParameterUnmarshallers = new ConcurrentHashMap();
            this.stringParameterUnmarshallers.putAll(this.parent.getStringParameterUnmarshallers());
        }
        for (Type type : intfs = provider.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(StringParameterUnmarshaller.class)) continue;
            Class<?> aClass = Types.getRawType(pt.getActualTypeArguments()[0]);
            this.stringParameterUnmarshallers.put(aClass, provider);
        }
    }

    public List<ContextResolver> getContextResolvers(Class<?> clazz, MediaType type) {
        MediaTypeMap<SortedKey<ContextResolver>> resolvers = this.getContextResolvers().get(clazz);
        if (resolvers == null) {
            return null;
        }
        ArrayList<ContextResolver> rtn = new ArrayList<ContextResolver>();
        List<SortedKey<ContextResolver>> list = resolvers.getPossible(type);
        if (type.isWildcardType()) {
            int i;
            for (i = list.size() - 1; i >= 0; --i) {
                if (((SortedKey)list.get(i)).isBuiltin) continue;
                rtn.add((ContextResolver)((SortedKey)list.get(i)).obj);
            }
            for (i = list.size() - 1; i >= 0; --i) {
                if (!((SortedKey)list.get(i)).isBuiltin) continue;
                rtn.add((ContextResolver)((SortedKey)list.get(i)).obj);
            }
        } else {
            for (SortedKey<ContextResolver> resolver : list) {
                rtn.add((ContextResolver)((SortedKey)resolver).obj);
            }
        }
        return rtn;
    }

    public ParamConverter getParamConverter(Class clazz, Type genericType, Annotation[] annotations) {
        for (SortedKey sortedKey : this.getSortedParamConverterProviders()) {
            ParamConverter converter = ((ParamConverterProvider)sortedKey.getObj()).getConverter(clazz, genericType, annotations);
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    public <T> StringParameterUnmarshaller<T> createStringParameterUnmarshaller(Class<T> clazz) {
        if (this.getStringParameterUnmarshallers().size() == 0) {
            return null;
        }
        Class<? extends StringParameterUnmarshaller> un = this.getStringParameterUnmarshallers().get(clazz);
        if (un == null) {
            return null;
        }
        StringParameterUnmarshaller provider = this.injectedInstance(un);
        return provider;
    }

    public void registerProvider(Class provider) {
        this.registerProvider(provider, false);
    }

    public String toString(Object object, Class clazz, Type genericType, Annotation[] annotations) {
        if (object instanceof String) {
            return (String)object;
        }
        ParamConverter paramConverter = this.getParamConverter(clazz, genericType, annotations);
        if (paramConverter != null) {
            return paramConverter.toString(object);
        }
        return object.toString();
    }

    @Override
    public String toHeaderString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        Class<?> aClass = object.getClass();
        ParamConverter paramConverter = this.getParamConverter(aClass, null, null);
        if (paramConverter != null) {
            return paramConverter.toString(object);
        }
        RuntimeDelegate.HeaderDelegate delegate = this.getHeaderDelegate(aClass);
        if (delegate != null) {
            return delegate.toString(object);
        }
        return object.toString();
    }

    public RuntimeDelegate.HeaderDelegate getHeaderDelegate(Class<?> aClass) {
        RuntimeDelegate.HeaderDelegate delegate = null;
        delegate = RuntimeDelegate.getInstance() instanceof ResteasyProviderFactory ? this.createHeaderDelegate(aClass) : RuntimeDelegate.getInstance().createHeaderDelegate(aClass);
        return delegate;
    }

    public void registerProvider(Class provider, boolean isBuiltin) {
        this.registerProvider(provider, null, isBuiltin, null);
    }

    protected static boolean isA(Class target, Class type, Map<Class<?>, Integer> contracts) {
        if (!type.isAssignableFrom(target)) {
            return false;
        }
        if (contracts == null || contracts.size() == 0) {
            return true;
        }
        for (Class<?> contract : contracts.keySet()) {
            if (!contract.equals(type)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isA(Object target, Class type, Map<Class<?>, Integer> contracts) {
        return ResteasyProviderFactory.isA(target.getClass(), type, contracts);
    }

    private static int getPriority(Integer override, Map<Class<?>, Integer> contracts, Class type, Class<?> component) {
        Integer p;
        if (override != null) {
            return override;
        }
        if (contracts != null && (p = contracts.get(type)) != null) {
            return p;
        }
        Priority priority = (component = component.isSynthetic() ? component.getSuperclass() : component).getAnnotation(Priority.class);
        if (priority == null) {
            return 5000;
        }
        return priority.value();
    }

    public void registerProvider(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts) {
        if (this.getClasses().contains(provider)) {
            LogMessages.LOGGER.providerClassAlreadyRegistered(provider.getName());
            return;
        }
        for (Object registered : this.getInstances()) {
            if (registered.getClass() != provider) continue;
            LogMessages.LOGGER.providerClassAlreadyRegistered(provider.getName());
            return;
        }
        HashMap newContracts = new HashMap();
        this.processProviderContracts(provider, priorityOverride, isBuiltin, contracts, newContracts);
        this.providerClasses.add(provider);
        this.getClassContracts().put(provider, newContracts);
    }

    protected void processProviderContracts(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts, Map<Class<?>, Integer> newContracts) {
        ConstrainedTo constrainedTo;
        int priority;
        if (ResteasyProviderFactory.isA(provider, ParamConverterProvider.class, contracts)) {
            ParamConverterProvider paramConverterProvider = (ParamConverterProvider)this.injectedInstance(provider);
            this.injectProperties(provider);
            if (this.sortedParamConverterProviders == null) {
                this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet<ExtSortedKey<ParamConverterProvider>>(this.parent.getSortedParamConverterProviders()));
            }
            priority = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ParamConverterProvider.class, provider);
            this.sortedParamConverterProviders.add(new ExtSortedKey<ParamConverterProvider>(null, paramConverterProvider, provider, priority, isBuiltin));
            newContracts.put(ParamConverterProvider.class, priority);
        }
        if (ResteasyProviderFactory.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                int priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider);
                this.addMessageBodyReader((MessageBodyReader)this.createProviderInstance(provider), provider, priority2, isBuiltin);
                newContracts.put(MessageBodyReader.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                int priority3 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider);
                this.addMessageBodyWriter((MessageBodyWriter)this.createProviderInstance(provider), provider, priority3, isBuiltin);
                newContracts.put(MessageBodyWriter.class, priority3);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, ExceptionMapper.class, contracts)) {
            try {
                this.addExceptionMapper((ExceptionMapper)this.createProviderInstance(provider), provider, isBuiltin);
                newContracts.put(ExceptionMapper.class, ResteasyProviderFactory.getPriority(priorityOverride, contracts, ExceptionMapper.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, AsyncResponseProvider.class, contracts)) {
            try {
                this.addAsyncResponseProvider((AsyncResponseProvider)this.createProviderInstance(provider), provider);
                newContracts.put(AsyncResponseProvider.class, ResteasyProviderFactory.getPriority(priorityOverride, contracts, AsyncResponseProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncResponseProvider(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, AsyncClientResponseProvider.class, contracts)) {
            try {
                this.addAsyncClientResponseProvider((AsyncClientResponseProvider)this.createProviderInstance(provider), provider);
                newContracts.put(AsyncClientResponseProvider.class, ResteasyProviderFactory.getPriority(priorityOverride, contracts, AsyncClientResponseProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncClientResponseProvider(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, AsyncStreamProvider.class, contracts)) {
            try {
                this.addAsyncStreamProvider((AsyncStreamProvider)this.createProviderInstance(provider), provider);
                newContracts.put(AsyncStreamProvider.class, ResteasyProviderFactory.getPriority(priorityOverride, contracts, AsyncStreamProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncStreamProvider(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, ClientRequestFilter.class, contracts)) {
            if (this.clientRequestFilterRegistry == null) {
                this.clientRequestFilterRegistry = this.parent.getClientRequestFilterRegistry().clone(this);
            }
            int priority4 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ClientRequestFilter.class, provider);
            this.clientRequestFilterRegistry.registerClass(provider, priority4);
            newContracts.put(ClientRequestFilter.class, priority4);
        }
        if (ResteasyProviderFactory.isA(provider, ClientResponseFilter.class, contracts)) {
            if (this.clientResponseFilters == null) {
                this.clientResponseFilters = this.parent.getClientResponseFilters().clone(this);
            }
            int priority5 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ClientResponseFilter.class, provider);
            this.clientResponseFilters.registerClass(provider, priority5);
            newContracts.put(ClientResponseFilter.class, priority5);
        }
        if (ResteasyProviderFactory.isA(provider, ContainerRequestFilter.class, contracts)) {
            if (this.containerRequestFilterRegistry == null) {
                this.containerRequestFilterRegistry = this.parent.getContainerRequestFilterRegistry().clone(this);
            }
            int priority6 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ContainerRequestFilter.class, provider);
            this.containerRequestFilterRegistry.registerClass(provider, priority6);
            newContracts.put(ContainerRequestFilter.class, priority6);
        }
        if (ResteasyProviderFactory.isA(provider, ContainerResponseFilter.class, contracts)) {
            if (this.containerResponseFilterRegistry == null) {
                this.containerResponseFilterRegistry = this.parent.getContainerResponseFilterRegistry().clone(this);
            }
            int priority7 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ContainerResponseFilter.class, provider);
            this.containerResponseFilterRegistry.registerClass(provider, priority7);
            newContracts.put(ContainerResponseFilter.class, priority7);
        }
        if (ResteasyProviderFactory.isA(provider, ReaderInterceptor.class, contracts)) {
            constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerClass(provider, priority);
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerClass(provider, priority);
            }
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (ResteasyProviderFactory.isA(provider, WriterInterceptor.class, contracts)) {
            constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = ResteasyProviderFactory.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerClass(provider, priority);
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerClass(provider, priority);
            }
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (ResteasyProviderFactory.isA(provider, ContextResolver.class, contracts)) {
            try {
                this.addContextResolver((ContextResolver)this.createProviderInstance(provider), provider, isBuiltin);
                int priority8 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ContextResolver.class, provider);
                newContracts.put(ContextResolver.class, priority8);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextResolver(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, ContextInjector.class, contracts)) {
            try {
                this.addContextInjector((ContextInjector)this.createProviderInstance(provider), provider);
                int priority9 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ContextInjector.class, provider);
                newContracts.put(ContextInjector.class, priority9);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextInjector(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, StringParameterUnmarshaller.class, contracts)) {
            this.addStringParameterUnmarshaller(provider);
            int priority10 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, StringParameterUnmarshaller.class, provider);
            newContracts.put(StringParameterUnmarshaller.class, priority10);
        }
        if (ResteasyProviderFactory.isA(provider, InjectorFactory.class, contracts)) {
            try {
                this.injectorFactory = (InjectorFactory)provider.newInstance();
                newContracts.put(InjectorFactory.class, 0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, DynamicFeature.class, contracts)) {
            ConstrainedTo constrainedTo2 = provider.getAnnotation(ConstrainedTo.class);
            priority = ResteasyProviderFactory.getPriority(priorityOverride, contracts, DynamicFeature.class, provider);
            if (constrainedTo2 != null && constrainedTo2.value() == RuntimeType.SERVER) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)this.injectedInstance(provider));
            }
            if (constrainedTo2 != null && constrainedTo2.value() == RuntimeType.CLIENT) {
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)this.injectedInstance(provider));
            }
            if (constrainedTo2 == null) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)this.injectedInstance(provider));
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)this.injectedInstance(provider));
            }
            newContracts.put(DynamicFeature.class, priority);
        }
        if (ResteasyProviderFactory.isA(provider, Feature.class, contracts)) {
            ConstrainedTo constrainedTo3 = provider.getAnnotation(ConstrainedTo.class);
            priority = ResteasyProviderFactory.getPriority(priorityOverride, contracts, Feature.class, provider);
            Feature feature = (Feature)this.injectedInstance(provider);
            if ((constrainedTo3 == null || constrainedTo3.value() == this.getRuntimeType()) && feature.configure((FeatureContext)new FeatureContextDelegate(this))) {
                this.enabledFeatures.add(feature);
            }
            newContracts.put(Feature.class, priority);
        }
        if (ResteasyProviderFactory.isA(provider, RxInvokerProvider.class, contracts)) {
            int priority11 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, RxInvokerProvider.class, provider);
            newContracts.put(RxInvokerProvider.class, priority11);
            Class clazz = Types.getTemplateParameterOfInterface(provider, RxInvokerProvider.class);
            clazz = Types.getTemplateParameterOfInterface(clazz, RxInvoker.class);
            if (clazz != null) {
                this.reactiveClasses.put(clazz, provider);
            }
        }
        if (ResteasyProviderFactory.isA(provider, ResourceClassProcessor.class, contracts)) {
            int priority12 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ResourceClassProcessor.class, provider);
            this.addResourceClassProcessor(provider, priority12);
            newContracts.put(ResourceClassProcessor.class, priority12);
        }
    }

    public void registerProviderInstance(Object provider) {
        this.registerProviderInstance(provider, null, null, false);
    }

    public void registerProviderInstance(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn) {
        for (Object registered : this.getInstances()) {
            if (registered != provider) continue;
            LogMessages.LOGGER.providerInstanceAlreadyRegistered(provider.getClass().getName());
            return;
        }
        if (this.getClasses().contains(provider.getClass())) {
            LogMessages.LOGGER.providerClassAlreadyRegistered(provider.getClass().getName());
            return;
        }
        HashMap newContracts = new HashMap();
        this.processProviderInstanceContracts(provider, contracts, priorityOverride, builtIn, newContracts);
        this.providerInstances.add(provider);
        this.getClassContracts().put(provider.getClass(), newContracts);
    }

    protected void processProviderInstanceContracts(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn, Map<Class<?>, Integer> newContracts) {
        int priority;
        int priority2;
        if (ResteasyProviderFactory.isA(provider, ParamConverterProvider.class, contracts)) {
            this.injectProperties(provider);
            if (this.sortedParamConverterProviders == null) {
                this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet<ExtSortedKey<ParamConverterProvider>>(this.parent.getSortedParamConverterProviders()));
            }
            priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ParamConverterProvider.class, provider.getClass());
            this.sortedParamConverterProviders.add(new ExtSortedKey<ParamConverterProvider>(null, (ParamConverterProvider)provider, provider.getClass(), priority2, builtIn));
            newContracts.put(ParamConverterProvider.class, priority2);
        }
        if (ResteasyProviderFactory.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider.getClass());
                this.addMessageBodyReader((MessageBodyReader)provider, provider.getClass(), priority2, builtIn);
                newContracts.put(MessageBodyReader.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider.getClass());
                this.addMessageBodyWriter((MessageBodyWriter)provider, provider.getClass(), priority2, builtIn);
                newContracts.put(MessageBodyWriter.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, ExceptionMapper.class, contracts)) {
            try {
                this.addExceptionMapper((ExceptionMapper)provider, provider.getClass(), builtIn);
                priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ExceptionMapper.class, provider.getClass());
                newContracts.put(ExceptionMapper.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, AsyncResponseProvider.class, contracts)) {
            try {
                this.addAsyncResponseProvider((AsyncResponseProvider)provider, provider.getClass());
                priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, AsyncResponseProvider.class, provider.getClass());
                newContracts.put(AsyncResponseProvider.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncResponseProvider(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, AsyncClientResponseProvider.class, contracts)) {
            try {
                this.addAsyncClientResponseProvider((AsyncClientResponseProvider)provider, provider.getClass());
                priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, AsyncClientResponseProvider.class, provider.getClass());
                newContracts.put(AsyncClientResponseProvider.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncClientResponseProvider(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, AsyncStreamProvider.class, contracts)) {
            try {
                this.addAsyncStreamProvider((AsyncStreamProvider)provider, provider.getClass());
                priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, AsyncStreamProvider.class, provider.getClass());
                newContracts.put(AsyncStreamProvider.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncStreamProvider(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, ContextResolver.class, contracts)) {
            try {
                this.addContextResolver((ContextResolver)provider, provider.getClass(), false);
                priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ContextResolver.class, provider.getClass());
                newContracts.put(ContextResolver.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextResolver(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, ContextInjector.class, contracts)) {
            try {
                this.addContextInjector((ContextInjector)provider, provider.getClass());
                priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ContextInjector.class, provider.getClass());
                newContracts.put(ContextInjector.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextInjector(), e);
            }
        }
        if (ResteasyProviderFactory.isA(provider, ClientRequestFilter.class, contracts)) {
            if (this.clientRequestFilterRegistry == null) {
                this.clientRequestFilterRegistry = this.parent.getClientRequestFilterRegistry().clone(this);
            }
            priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ClientRequestFilter.class, provider.getClass());
            this.clientRequestFilterRegistry.registerSingleton((ClientRequestFilter)provider, priority2);
            newContracts.put(ClientRequestFilter.class, priority2);
        }
        if (ResteasyProviderFactory.isA(provider, ClientResponseFilter.class, contracts)) {
            if (this.clientResponseFilters == null) {
                this.clientResponseFilters = this.parent.getClientResponseFilters().clone(this);
            }
            priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ClientResponseFilter.class, provider.getClass());
            this.clientResponseFilters.registerSingleton((ClientResponseFilter)provider, priority2);
            newContracts.put(ClientResponseFilter.class, priority2);
        }
        if (ResteasyProviderFactory.isA(provider, ContainerRequestFilter.class, contracts)) {
            if (this.containerRequestFilterRegistry == null) {
                this.containerRequestFilterRegistry = this.parent.getContainerRequestFilterRegistry().clone(this);
            }
            priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ContainerRequestFilter.class, provider.getClass());
            this.containerRequestFilterRegistry.registerSingleton((ContainerRequestFilter)provider, priority2);
            newContracts.put(ContainerRequestFilter.class, priority2);
        }
        if (ResteasyProviderFactory.isA(provider, ContainerResponseFilter.class, contracts)) {
            if (this.containerResponseFilterRegistry == null) {
                this.containerResponseFilterRegistry = this.parent.getContainerResponseFilterRegistry().clone(this);
            }
            priority2 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ContainerResponseFilter.class, provider.getClass());
            this.containerResponseFilterRegistry.registerSingleton((ContainerResponseFilter)provider, priority2);
            newContracts.put(ContainerResponseFilter.class, priority2);
        }
        if (ResteasyProviderFactory.isA(provider, ReaderInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerSingleton((ReaderInterceptor)provider, priority);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerSingleton((ReaderInterceptor)provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerSingleton((ReaderInterceptor)provider, priority);
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerSingleton((ReaderInterceptor)provider, priority);
            }
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (ResteasyProviderFactory.isA(provider, WriterInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = ResteasyProviderFactory.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerSingleton((WriterInterceptor)provider, priority);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerSingleton((WriterInterceptor)provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerSingleton((WriterInterceptor)provider, priority);
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerSingleton((WriterInterceptor)provider, priority);
            }
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (ResteasyProviderFactory.isA(provider, InjectorFactory.class, contracts)) {
            this.injectorFactory = (InjectorFactory)provider;
            newContracts.put(InjectorFactory.class, 0);
        }
        if (ResteasyProviderFactory.isA(provider, DynamicFeature.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = ResteasyProviderFactory.getPriority(priorityOverride, contracts, DynamicFeature.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)provider);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)provider);
            }
            if (constrainedTo == null) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)provider);
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)provider);
            }
            newContracts.put(DynamicFeature.class, priority);
        }
        if (ResteasyProviderFactory.isA(provider, Feature.class, contracts)) {
            Feature feature = (Feature)provider;
            this.injectProperties(provider.getClass(), provider);
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            if ((constrainedTo == null || constrainedTo.value() == this.getRuntimeType()) && feature.configure((FeatureContext)new FeatureContextDelegate(this))) {
                this.enabledFeatures.add(feature);
            }
            int priority3 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, Feature.class, provider.getClass());
            newContracts.put(Feature.class, priority3);
        }
        if (ResteasyProviderFactory.isA(provider, ResourceClassProcessor.class, contracts)) {
            int priority4 = ResteasyProviderFactory.getPriority(priorityOverride, contracts, ResourceClassProcessor.class, provider.getClass());
            this.addResourceClassProcessor((ResourceClassProcessor)provider, priority4);
            newContracts.put(ResourceClassProcessor.class, priority4);
        }
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        Class<T> exceptionType = type;
        SortedKey<ExceptionMapper> mapper = null;
        while (mapper == null && exceptionType != null) {
            mapper = this.getSortedExceptionMappers().get(exceptionType);
            if (mapper != null) continue;
            exceptionType = exceptionType.getSuperclass();
        }
        return mapper != null ? (ExceptionMapper)mapper.getObj() : null;
    }

    public <T> AsyncResponseProvider<T> getAsyncResponseProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncResponseProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncResponseProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public <T> AsyncClientResponseProvider<T> getAsyncClientResponseProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncClientResponseProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncClientResponseProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public <T> AsyncStreamProvider<T> getAsyncStreamProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncStreamProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncStreamProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public MediaType getConcreteMediaTypeFromMessageBodyWriters(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<SortedKey<MessageBodyWriter>> writers = this.getServerMessageBodyWriters().getPossible(mediaType, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            Produces produces;
            MessageBodyWriter mbw;
            Class writerType;
            if (!((MessageBodyWriter)((SortedKey)writer).obj).isWriteable(type, genericType, annotations, mediaType) || (writerType = Types.getTemplateParameterOfInterface((mbw = (MessageBodyWriter)((SortedKey)writer).obj).getClass(), MessageBodyWriter.class)) == null || writerType.equals(Object.class) || !writerType.isAssignableFrom(type) || (produces = mbw.getClass().getAnnotation(Produces.class)) == null) continue;
            for (String produce : produces.value()) {
                MediaType mt = MediaType.valueOf((String)produce);
                if (mt.isWildcardType() || mt.isWildcardSubtype()) continue;
                return mt;
            }
        }
        return null;
    }

    public Map<MessageBodyWriter<?>, Class<?>> getPossibleMessageBodyWritersMap(Class type, Type genericType, Annotation[] annotations, MediaType accept) {
        HashMap map = new HashMap();
        List<SortedKey<MessageBodyWriter>> writers = this.getServerMessageBodyWriters().getPossible(accept, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            Class writerType;
            if (!((MessageBodyWriter)((SortedKey)writer).obj).isWriteable(type, genericType, annotations, accept)) continue;
            Class<?> mbwc = ((MessageBodyWriter)((SortedKey)writer).obj).getClass();
            if (!mbwc.isInterface() && mbwc.getSuperclass() != null && !mbwc.getSuperclass().equals(Object.class) && mbwc.isSynthetic()) {
                mbwc = mbwc.getSuperclass();
            }
            if ((writerType = Types.getTemplateParameterOfInterface(mbwc, MessageBodyWriter.class)) == null || !writerType.isAssignableFrom(type)) continue;
            map.put((MessageBodyWriter<?>)((SortedKey)writer).obj, writerType);
        }
        return map;
    }

    @Deprecated
    public <T> MessageBodyWriter<T> getServerMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
    }

    public <T> MessageBodyWriter<T> getServerMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, RESTEasyTracingLogger tracingLogger) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters, tracingLogger);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        MessageBodyWriter<T> writer = this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
        if (writer != null) {
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
        }
        return writer;
    }

    public <T> MessageBodyWriter<T> getClientMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getClientMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
    }

    @Deprecated
    private <T> MessageBodyWriter<T> resolveMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters) {
        List<SortedKey<MessageBodyWriter>> writers = availableWriters.getPossible(mediaType, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            if (!((MessageBodyWriter)((SortedKey)writer).obj).isWriteable(type, genericType, annotations, mediaType)) continue;
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
            return (MessageBodyWriter)((SortedKey)writer).obj;
        }
        return null;
    }

    protected <T> MessageBodyWriter<T> resolveMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters, RESTEasyTracingLogger tracingLogger) {
        SortedKey<MessageBodyWriter> writer;
        List<SortedKey<MessageBodyWriter>> writers = availableWriters.getPossible(mediaType, type);
        if (tracingLogger.isLogEnabled("MBW_FIND")) {
            tracingLogger.log("MBW_FIND", type.getName(), genericType instanceof Class ? ((Class)genericType).getName() : genericType, mediaType, Arrays.toString(annotations));
        }
        MessageBodyWriter result = null;
        Iterator<SortedKey<MessageBodyWriter>> iterator = writers.iterator();
        while (iterator.hasNext()) {
            writer = iterator.next();
            if (((MessageBodyWriter)((SortedKey)writer).obj).isWriteable(type, genericType, annotations, mediaType)) {
                LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
                result = (MessageBodyWriter)((SortedKey)writer).obj;
                tracingLogger.log("MBW_SELECTED", result);
                break;
            }
            tracingLogger.log("MBW_NOT_WRITEABLE", result);
        }
        if (tracingLogger.isLogEnabled("MBW_SKIPPED")) {
            while (iterator.hasNext()) {
                writer = iterator.next();
                tracingLogger.log("MBW_SKIPPED", ((SortedKey)writer).obj);
            }
        }
        return result;
    }

    public <T> T createEndpoint(Application applicationConfig, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        if (applicationConfig == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.applicationParamNull());
        }
        throw new UnsupportedOperationException();
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        final List<ContextResolver> resolvers = this.getContextResolvers(contextType, mediaType);
        if (resolvers == null) {
            return null;
        }
        if (resolvers.size() == 1) {
            return resolvers.get(0);
        }
        return new ContextResolver<T>(){

            public T getContext(Class type) {
                for (ContextResolver resolver : resolvers) {
                    Object rtn = resolver.getContext(type);
                    if (rtn == null) continue;
                    return rtn;
                }
                return null;
            }
        };
    }

    public <T> T createProviderInstance(Class<? extends T> clazz) {
        ConstructorInjector constructorInjector = this.createConstructorInjector(clazz);
        T provider = constructorInjector.construct(false).toCompletableFuture().getNow(null);
        return provider;
    }

    private <T> ConstructorInjector createConstructorInjector(Class<? extends T> clazz) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        if (constructor == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.unableToFindPublicConstructorForProvider(clazz.getName()));
        }
        return this.getInjectorFactory().createConstructor(constructor, this);
    }

    public <T> T injectedInstance(Class<? extends T> clazz) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        ConstructorInjector constructorInjector = this.getInjectorFactory().createConstructor(constructor, this);
        return constructorInjector.construct(false).thenCompose(obj -> {
            PropertyInjector propertyInjector = this.getInjectorFactory().createPropertyInjector(clazz, this);
            return propertyInjector.inject(obj, false).thenApply(val -> obj);
        }).toCompletableFuture().getNow(null);
    }

    public <T> T injectedInstance(Class<? extends T> clazz, HttpRequest request, HttpResponse response) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        T obj = null;
        if (constructor == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.unableToFindPublicConstructorForClass(clazz.getName()));
        }
        ConstructorInjector constructorInjector = this.getInjectorFactory().createConstructor(constructor, this);
        obj = constructorInjector.construct(request, response, false).toCompletableFuture().getNow(null);
        PropertyInjector propertyInjector = this.getInjectorFactory().createPropertyInjector(clazz, this);
        propertyInjector.inject(request, response, obj, false).toCompletableFuture().getNow(null);
        return obj;
    }

    private void injectProperties(Class declaring, Object obj) {
        this.getInjectorFactory().createPropertyInjector(declaring, this).inject(obj, false).toCompletableFuture().getNow(null);
    }

    public void injectProperties(Object obj) {
        this.getInjectorFactory().createPropertyInjector(obj.getClass(), this).inject(obj, false).toCompletableFuture().getNow(null);
    }

    public void injectProperties(Object obj, HttpRequest request, HttpResponse response) {
        this.getInjectorFactory().createPropertyInjector(obj.getClass(), this).inject(request, response, obj, false).toCompletableFuture().getNow(null);
    }

    public Map<String, Object> getMutableProperties() {
        return this.properties;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public ResteasyProviderFactory setProperties(Map<String, ?> properties) {
        ConcurrentHashMap<String, Object> newProp = new ConcurrentHashMap<String, Object>();
        newProp.putAll(properties);
        this.properties = newProp;
        return this;
    }

    public ResteasyProviderFactory property(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        return this;
    }

    public Collection<Feature> getEnabledFeatures() {
        if (this.enabledFeatures == null && this.parent != null) {
            return this.parent.getEnabledFeatures();
        }
        HashSet<Feature> set = new HashSet<Feature>();
        if (this.parent != null) {
            set.addAll(this.parent.getEnabledFeatures());
        }
        set.addAll(this.enabledFeatures);
        return set;
    }

    public ResteasyProviderFactory register(Class<?> providerClass) {
        this.registerProvider(providerClass);
        return this;
    }

    public ResteasyProviderFactory register(Object provider) {
        this.registerProviderInstance(provider);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, int priority) {
        this.registerProvider(componentClass, priority, false, null);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LogMessages.LOGGER.attemptingToRegisterEmptyContracts(componentClass.getName());
            return this;
        }
        HashMap cons = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(componentClass)) {
                LogMessages.LOGGER.attemptingToRegisterUnassignableContract(componentClass.getName());
                return this;
            }
            cons.put(contract, 5000);
        }
        this.registerProvider(componentClass, null, false, cons);
        return this;
    }

    public ResteasyProviderFactory register(Object component, int priority) {
        this.registerProviderInstance(component, null, priority, false);
        return this;
    }

    public ResteasyProviderFactory register(Object component, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LogMessages.LOGGER.attemptingToRegisterEmptyContracts(component.getClass().getName());
            return this;
        }
        HashMap cons = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(component.getClass())) {
                LogMessages.LOGGER.attemptingToRegisterUnassignableContract(component.getClass().getName());
                return this;
            }
            cons.put(contract, 5000);
        }
        this.registerProviderInstance(component, cons, null, false);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        for (Class<?> contract : contracts.keySet()) {
            if (contract.isAssignableFrom(componentClass)) continue;
            LogMessages.LOGGER.attemptingToRegisterUnassignableContract(componentClass.getName());
            return this;
        }
        this.registerProvider(componentClass, null, false, contracts);
        return this;
    }

    public ResteasyProviderFactory register(Object component, Map<Class<?>, Integer> contracts) {
        for (Class<?> contract : contracts.keySet()) {
            if (contract.isAssignableFrom(component.getClass())) continue;
            LogMessages.LOGGER.attemptingToRegisterUnassignableContract(component.getClass().getName());
            return this;
        }
        this.registerProviderInstance(component, contracts, null, false);
        return this;
    }

    public Configuration getConfiguration() {
        return this;
    }

    public RuntimeType getRuntimeType() {
        return RuntimeType.SERVER;
    }

    public Collection<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public boolean isEnabled(Feature feature) {
        Collection<Feature> enabled = this.getEnabledFeatures();
        for (Feature f : enabled) {
            if (f != feature) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        Collection<Feature> enabled = this.getEnabledFeatures();
        if (enabled == null) {
            return false;
        }
        for (Feature feature : enabled) {
            if (!featureClass.equals(feature.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Object component) {
        return this.getProviderInstances().contains(component);
    }

    public boolean isRegistered(Class<?> componentClass) {
        if (this.getProviderClasses().contains(componentClass)) {
            return true;
        }
        for (Object obj : this.getProviderInstances()) {
            if (!obj.getClass().equals(componentClass)) continue;
            return true;
        }
        return false;
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        if (this.classContracts == null && this.parent == null) {
            return Collections.emptyMap();
        }
        if (this.classContracts == null) {
            return this.parent.getContracts(componentClass);
        }
        Map<Class<?>, Integer> classIntegerMap = this.classContracts.get(componentClass);
        if (classIntegerMap == null) {
            return Collections.emptyMap();
        }
        return classIntegerMap;
    }

    public Set<Class<?>> getClasses() {
        return this.getProviderClasses();
    }

    public Set<Object> getInstances() {
        return this.getProviderInstances();
    }

    public Link.Builder createLinkBuilder() {
        return new LinkBuilderImpl();
    }

    public <I extends RxInvoker> RxInvokerProvider<I> getRxInvokerProvider(Class<I> clazz) {
        for (Map.Entry<Class<?>, Map<Class<?>, Integer>> entry : this.classContracts.entrySet()) {
            RxInvokerProvider rip;
            if (!entry.getValue().containsKey(RxInvokerProvider.class) || !(rip = (RxInvokerProvider)this.createProviderInstance(entry.getKey())).isProviderFor(clazz)) continue;
            return rip;
        }
        return null;
    }

    public RxInvokerProvider<?> getRxInvokerProviderFromReactiveClass(Class<?> clazz) {
        Class<? extends RxInvokerProvider<?>> rxInvokerProviderClass = this.reactiveClasses.get(clazz);
        if (rxInvokerProviderClass != null) {
            return this.createProviderInstance(rxInvokerProviderClass);
        }
        return null;
    }

    public boolean isReactive(Class<?> clazz) {
        return this.reactiveClasses.keySet().contains(clazz);
    }

    private void addResourceClassProcessor(Class<ResourceClassProcessor> processorClass, int priority) {
        ResourceClassProcessor processor = this.createProviderInstance(processorClass);
        this.addResourceClassProcessor(processor, priority);
    }

    private void addResourceClassProcessor(ResourceClassProcessor processor, int priority) {
        this.resourceBuilder.registerResourceClassProcessor(processor, priority);
    }

    public ResourceBuilder getResourceBuilder() {
        return this.resourceBuilder;
    }

    static {
        registerBuiltinByDefault = true;
        RD_LOCK = new Object();
    }

    private static class ExtSortedKey<T>
    extends SortedKey<T> {
        protected ExtSortedKey(Class<?> intf, T reader, Class<?> readerClass, int priority, boolean isBuiltin) {
            super(intf, reader, readerClass, priority, isBuiltin);
        }

        protected ExtSortedKey(Class<?> intf, T reader, Class<?> readerClass, boolean isBuiltin) {
            super(intf, reader, readerClass, isBuiltin);
        }

        protected ExtSortedKey(Class<?> intf, T reader, Class<?> readerClass) {
            super(intf, reader, readerClass);
        }

        @Override
        public int compareTo(SortedKey<T> tMessageBodyKey) {
            int c = super.compareTo(tMessageBodyKey);
            if (c != 0) {
                return c;
            }
            if (this.getObj() == tMessageBodyKey.getObj()) {
                return 0;
            }
            return -1;
        }
    }

    private static class SortedKey<T>
    implements Comparable<SortedKey<T>>,
    MediaTypeMap.Typed {
        private final T obj;
        private final boolean isBuiltin;
        private final Class<?> template;
        private final int priority;

        protected SortedKey(Class<?> intf, T reader, Class<?> readerClass, int priority, boolean isBuiltin) {
            this.obj = reader;
            Class<Object> t = Types.getTemplateParameterOfInterface(readerClass, intf);
            this.template = t != null ? t : Object.class;
            this.priority = priority;
            this.isBuiltin = isBuiltin;
        }

        protected SortedKey(Class<?> intf, T reader, Class<?> readerClass, boolean isBuiltin) {
            this(intf, reader, readerClass, 5000, isBuiltin);
        }

        protected SortedKey(Class<?> intf, T reader, Class<?> readerClass) {
            this(intf, reader, readerClass, 5000, false);
        }

        @Override
        public int compareTo(SortedKey<T> tMessageBodyKey) {
            if (this == tMessageBodyKey) {
                return 0;
            }
            if (this.isBuiltin == tMessageBodyKey.isBuiltin) {
                if (this.priority < tMessageBodyKey.priority) {
                    return -1;
                }
                if (this.priority == tMessageBodyKey.priority) {
                    return 0;
                }
                if (this.priority > tMessageBodyKey.priority) {
                    return 1;
                }
            }
            if (this.isBuiltin) {
                return 1;
            }
            return -1;
        }

        @Override
        public Class<?> getType() {
            return this.template;
        }

        public T getObj() {
            return this.obj;
        }
    }
}

