/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.reactivecontexts.core;

import io.reactiverse.reactivecontexts.core.Context;
import io.reactiverse.reactivecontexts.core.ContextState;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

final class CompletionStageWrapper<T>
implements CompletionStage<T> {
    private final ContextState state;
    private final CompletionStage<T> f;

    CompletionStageWrapper(ContextState state, CompletionStage<T> f) {
        this.state = state;
        this.f = f;
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return Context.wrap(this.f.toCompletableFuture());
    }

    @Override
    public CompletionStage<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return Context.wrap(this.state, this.f.exceptionally(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return Context.wrap(this.state, this.f.handle(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return Context.wrap(this.state, this.f.handleAsync(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return Context.wrap(this.state, this.f.handleAsync(Context.wrap(this.state, fn), executor));
    }

    @Override
    public <U> CompletionStage<U> thenApply(Function<? super T, ? extends U> fn) {
        return Context.wrap(this.state, this.f.thenApply(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return Context.wrap(this.state, this.f.thenApplyAsync(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return Context.wrap(this.state, this.f.thenApplyAsync(Context.wrap(this.state, fn), executor));
    }

    @Override
    public CompletionStage<Void> thenAccept(Consumer<? super T> action) {
        return Context.wrap(this.state, this.f.thenAccept(Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action) {
        return Context.wrap(this.state, this.f.thenAcceptAsync(Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return Context.wrap(this.state, this.f.thenAcceptAsync(Context.wrap(this.state, action), executor));
    }

    @Override
    public CompletionStage<Void> thenRun(Runnable action) {
        return Context.wrap(this.state, this.f.thenRun(Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action) {
        return Context.wrap(this.state, this.f.thenRunAsync(Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return Context.wrap(this.state, this.f.thenRunAsync(Context.wrap(this.state, action), executor));
    }

    @Override
    public <U, V> CompletionStage<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return Context.wrap(this.state, this.f.thenCombine(other, Context.wrap(this.state, fn)));
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return Context.wrap(this.state, this.f.thenCombineAsync(other, Context.wrap(this.state, fn)));
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return Context.wrap(this.state, this.f.thenCombineAsync(other, Context.wrap(this.state, fn), executor));
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return Context.wrap(this.state, this.f.thenAcceptBoth(other, Context.wrap(this.state, action)));
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return Context.wrap(this.state, this.f.thenAcceptBothAsync(other, Context.wrap(this.state, action)));
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return Context.wrap(this.state, this.f.thenAcceptBothAsync(other, Context.wrap(this.state, action), executor));
    }

    @Override
    public CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return Context.wrap(this.state, this.f.runAfterBoth(other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return Context.wrap(this.state, this.f.runAfterBothAsync(other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return Context.wrap(this.state, this.f.runAfterBothAsync(other, Context.wrap(this.state, action), executor));
    }

    @Override
    public <U> CompletionStage<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return Context.wrap(this.state, this.f.applyToEither(other, Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return Context.wrap(this.state, this.f.applyToEitherAsync(other, Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return Context.wrap(this.state, this.f.applyToEitherAsync(other, Context.wrap(this.state, fn), executor));
    }

    @Override
    public CompletionStage<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return Context.wrap(this.state, this.f.acceptEither(other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return Context.wrap(this.state, this.f.acceptEitherAsync(other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return Context.wrap(this.state, this.f.acceptEitherAsync(other, Context.wrap(this.state, action), executor));
    }

    @Override
    public CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return Context.wrap(this.state, this.f.runAfterEither(other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return Context.wrap(this.state, this.f.runAfterEitherAsync(other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return Context.wrap(this.state, this.f.runAfterEitherAsync(other, Context.wrap(this.state, action), executor));
    }

    @Override
    public <U> CompletionStage<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return Context.wrap(this.state, this.f.thenCompose(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return Context.wrap(this.state, this.f.thenComposeAsync(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return Context.wrap(this.state, this.f.thenComposeAsync(Context.wrap(this.state, fn), executor));
    }

    @Override
    public CompletionStage<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return Context.wrap(this.state, this.f.whenComplete(Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return Context.wrap(this.state, this.f.whenCompleteAsync(Context.wrap(this.state, action)));
    }

    @Override
    public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return Context.wrap(this.state, this.f.whenCompleteAsync(Context.wrap(this.state, action), executor));
    }

    public String toString() {
        return this.f.toString();
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public boolean equals(Object obj) {
        return this.f.equals(obj);
    }
}

