/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import java.lang.reflect.Type;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.OutboundSseEvent;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class OutboundSseEventImpl
implements OutboundSseEvent {
    private final String name;
    private final String comment;
    private final String id;
    private final GenericType type;
    private final MediaType mediaType;
    private final Object data;
    private final long reconnectDelay;

    OutboundSseEventImpl(String name, String id, long reconnectDelay, GenericType type, MediaType mediaType, Object data, String comment) {
        this.name = name;
        this.comment = comment;
        this.id = id;
        this.reconnectDelay = reconnectDelay;
        this.type = type;
        this.mediaType = mediaType;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public boolean isReconnectDelaySet() {
        return this.reconnectDelay > -1L;
    }

    public Class<?> getType() {
        return this.type == null ? null : this.type.getRawType();
    }

    public Type getGenericType() {
        return this.type == null ? null : this.type.getType();
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getComment() {
        return this.comment;
    }

    public Object getData() {
        return this.data;
    }

    public static class BuilderImpl
    implements OutboundSseEvent.Builder {
        private String name;
        private String comment;
        private String id;
        private long reconnectDelay = -1L;
        private GenericType type;
        private Object data;
        private MediaType mediaType = MediaType.SERVER_SENT_EVENTS_TYPE;

        public OutboundSseEvent.Builder name(String name) {
            this.name = name;
            return this;
        }

        public OutboundSseEvent.Builder id(String id) {
            this.id = id;
            return this;
        }

        public OutboundSseEvent.Builder reconnectDelay(long milliseconds) {
            if (milliseconds < 0L) {
                milliseconds = -1L;
            }
            this.reconnectDelay = milliseconds;
            return this;
        }

        public OutboundSseEvent.Builder mediaType(MediaType mediaType) {
            if (mediaType == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("mediaType"));
            }
            this.mediaType = mediaType;
            return this;
        }

        public OutboundSseEvent.Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public OutboundSseEvent.Builder data(Class type, Object data) {
            if (type == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("type"));
            }
            if (data == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("data"));
            }
            this.type = new GenericType((Type)type);
            this.data = data;
            return this;
        }

        public OutboundSseEvent.Builder data(GenericType type, Object data) {
            if (type == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("type"));
            }
            if (data == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("data"));
            }
            this.type = type;
            this.data = data;
            return this;
        }

        public OutboundSseEvent.Builder data(Object data) {
            if (data == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("data"));
            }
            GenericType genericType = null;
            genericType = data instanceof GenericEntity ? new GenericType(((GenericEntity)data).getType()) : (data == null ? null : new GenericType(data.getClass()));
            return this.data(genericType, data);
        }

        public OutboundSseEvent build() {
            return new OutboundSseEventImpl(this.name, this.id, this.reconnectDelay, this.type, this.mediaType, this.data, this.comment);
        }
    }
}

