/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.NoLogWebApplicationException;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.spi.WriterException;
import org.jboss.resteasy.tracing.RESTEasyServerTracingEvent;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.tracing.RESTEasyTracingLoggerImpl;

public class ExceptionHandler {
    protected ResteasyProviderFactory providerFactory;
    protected Set<String> unwrappedExceptions = new HashSet<String>();
    protected boolean mapperExecuted;

    public ExceptionHandler(ResteasyProviderFactory providerFactory, Set<String> unwrappedExceptions) {
        this.providerFactory = providerFactory;
        this.unwrappedExceptions = unwrappedExceptions;
    }

    public boolean isMapperExecuted() {
        return this.mapperExecuted;
    }

    protected Response executeExactExceptionMapper(Throwable exception, RESTEasyTracingLogger logger2) {
        ExceptionMapper mapper;
        if (logger2 == null) {
            logger2 = RESTEasyTracingLoggerImpl.empty();
        }
        if ((mapper = this.providerFactory.getExceptionMappers().get(exception.getClass())) == null) {
            return null;
        }
        this.mapperExecuted = true;
        long timestamp = logger2.timestamp(RESTEasyServerTracingEvent.EXCEPTION_MAPPING);
        Response resp = mapper.toResponse(exception);
        logger2.logDuration(RESTEasyServerTracingEvent.EXCEPTION_MAPPING, timestamp, mapper, exception, exception.getLocalizedMessage(), resp);
        return resp;
    }

    @Deprecated
    public Response executeExactExceptionMapper(Throwable exception) {
        return this.executeExactExceptionMapper(exception, null);
    }

    protected Response executeExceptionMapperForClass(Throwable exception, Class clazz, RESTEasyTracingLogger logger2) {
        ExceptionMapper mapper;
        if (logger2 == null) {
            logger2 = RESTEasyTracingLoggerImpl.empty();
        }
        if ((mapper = this.providerFactory.getExceptionMappers().get(clazz)) == null) {
            return null;
        }
        this.mapperExecuted = true;
        long timestamp = logger2.timestamp(RESTEasyServerTracingEvent.EXCEPTION_MAPPING);
        Response resp = mapper.toResponse(exception);
        logger2.logDuration(RESTEasyServerTracingEvent.EXCEPTION_MAPPING, timestamp, mapper, exception, exception.getLocalizedMessage(), resp);
        return resp;
    }

    @Deprecated
    public Response executeExceptionMapperForClass(Throwable exception, Class clazz) {
        return this.executeExceptionMapperForClass(exception, clazz, null);
    }

    protected Response handleApplicationException(HttpRequest request, ApplicationException e, RESTEasyTracingLogger logger2) {
        Response jaxrsResponse = null;
        jaxrsResponse = this.executeExceptionMapperForClass(e, ApplicationException.class, logger2);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        jaxrsResponse = this.unwrapException(request, e, logger2);
        if (jaxrsResponse == null) {
            throw new UnhandledException(e.getCause());
        }
        return jaxrsResponse;
    }

    protected Response executeExceptionMapper(Throwable exception, RESTEasyTracingLogger logger2) {
        if (logger2 == null) {
            logger2 = RESTEasyTracingLoggerImpl.empty();
        }
        ExceptionMapper mapper = null;
        Class<?> causeClass = exception.getClass();
        while (mapper == null && causeClass != null) {
            mapper = this.providerFactory.getExceptionMappers().get(causeClass);
            if (mapper != null) continue;
            causeClass = causeClass.getSuperclass();
        }
        if (mapper != null) {
            this.mapperExecuted = true;
            long timestamp = logger2.timestamp(RESTEasyServerTracingEvent.EXCEPTION_MAPPING);
            Response jaxrsResponse = mapper.toResponse(exception);
            logger2.logDuration(RESTEasyServerTracingEvent.EXCEPTION_MAPPING, timestamp, mapper, exception, exception.getLocalizedMessage(), jaxrsResponse);
            if (jaxrsResponse == null) {
                jaxrsResponse = Response.status((int)204).build();
            }
            return jaxrsResponse;
        }
        return null;
    }

    @Deprecated
    public Response executeExceptionMapper(Throwable exception) {
        return this.executeExactExceptionMapper(exception, null);
    }

    protected Response unwrapException(HttpRequest request, Throwable e, RESTEasyTracingLogger logger2) {
        WebApplicationException wae;
        Response jaxrsResponse = null;
        Throwable unwrappedException = e.getCause();
        if (unwrappedException instanceof WebApplicationException && (wae = (WebApplicationException)unwrappedException).getResponse() != null && wae.getResponse().getEntity() != null) {
            return wae.getResponse();
        }
        jaxrsResponse = this.executeExceptionMapper(unwrappedException, logger2);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        if (unwrappedException instanceof WebApplicationException) {
            return this.handleWebApplicationException((WebApplicationException)unwrappedException);
        }
        if (unwrappedException instanceof Failure) {
            return this.handleFailure(request, (Failure)unwrappedException);
        }
        if (this.unwrappedExceptions.contains(unwrappedException.getClass().getName()) && unwrappedException.getCause() != null) {
            return this.unwrapException(request, unwrappedException, logger2);
        }
        return null;
    }

    protected Response handleFailure(HttpRequest request, Failure failure) {
        if (failure.isLoggable()) {
            LogMessages.LOGGER.failedExecutingError(request.getHttpMethod(), request.getUri().getPath(), failure);
        } else {
            LogMessages.LOGGER.failedExecutingDebug(request.getHttpMethod(), request.getUri().getPath(), failure);
        }
        Response response = failure.getResponse();
        if (response != null) {
            return response;
        }
        Response.ResponseBuilder builder = Response.status((int)failure.getErrorCode());
        if (failure.getMessage() != null) {
            builder.type("text/html").entity((Object)failure.getMessage());
        }
        Response resp = builder.build();
        return resp;
    }

    protected Response handleWriterException(HttpRequest request, WriterException e, RESTEasyTracingLogger logger2) {
        Response jaxrsResponse = null;
        jaxrsResponse = this.executeExceptionMapperForClass(e, WriterException.class, logger2);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        if (e.getResponse() != null || e.getErrorCode() > -1) {
            return this.handleFailure(request, e);
        }
        if (e.getCause() != null && (jaxrsResponse = this.unwrapException(request, e, logger2)) != null) {
            return jaxrsResponse;
        }
        e.setErrorCode(500);
        return this.handleFailure(request, e);
    }

    protected Response handleReaderException(HttpRequest request, ReaderException e, RESTEasyTracingLogger logger2) {
        Response jaxrsResponse = null;
        jaxrsResponse = this.executeExceptionMapperForClass(e, ReaderException.class, logger2);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        if (e.getResponse() != null || e.getErrorCode() > -1) {
            return this.handleFailure(request, e);
        }
        if (e.getCause() != null && (jaxrsResponse = this.unwrapException(request, e, logger2)) != null) {
            return jaxrsResponse;
        }
        e.setErrorCode(400);
        return this.handleFailure(request, e);
    }

    protected Response handleWebApplicationException(WebApplicationException wae) {
        if (wae instanceof NotFoundException) {
            LogMessages.LOGGER.failedToExecuteDebug((Throwable)wae);
        } else if (!(wae instanceof NoLogWebApplicationException)) {
            LogMessages.LOGGER.failedToExecute((Throwable)wae);
        }
        Response response = wae.getResponse();
        return response;
    }

    public Response handleException(HttpRequest request, Throwable e) {
        WebApplicationException wae;
        Response jaxrsResponse = null;
        RESTEasyTracingLogger logger2 = RESTEasyTracingLogger.getInstance(request);
        jaxrsResponse = this.executeExactExceptionMapper(e, logger2);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        if (e instanceof ApplicationException) {
            return this.handleApplicationException(request, (ApplicationException)e, logger2);
        }
        if (e instanceof WriterException) {
            return this.handleWriterException(request, (WriterException)e, logger2);
        }
        if (e instanceof ReaderException) {
            return this.handleReaderException(request, (ReaderException)e, logger2);
        }
        if (e instanceof WebApplicationException && (wae = (WebApplicationException)e).getResponse() != null && wae.getResponse().getEntity() != null) {
            Response response = wae.getResponse();
            return response;
        }
        jaxrsResponse = this.executeExceptionMapper(e, logger2);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        if (e instanceof WebApplicationException) {
            return this.handleWebApplicationException((WebApplicationException)e);
        }
        if (e instanceof Failure) {
            return this.handleFailure(request, (Failure)e);
        }
        LogMessages.LOGGER.unknownException(request.getHttpMethod(), request.getUri().getPath(), e);
        throw new UnhandledException(e);
    }
}

