/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing;

import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.tracing.RESTEasyTracingEvent;
import org.jboss.resteasy.tracing.RESTEasyTracingLevel;
import org.jboss.resteasy.tracing.RESTEasyTracingLoggerImpl;

public abstract class RESTEasyTracingLogger {
    public static final String PROPERTY_NAME = RESTEasyTracingLogger.class.getName();
    public static final String HEADER_TRACING_PREFIX = "X-RESTEasy-Tracing-";
    public static final String HEADER_THRESHOLD = "X-RESTEasy-Tracing-Threshold";
    public static final String HEADER_ACCEPT = "X-RESTEasy-Tracing-Accept";
    public static final String HEADER_LOGGER = "X-RESTEasy-Tracing-Logger";
    protected static final String HEADER_RESPONSE_FORMAT = "X-RESTEasy-Tracing-%03d";
    public static final RESTEasyTracingLevel DEFAULT_LEVEL = RESTEasyTracingLevel.TRACE;
    protected static final String TRACING_LOGGER_NAME_PREFIX = "org.jboss.resteasy.tracing";
    protected static final String DEFAULT_LOGGER_NAME_SUFFIX = "general";
    private static final RESTEasyTracingLogger EMPTY = new RESTEasyTracingLogger(){

        @Override
        public boolean isLogEnabled(RESTEasyTracingEvent event) {
            return false;
        }

        @Override
        public void log(RESTEasyTracingEvent event, Object ... args) {
        }

        @Override
        public void logDuration(RESTEasyTracingEvent event, long fromTimestamp, Object ... args) {
        }

        @Override
        public long timestamp(RESTEasyTracingEvent event) {
            return -1L;
        }

        @Override
        public void flush(MultivaluedMap<String, Object> headers) {
        }
    };

    public abstract boolean isLogEnabled(RESTEasyTracingEvent var1);

    public abstract void log(RESTEasyTracingEvent var1, Object ... var2);

    public abstract void logDuration(RESTEasyTracingEvent var1, long var2, Object ... var4);

    public abstract long timestamp(RESTEasyTracingEvent var1);

    public abstract void flush(MultivaluedMap<String, Object> var1);

    public static RESTEasyTracingLogger create(RESTEasyTracingLevel threshold, String loggerNameSuffix) {
        return new RESTEasyTracingLoggerImpl(threshold, loggerNameSuffix);
    }

    public static RESTEasyTracingLogger getInstance(HttpRequest request) {
        if (request == null) {
            return EMPTY;
        }
        RESTEasyTracingLogger tracingLogger = (RESTEasyTracingLogger)request.getAttribute(PROPERTY_NAME);
        return tracingLogger != null ? tracingLogger : EMPTY;
    }

    public static RESTEasyTracingLogger empty() {
        return EMPTY;
    }
}

