/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.tracing.RESTEasyServerTracingEvent;
import org.jboss.resteasy.tracing.RESTEasyTracingConfig;
import org.jboss.resteasy.tracing.RESTEasyTracingLevel;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public class RESTEasyTracingUtils {
    private static final List<String> SUMMARY_HEADERS = new ArrayList<String>();
    private static final RESTEasyTracingConfig DEFAULT_CONFIGURATION_TYPE;

    private RESTEasyTracingUtils() {
    }

    public static void initTracingSupport(RESTEasyTracingConfig type, RESTEasyTracingLevel appThreshold, HttpRequest request) {
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingUtils.isTracingSupportEnabled(type, request) ? RESTEasyTracingLogger.create(RESTEasyTracingUtils.getTracingThreshold(appThreshold, request), RESTEasyTracingUtils.getTracingLoggerNameSuffix(request)) : RESTEasyTracingLogger.empty();
        request.setAttribute(RESTEasyTracingLogger.PROPERTY_NAME, tracingLogger);
    }

    public static void logStart(HttpRequest request) {
        StringBuilder text;
        if (request == null) {
            return;
        }
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(null);
        if (tracingLogger.isLogEnabled(RESTEasyServerTracingEvent.START)) {
            text = new StringBuilder();
            SecurityContext securityContext = ResteasyProviderFactory.getContextData(SecurityContext.class);
            text.append(String.format("baseUri=[%s] requestUri=[%s] method=[%s] authScheme=[%s]", request.getUri().getBaseUri(), request.getUri().getRequestUri(), request.getHttpMethod(), RESTEasyTracingUtils.toStringOrNA(securityContext == null ? null : securityContext.getAuthenticationScheme())));
            for (String header : SUMMARY_HEADERS) {
                text.append(String.format(" %s=%s", header, RESTEasyTracingUtils.toStringOrNA(RESTEasyTracingUtils.getHeaderString(request, header))));
            }
            tracingLogger.log(RESTEasyServerTracingEvent.START, text.toString());
        }
        if (tracingLogger.isLogEnabled(RESTEasyServerTracingEvent.START_HEADERS)) {
            text = new StringBuilder();
            HttpHeaders headers = request.getHttpHeaders();
            if (headers != null) {
                for (String header : headers.getRequestHeaders().keySet()) {
                    if (SUMMARY_HEADERS.contains(header)) continue;
                    text.append(String.format(" %s=%s", header, RESTEasyTracingUtils.toStringOrNA(headers.getRequestHeaders().get((Object)header))));
                }
                if (text.length() > 0) {
                    text.insert(0, "Other request headers:");
                }
                tracingLogger.log(RESTEasyServerTracingEvent.START_HEADERS, text.toString());
            }
        }
    }

    private static boolean isTracingSupportEnabled(RESTEasyTracingConfig type, HttpRequest request) {
        return type == RESTEasyTracingConfig.ALL || type == RESTEasyTracingConfig.ON_DEMAND && RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Accept") != null;
    }

    public static RESTEasyTracingConfig getTracingConfig(Configuration configuration) {
        Object tracingText = configuration.getProperty("resteasy.server.tracing.type");
        RESTEasyTracingConfig result = tracingText != null ? RESTEasyTracingConfig.valueOf((String)tracingText) : DEFAULT_CONFIGURATION_TYPE;
        return result;
    }

    private static String getTracingLoggerNameSuffix(HttpRequest request) {
        return RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Logger");
    }

    public static RESTEasyTracingLevel getTracingThreshold(Configuration configuration) {
        Object thresholdText = configuration.getProperty("resteasy.server.tracing.threshold");
        return thresholdText == null ? RESTEasyTracingLogger.DEFAULT_LEVEL : RESTEasyTracingLevel.valueOf((String)thresholdText);
    }

    private static RESTEasyTracingLevel getTracingThreshold(RESTEasyTracingLevel appThreshold, HttpRequest request) {
        String thresholdText = RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Threshold");
        return thresholdText == null ? appThreshold : RESTEasyTracingLevel.valueOf(thresholdText);
    }

    private static String getHeaderString(HttpRequest request, String header) {
        if (request == null) {
            return null;
        }
        if (request.getHttpHeaders() != null) {
            return request.getHttpHeaders().getHeaderString(header);
        }
        return null;
    }

    private static String toStringOrNA(Object object) {
        if (object == null) {
            return "n/a";
        }
        return String.valueOf(object);
    }

    static {
        SUMMARY_HEADERS.add("Accept".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Encoding".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Charset".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Language".toLowerCase());
        SUMMARY_HEADERS.add("Content-Type".toLowerCase());
        SUMMARY_HEADERS.add("Content-Length".toLowerCase());
        DEFAULT_CONFIGURATION_TYPE = RESTEasyTracingConfig.OFF;
    }
}

