/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.reactivecontexts.propagators.rxjava2;

import io.reactiverse.reactivecontexts.core.Context;
import io.reactiverse.reactivecontexts.core.ContextState;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;

public class ContextPropagatorOnObservableCreateAction
implements BiFunction<Observable, Observer, Observer> {
    public Observer apply(Observable observable, Observer observer) throws Exception {
        return new ContextCapturerObservable(observable, observer);
    }

    public class ContextCapturerObservable<T>
    implements Observer<T> {
        private final Observer<T> source;
        private final ContextState states;

        public ContextCapturerObservable(Observable<T> observable, Observer<T> observer) {
            this.source = observer;
            this.states = Context.capture();
        }

        public void onComplete() {
            ContextState previousStates = this.states.install();
            try {
                this.source.onComplete();
            }
            finally {
                previousStates.restore();
            }
        }

        public void onError(Throwable t) {
            ContextState previousStates = this.states.install();
            try {
                this.source.onError(t);
            }
            finally {
                previousStates.restore();
            }
        }

        public void onNext(T v) {
            ContextState previousStates = this.states.install();
            try {
                this.source.onNext(v);
            }
            finally {
                previousStates.restore();
            }
        }

        public void onSubscribe(Disposable d) {
            ContextState previousStates = this.states.install();
            try {
                this.source.onSubscribe(d);
            }
            finally {
                previousStates.restore();
            }
        }
    }
}

