/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.metadata.ConstructorParameter;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceConstructor;

public class ConstructorInjectorImpl
implements ConstructorInjector {
    protected Constructor constructor;
    protected ValueInjector[] params;

    public ConstructorInjectorImpl(ResourceConstructor constructor, ResteasyProviderFactory factory) {
        this.constructor = constructor.getConstructor();
        this.params = new ValueInjector[constructor.getParams().length];
        int i = 0;
        for (ConstructorParameter parameter : constructor.getParams()) {
            this.params[i++] = factory.getInjectorFactory().createParameterExtractor((Parameter)parameter, factory);
        }
    }

    public ConstructorInjectorImpl(Constructor constructor, ResteasyProviderFactory factory) {
        this.constructor = constructor;
        this.params = new ValueInjector[constructor.getParameterTypes().length];
        java.lang.reflect.Parameter[] reflectionParameters = constructor.getParameters();
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            Class<?> type = constructor.getParameterTypes()[i];
            Type genericType = constructor.getGenericParameterTypes()[i];
            Annotation[] annotations = constructor.getParameterAnnotations()[i];
            String name = reflectionParameters[i].getName();
            this.params[i] = factory.getInjectorFactory().createParameterExtractor(constructor.getDeclaringClass(), (AccessibleObject)constructor, name, type, genericType, annotations, factory);
        }
    }

    public CompletionStage<Object[]> injectableArguments(HttpRequest input, HttpResponse response, boolean unwrapAsync) {
        if (this.params != null && this.params.length > 0) {
            Object[] args = new Object[this.params.length];
            int i = 0;
            CompletionStage<Object> stage = CompletableFuture.completedFuture(null);
            for (ValueInjector extractor : this.params) {
                int ifinal = i++;
                stage = stage.thenCompose(v -> extractor.inject(input, response, unwrapAsync).thenAccept(value -> {
                    args[ifinal] = value;
                }));
            }
            return stage.thenApply(v -> args);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Object[]> injectableArguments(boolean unwrapAsync) {
        if (this.params != null && this.params.length > 0) {
            Object[] args = new Object[this.params.length];
            int i = 0;
            CompletionStage<Object> stage = CompletableFuture.completedFuture(null);
            for (ValueInjector extractor : this.params) {
                int ifinal = i++;
                stage = stage.thenCompose(v -> extractor.inject(unwrapAsync).thenAccept(value -> {
                    args[ifinal] = value;
                }));
            }
            return stage.thenApply(v -> args);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Object> construct(HttpRequest request, HttpResponse httpResponse, boolean unwrapAsync) throws Failure, ApplicationException, WebApplicationException {
        return this.injectableArguments(request, httpResponse, unwrapAsync).exceptionally(e -> {
            Throwable t = e.getCause();
            if (t != null) {
                if (t instanceof NotFoundException) {
                    throw new NotFoundException(t.getMessage(), t.getCause());
                }
                if (t instanceof BadRequestException) {
                    throw new BadRequestException(t.getMessage(), t.getCause());
                }
            }
            throw new InternalServerErrorException(Messages.MESSAGES.failedProcessingArguments(this.constructor.toString()), e);
        }).thenApply(args -> {
            try {
                return this.constructor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw new InternalServerErrorException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof WebApplicationException) {
                    throw (WebApplicationException)cause;
                }
                throw new ApplicationException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e.getCause());
            }
            catch (IllegalArgumentException e) {
                String msg = Messages.MESSAGES.badArguments(this.constructor.toString() + "  (");
                boolean first = false;
                for (Object arg : args) {
                    if (!first) {
                        first = true;
                    } else {
                        msg = msg + ",";
                    }
                    msg = arg == null ? msg + " null" : msg + " " + arg;
                }
                throw new InternalServerErrorException(msg, (Throwable)e);
            }
        });
    }

    public CompletionStage<Object> construct(boolean unwrapAsync) {
        return this.injectableArguments(unwrapAsync).thenApply(args -> {
            try {
                return this.constructor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e.getCause());
            }
            catch (IllegalArgumentException e) {
                String msg = Messages.MESSAGES.badArguments(this.constructor.toString() + "  (");
                boolean first = false;
                for (Object arg : args) {
                    if (!first) {
                        first = true;
                    } else {
                        msg = msg + ",";
                    }
                    msg = arg == null ? msg + " null" : msg + " " + arg;
                }
                throw new RuntimeException(msg, e);
            }
        });
    }
}

