/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.util.MediaTypeHelper;

public class MediaTypeMap<T> {
    private static final Pattern COMPOSITE_PATTERN = Pattern.compile("([^\\+]+)\\+(.+)");
    public static final Pattern COMPOSITE_SUBTYPE_WILDCARD_PATTERN = Pattern.compile("\\*\\+(.+)");
    public static final Pattern WILD_SUBTYPE_COMPOSITE_PATTERN = Pattern.compile("([^\\+]+)\\+\\*");
    private Map<String, SubtypeMap<T>> index = new ConcurrentHashMap<String, SubtypeMap<T>>();
    private volatile List<Entry<T>> wildcards = new ArrayList<Entry<T>>();
    private volatile List<Entry<T>> all = new ArrayList<Entry<T>>();
    private volatile List<T> everything = new ArrayList<T>();
    private Map<CachedMediaTypeAndClass, List<T>> classCache = new ConcurrentHashMap<CachedMediaTypeAndClass, List<T>>();
    public static boolean useCache = true;

    public MediaTypeMap<T> clone() {
        MediaTypeMap<T> clone = new MediaTypeMap<T>();
        for (Map.Entry<String, SubtypeMap<T>> entry : this.index.entrySet()) {
            clone.index.put(entry.getKey(), (SubtypeMap<T>)entry.getValue().clone());
        }
        clone.wildcards.addAll(this.wildcards);
        clone.all.addAll(this.all);
        clone.everything.addAll(this.everything);
        return clone;
    }

    public synchronized void add(MediaType type, T obj) {
        this.classCache.clear();
        type = new MediaType(type.getType().toLowerCase(), type.getSubtype().toLowerCase(), type.getParameters());
        Entry entry = new Entry(type, obj);
        ArrayList<Entry<T>> newall = new ArrayList<Entry<T>>(this.all.size() + 1);
        newall.addAll(this.all);
        newall.add(entry);
        Collections.sort(newall);
        this.all = newall;
        this.everything = MediaTypeMap.convert(newall);
        if (type.isWildcardType()) {
            ArrayList<Entry<T>> newwildcards = new ArrayList<Entry<T>>(this.wildcards.size() + 1);
            newwildcards.addAll(this.wildcards);
            newwildcards.add(entry);
            this.wildcards = newwildcards;
        } else {
            SubtypeMap<T> subtype = this.index.get(type.getType());
            if (subtype == null) {
                subtype = new SubtypeMap();
                this.index.put(type.getType(), subtype);
            }
            subtype.add(type, obj);
        }
    }

    private static <T> List<T> convert(List<Entry<T>> list) {
        ArrayList newList = new ArrayList(list.size());
        for (Entry<T> entry : list) {
            newList.add(entry.object);
        }
        return newList;
    }

    public List<T> getPossible(MediaType accept) {
        accept = new MediaType(accept.getType().toLowerCase(), accept.getSubtype().toLowerCase(), accept.getParameters());
        ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
        if (accept.isWildcardType()) {
            ArrayList<T> copy = new ArrayList<T>();
            copy.addAll(this.everything);
            return copy;
        }
        matches.addAll(this.wildcards);
        SubtypeMap<T> indexed = this.index.get(accept.getType());
        if (indexed != null) {
            matches.addAll(indexed.getPossible(accept));
        }
        Collections.sort(matches);
        return MediaTypeMap.convert(matches);
    }

    public List<T> getPossible(MediaType accept, Class<?> type) {
        List<T> cached = null;
        CachedMediaTypeAndClass cacheEntry = null;
        if (useCache && (cached = this.classCache.get(cacheEntry = new CachedMediaTypeAndClass(type, accept))) != null) {
            return cached;
        }
        accept = new MediaType(accept.getType().toLowerCase(), accept.getSubtype().toLowerCase(), accept.getParameters());
        ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
        if (accept.isWildcardType()) {
            matches.addAll(this.all);
        } else {
            matches.addAll(this.wildcards);
            SubtypeMap<T> indexed = this.index.get(accept.getType());
            if (indexed != null) {
                matches.addAll(indexed.getPossible(accept));
            }
        }
        Collections.sort(matches, new TypedEntryComparator(type));
        cached = MediaTypeMap.convert(matches);
        if (useCache) {
            this.classCache.put(cacheEntry, cached);
        }
        return cached;
    }

    private static class CachedMediaTypeAndClass {
        private WeakReference<Class<?>> clazz;
        private MediaType mediaType;
        private final int hash;

        private CachedMediaTypeAndClass(Class clazz, MediaType mediaType) {
            this.clazz = new WeakReference<Class>(clazz);
            this.mediaType = mediaType;
            int result = clazz.hashCode();
            this.hash = result = 31 * result + (mediaType.getType() != null ? mediaType.getType().hashCode() : 0) + (mediaType.getSubtype() != null ? mediaType.getSubtype().hashCode() : 0);
        }

        private Class<?> getClazz() {
            return (Class)this.clazz.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedMediaTypeAndClass that = (CachedMediaTypeAndClass)o;
            Class<?> clazz = this.getClazz();
            if (clazz == null || that.getClazz() == null) {
                return false;
            }
            if (!clazz.equals(that.getClazz())) {
                return false;
            }
            if (this.mediaType.getType() != null ? !this.mediaType.getType().equals(that.mediaType.getType()) : this.mediaType.getType() != that.mediaType.getType()) {
                return false;
            }
            return !(this.mediaType.getSubtype() != null ? !this.mediaType.getSubtype().equals(that.mediaType.getSubtype()) : this.mediaType.getSubtype() != that.mediaType.getSubtype());
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class SubtypeMap<T> {
        private Map<String, List<Entry<T>>> index = new ConcurrentHashMap<String, List<Entry<T>>>();
        private Map<String, List<Entry<T>>> compositeIndex = new ConcurrentHashMap<String, List<Entry<T>>>();
        private Map<String, List<Entry<T>>> wildCompositeIndex = new ConcurrentHashMap<String, List<Entry<T>>>();
        private List<Entry<T>> wildcards = new CopyOnWriteArrayList<Entry<T>>();
        private List<Entry<T>> all = new CopyOnWriteArrayList<Entry<T>>();

        private SubtypeMap() {
        }

        public SubtypeMap<T> clone() {
            CopyOnWriteArrayList newList;
            SubtypeMap<T> clone = new SubtypeMap<T>();
            for (Map.Entry<String, List<Entry<T>>> entry : this.index.entrySet()) {
                newList = new CopyOnWriteArrayList();
                newList.addAll(entry.getValue());
                clone.index.put(entry.getKey(), newList);
            }
            for (Map.Entry<String, List<Entry<T>>> entry : this.compositeIndex.entrySet()) {
                newList = new CopyOnWriteArrayList();
                newList.addAll(entry.getValue());
                clone.compositeIndex.put(entry.getKey(), newList);
            }
            for (Map.Entry<String, List<Entry<T>>> entry : this.wildCompositeIndex.entrySet()) {
                newList = new CopyOnWriteArrayList();
                newList.addAll(entry.getValue());
                clone.wildCompositeIndex.put(entry.getKey(), newList);
            }
            clone.wildcards.addAll(this.wildcards);
            clone.all.addAll(this.all);
            return clone;
        }

        public void add(MediaType type, T obj) {
            Entry entry = new Entry(type, obj);
            this.all.add(entry);
            Matcher matcher = COMPOSITE_SUBTYPE_WILDCARD_PATTERN.matcher(type.getSubtype());
            Matcher wildCompositeMatcher = WILD_SUBTYPE_COMPOSITE_PATTERN.matcher(type.getSubtype());
            if (type.isWildcardSubtype()) {
                this.wildcards.add(entry);
            } else if (matcher.matches()) {
                String main = matcher.group(1);
                List<Entry<T>> list = this.compositeIndex.get(main);
                if (list == null) {
                    list = new CopyOnWriteArrayList<Entry<T>>();
                    this.compositeIndex.put(main, list);
                }
                list.add(entry);
            } else if (wildCompositeMatcher.matches()) {
                String main = wildCompositeMatcher.group(1);
                List<Entry<T>> list = this.wildCompositeIndex.get(main);
                if (list == null) {
                    list = new CopyOnWriteArrayList<Entry<T>>();
                    this.wildCompositeIndex.put(main, list);
                }
                list.add(entry);
            } else {
                List<Entry<T>> list = this.index.get(type.getSubtype());
                if (list == null) {
                    list = new CopyOnWriteArrayList<Entry<T>>();
                    this.index.put(type.getSubtype(), list);
                }
                list.add(entry);
            }
        }

        public List<Entry<T>> getPossible(MediaType accept) {
            List<Entry<T>> indexed2;
            if (accept.isWildcardSubtype()) {
                return this.all;
            }
            ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
            List<Entry<T>> indexed = this.index.get(accept.getSubtype());
            if (indexed != null) {
                matches.addAll(indexed);
            }
            Matcher matcher = COMPOSITE_PATTERN.matcher(accept.getSubtype());
            String compositeKey = accept.getSubtype();
            if (matcher.matches()) {
                String wildCompositeKey = matcher.group(1);
                List<Entry<T>> windex = this.wildCompositeIndex.get(wildCompositeKey);
                if (windex != null) {
                    matches.addAll(windex);
                }
                compositeKey = matcher.group(2);
            }
            if ((indexed2 = this.compositeIndex.get(compositeKey)) != null) {
                matches.addAll(indexed2);
            }
            matches.addAll(this.wildcards);
            return matches;
        }
    }

    private static class Entry<T>
    implements Comparable<Entry<?>> {
        public MediaType mediaType;
        public T object;

        private Entry(MediaType mediaType, T object) {
            this.mediaType = mediaType;
            this.object = object;
        }

        @Override
        public int compareTo(Entry<?> entry) {
            int val = MediaTypeHelper.compareWeight(this.mediaType, entry.mediaType);
            if (val == 0 && this.object instanceof Comparable && entry.object instanceof Comparable) {
                return ((Comparable)this.object).compareTo(entry.object);
            }
            return val;
        }
    }

    private static class TypedEntryComparator
    implements Comparator<Entry<?>>,
    Serializable {
        private static final long serialVersionUID = -8815419198743440920L;
        private Class<?> type;

        TypedEntryComparator(Class<?> type) {
            this.type = type;
        }

        private boolean isAssignableFrom(Typed typed) {
            if (typed.getType() == null) {
                return false;
            }
            return typed.getType().isAssignableFrom(this.type);
        }

        private int compareTypes(Entry<?> entry, Entry<?> entry1) {
            int val = 0;
            if (entry.object instanceof Typed && entry1.object instanceof Typed && this.type != null) {
                boolean twoTyped;
                Typed one = (Typed)entry.object;
                Typed two = (Typed)entry1.object;
                boolean oneTyped = this.isAssignableFrom(one);
                val = oneTyped == (twoTyped = this.isAssignableFrom(two)) && !oneTyped && !twoTyped ? 0 : (oneTyped == twoTyped ? (one.getType().equals(two.getType()) ? 0 : (one.getType().isAssignableFrom(two.getType()) ? 1 : -1)) : (oneTyped ? -1 : 1));
            }
            return val;
        }

        @Override
        public int compare(Entry<?> entry, Entry<?> entry1) {
            int val = this.compareTypes(entry, entry1);
            if (val == 0) {
                val = entry.compareTo(entry1);
            }
            return val;
        }
    }

    public static interface Typed {
        public Class<?> getType();
    }
}

