/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.providerfactory.ClientHelper;
import org.jboss.resteasy.core.providerfactory.CopyOnWriteMap;
import org.jboss.resteasy.core.providerfactory.ExtSortedKey;
import org.jboss.resteasy.core.providerfactory.ServerHelper;
import org.jboss.resteasy.core.providerfactory.SortedKey;
import org.jboss.resteasy.core.providerfactory.Utils;
import org.jboss.resteasy.plugins.delegates.CacheControlDelegate;
import org.jboss.resteasy.plugins.delegates.CookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.DateDelegate;
import org.jboss.resteasy.plugins.delegates.EntityTagDelegate;
import org.jboss.resteasy.plugins.delegates.LinkDelegate;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.LocaleDelegate;
import org.jboss.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.NewCookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.UriHeaderDelegate;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.AsyncClientResponseProvider;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.ContextInjector;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClassProcessor;
import org.jboss.resteasy.spi.statistics.StatisticsController;
import org.jboss.resteasy.spi.util.PickConstructor;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.statistics.StatisticsControllerImpl;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.FeatureContextDelegate;

public class ResteasyProviderFactoryImpl
extends ResteasyProviderFactory
implements Providers,
HeaderValueProcessor,
Configurable<ResteasyProviderFactory>,
Configuration {
    protected ClientHelper clientHelper;
    protected ServerHelper serverHelper;
    private Map<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates;
    private Set<Class<?>> alreadyEstablishedNullHeaderDelegate = ConcurrentHashMap.newKeySet();
    private Map<Class<?>, SortedKey<ExceptionMapper>> sortedExceptionMappers;
    private Map<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> contextResolvers;
    private Map<Type, ContextInjector> contextInjectors;
    private Map<Type, ContextInjector> asyncContextInjectors;
    private Set<ExtSortedKey<ParamConverterProvider>> sortedParamConverterProviders;
    private Map<Class<?>, Class<? extends StringParameterUnmarshaller>> stringParameterUnmarshallers;
    private Map<Class<?>, Map<Class<?>, Integer>> classContracts;
    private boolean builtinsRegistered = false;
    private boolean registerBuiltins = true;
    private InjectorFactory injectorFactory;
    private ResteasyProviderFactoryImpl parent;
    private Map<String, Object> properties;
    private ResourceBuilder resourceBuilder;
    private Set<Feature> enabledFeatures;
    private Set<Class<?>> providerClasses;
    private Set<Object> providerInstances;
    private boolean initialized = false;
    private StatisticsControllerImpl statisticsController = new StatisticsControllerImpl();

    public ResteasyProviderFactoryImpl() {
        this.initializeUtils();
        this.initialize();
    }

    public ResteasyProviderFactoryImpl(ResteasyProviderFactory parent) {
        this(parent, false);
    }

    public ResteasyProviderFactoryImpl(ResteasyProviderFactory parent, boolean local) {
        this.initializeUtils();
        if (local || parent == null) {
            this.parent = null;
            this.initialize((ResteasyProviderFactoryImpl)parent);
        } else {
            this.parent = (ResteasyProviderFactoryImpl)parent;
            this.clientHelper.initializeDefault();
            this.providerClasses = new CopyOnWriteArraySet();
            this.providerInstances = new CopyOnWriteArraySet<Object>();
            this.properties = new CopyOnWriteMap<String, Object>(parent.getProperties());
            this.enabledFeatures = new CopyOnWriteArraySet<Feature>();
            this.resourceBuilder = new ResourceBuilder();
        }
    }

    protected void registerBuiltin() {
        RegisterBuiltin.register(this);
    }

    protected void initialize() {
        this.initialize(null);
    }

    protected void initializeUtils() {
        this.clientHelper = new ClientHelper(this);
        this.serverHelper = new ServerHelper(this);
    }

    protected void initialize(ResteasyProviderFactoryImpl parent) {
        this.enabledFeatures = parent == null ? new CopyOnWriteArraySet<Feature>() : new CopyOnWriteArraySet<Feature>(parent.getEnabledFeatures());
        this.properties = parent == null ? new CopyOnWriteMap<String, Object>() : new CopyOnWriteMap<String, Object>(parent.getProperties());
        this.providerClasses = parent == null ? new CopyOnWriteArraySet() : new CopyOnWriteArraySet(parent.getProviderClasses());
        this.providerInstances = parent == null ? new CopyOnWriteArraySet<Object>() : new CopyOnWriteArraySet<Object>(parent.getProviderInstances());
        this.classContracts = parent == null ? new CopyOnWriteMap() : new CopyOnWriteMap(parent.getClassContracts());
        this.sortedExceptionMappers = parent == null ? new CopyOnWriteMap() : new CopyOnWriteMap(parent.getSortedExceptionMappers());
        this.contextResolvers = new ConcurrentHashMap();
        if (parent != null) {
            for (Map.Entry<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> entry : parent.getContextResolvers().entrySet()) {
                this.contextResolvers.put(entry.getKey(), new MediaTypeMap<SortedKey<ContextResolver>>(entry.getValue()));
            }
        }
        this.contextInjectors = parent == null ? new CopyOnWriteMap<Type, ContextInjector>() : new CopyOnWriteMap<Type, ContextInjector>(parent.getContextInjectors());
        this.asyncContextInjectors = parent == null ? new CopyOnWriteMap<Type, ContextInjector>() : new CopyOnWriteMap<Type, ContextInjector>(parent.getAsyncContextInjectors());
        this.sortedParamConverterProviders = Collections.synchronizedSortedSet(parent == null ? new TreeSet() : new TreeSet<ExtSortedKey<ParamConverterProvider>>(parent.getSortedParamConverterProviders()));
        this.stringParameterUnmarshallers = parent == null ? new CopyOnWriteMap() : new CopyOnWriteMap(parent.getStringParameterUnmarshallers());
        this.resourceBuilder = new ResourceBuilder();
        this.headerDelegates = parent == null ? new CopyOnWriteMap() : new CopyOnWriteMap(parent.getHeaderDelegates());
        this.addHeaderDelegateIfAbsent(MediaType.class, MediaTypeHeaderDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(NewCookie.class, NewCookieHeaderDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(Cookie.class, CookieHeaderDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(URI.class, UriHeaderDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(EntityTag.class, EntityTagDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(CacheControl.class, CacheControlDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(Locale.class, LocaleDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(LinkHeader.class, LinkHeaderDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(Link.class, LinkDelegate.INSTANCE);
        this.addHeaderDelegateIfAbsent(Date.class, DateDelegate.INSTANCE);
        this.serverHelper.initialize(parent);
        this.clientHelper.initialize(parent);
        this.builtinsRegistered = false;
        this.registerBuiltins = true;
        this.injectorFactory = parent == null ? InjectorFactoryImpl.INSTANCE : parent.getInjectorFactory();
        this.initialized = true;
    }

    public Set<DynamicFeature> getServerDynamicFeatures() {
        return this.serverHelper.getServerDynamicFeatures(this.parent);
    }

    public Set<DynamicFeature> getClientDynamicFeatures() {
        return this.clientHelper.getClientDynamicFeatures(this.parent);
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getServerMessageBodyReaders() {
        return this.serverHelper.getServerMessageBodyReaders(this.parent);
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getServerMessageBodyWriters() {
        return this.serverHelper.getServerMessageBodyWriters(this.parent);
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getClientMessageBodyReaders() {
        return this.clientHelper.getClientMessageBodyReaders(this.parent);
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getClientMessageBodyWriters() {
        return this.clientHelper.getClientMessageBodyWriters(this.parent);
    }

    private Map<Class<?>, SortedKey<ExceptionMapper>> getSortedExceptionMappers() {
        if (this.sortedExceptionMappers == null && this.parent != null) {
            return this.parent.getSortedExceptionMappers();
        }
        return this.sortedExceptionMappers;
    }

    public Map<Class<?>, AsyncResponseProvider> getAsyncResponseProviders() {
        return this.serverHelper.getAsyncResponseProviders(this.parent);
    }

    public Map<Class<?>, AsyncStreamProvider> getAsyncStreamProviders() {
        return this.serverHelper.getAsyncStreamProviders(this.parent);
    }

    public Map<Class<?>, AsyncClientResponseProvider> getAsyncClientResponseProviders() {
        return this.clientHelper.getAsyncClientResponseProviders(this.parent);
    }

    public Map<Type, ContextInjector> getContextInjectors() {
        if (this.contextInjectors == null && this.parent != null) {
            return this.parent.getContextInjectors();
        }
        return this.contextInjectors;
    }

    public Map<Type, ContextInjector> getAsyncContextInjectors() {
        if (this.asyncContextInjectors == null && this.parent != null) {
            return this.parent.getAsyncContextInjectors();
        }
        return this.asyncContextInjectors;
    }

    private Map<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> getContextResolvers() {
        if (this.contextResolvers == null && this.parent != null) {
            return this.parent.getContextResolvers();
        }
        return this.contextResolvers;
    }

    private Set<ExtSortedKey<ParamConverterProvider>> getSortedParamConverterProviders() {
        if (this.sortedParamConverterProviders == null && this.parent != null) {
            return this.parent.getSortedParamConverterProviders();
        }
        return this.sortedParamConverterProviders;
    }

    private Map<Class<?>, Class<? extends StringParameterUnmarshaller>> getStringParameterUnmarshallers() {
        if (this.stringParameterUnmarshallers == null && this.parent != null) {
            return this.parent.getStringParameterUnmarshallers();
        }
        return this.stringParameterUnmarshallers;
    }

    public Set<Class<?>> getProviderClasses() {
        if (this.initialized) {
            return this.providerClasses;
        }
        HashSet set = new HashSet();
        if (this.parent != null) {
            set.addAll(this.parent.getProviderClasses());
        }
        set.addAll(this.providerClasses);
        return set;
    }

    public Set<Object> getProviderInstances() {
        if (this.initialized) {
            return this.providerInstances;
        }
        HashSet<Object> set = new HashSet<Object>();
        if (this.parent != null) {
            set.addAll(this.parent.getProviderInstances());
        }
        set.addAll(this.providerInstances);
        return set;
    }

    private Map<Class<?>, Map<Class<?>, Integer>> getClassContracts() {
        if (this.classContracts != null) {
            return this.classContracts;
        }
        this.classContracts = this.parent == null ? new CopyOnWriteMap() : new CopyOnWriteMap(this.parent.getClassContracts());
        return this.classContracts;
    }

    public <T> T getContextData(Class<T> rawType, Type genericType, Annotation[] annotations, boolean unwrapAsync) {
        Object ret = ResteasyContext.getContextDataMap().get(rawType);
        if (ret != null) {
            return (T)ret;
        }
        ContextInjector contextInjector = this.getContextInjectors().get(genericType);
        boolean async = false;
        if (contextInjector == null && unwrapAsync) {
            contextInjector = this.getAsyncContextInjectors().get(Types.boxPrimitives((Type)genericType));
            async = true;
        }
        if (contextInjector != null) {
            ret = contextInjector.resolve(rawType, genericType, annotations);
            if (async && ret != null) {
                Type wrappedType = Types.getActualTypeArgumentsOfAnInterface(contextInjector.getClass(), ContextInjector.class)[0];
                Class rawWrappedType = Types.getRawType((Type)wrappedType);
                AsyncResponseProvider<T> converter = this.getAsyncResponseProvider(rawWrappedType);
                ret = converter.toCompletionStage(ret);
            }
        }
        return (T)ret;
    }

    public boolean isRegisterBuiltins() {
        return this.registerBuiltins;
    }

    public void setRegisterBuiltins(boolean registerBuiltins) {
        this.registerBuiltins = registerBuiltins;
    }

    public InjectorFactory getInjectorFactory() {
        if (this.injectorFactory == null && this.parent != null) {
            return this.parent.getInjectorFactory();
        }
        return this.injectorFactory;
    }

    public void setInjectorFactory(InjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
    }

    public JaxrsInterceptorRegistry<ReaderInterceptor> getServerReaderInterceptorRegistry() {
        return this.serverHelper.getServerReaderInterceptorRegistry(this.parent);
    }

    public JaxrsInterceptorRegistry<WriterInterceptor> getServerWriterInterceptorRegistry() {
        return this.serverHelper.getServerWriterInterceptorRegistry(this.parent);
    }

    public JaxrsInterceptorRegistry<ContainerRequestFilter> getContainerRequestFilterRegistry() {
        return this.serverHelper.getContainerRequestFilterRegistry(this.parent);
    }

    public JaxrsInterceptorRegistry<ContainerResponseFilter> getContainerResponseFilterRegistry() {
        return this.serverHelper.getContainerResponseFilterRegistry(this.parent);
    }

    public JaxrsInterceptorRegistry<ReaderInterceptor> getClientReaderInterceptorRegistry() {
        return this.clientHelper.getClientReaderInterceptorRegistry(this.parent);
    }

    public JaxrsInterceptorRegistry<WriterInterceptor> getClientWriterInterceptorRegistry() {
        return this.clientHelper.getClientWriterInterceptorRegistry(this.parent);
    }

    public JaxrsInterceptorRegistry<ClientRequestFilter> getClientRequestFilterRegistry() {
        return this.clientHelper.getClientRequestFilterRegistry(this.parent);
    }

    public JaxrsInterceptorRegistry<ClientResponseFilter> getClientResponseFilters() {
        return this.clientHelper.getClientResponseFilters(this.parent);
    }

    public boolean isBuiltinsRegistered() {
        return this.builtinsRegistered;
    }

    public void setBuiltinsRegistered(boolean builtinsRegistered) {
        this.builtinsRegistered = builtinsRegistered;
    }

    public UriBuilder createUriBuilder() {
        return Utils.createUriBuilder();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return Utils.createResponseBuilder();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return Utils.createVariantListBuilder();
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> tClass) {
        if (tClass == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.tClassParameterNull());
        }
        if (this.headerDelegates == null && this.parent != null) {
            return this.parent.createHeaderDelegate(tClass);
        }
        return Utils.createHeaderDelegate(this.headerDelegates, this.alreadyEstablishedNullHeaderDelegate, tClass);
    }

    private Map<Class<?>, RuntimeDelegate.HeaderDelegate> getHeaderDelegates() {
        if (this.headerDelegates == null && this.parent != null) {
            return this.parent.getHeaderDelegates();
        }
        return this.headerDelegates != null ? this.headerDelegates : Collections.emptyMap();
    }

    public void addHeaderDelegate(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        if (this.headerDelegates == null) {
            this.headerDelegates = new CopyOnWriteMap(this.parent.getHeaderDelegates());
        }
        this.headerDelegates.put(clazz, header);
    }

    private void addHeaderDelegateIfAbsent(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        if (this.headerDelegates == null || !this.headerDelegates.containsKey(clazz)) {
            this.addHeaderDelegate(clazz, header);
        }
    }

    @Deprecated
    public <T> MessageBodyReader<T> getServerMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
    }

    public <T> MessageBodyReader<T> getServerMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, RESTEasyTracingLogger tracingLogger) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders, tracingLogger);
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        MessageBodyReader<T> reader = this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
        if (reader != null) {
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
        }
        return reader;
    }

    public <T> MessageBodyReader<T> getClientMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getClientMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
    }

    @Deprecated
    private <T> MessageBodyReader<T> resolveMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders) {
        List<SortedKey<MessageBodyReader>> readers = availableReaders.getPossible(mediaType, type);
        for (SortedKey<MessageBodyReader> reader : readers) {
            if (!reader.getObj().isReadable(type, genericType, annotations, mediaType)) continue;
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
            return reader.getObj();
        }
        return null;
    }

    private <T> MessageBodyReader<T> resolveMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders, RESTEasyTracingLogger tracingLogger) {
        SortedKey<MessageBodyReader> reader;
        List<SortedKey<MessageBodyReader>> readers = availableReaders.getPossible(mediaType, type);
        if (tracingLogger.isLogEnabled("MBR_FIND")) {
            tracingLogger.log("MBR_FIND", type.getName(), genericType instanceof Class ? ((Class)genericType).getName() : genericType, mediaType, Arrays.toString(annotations));
        }
        MessageBodyReader result = null;
        Iterator<SortedKey<MessageBodyReader>> iterator = readers.iterator();
        while (iterator.hasNext()) {
            reader = iterator.next();
            if (reader.getObj().isReadable(type, genericType, annotations, mediaType)) {
                LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
                result = reader.getObj();
                tracingLogger.log("MBR_SELECTED", reader);
                break;
            }
            tracingLogger.log("MBR_NOT_READABLE", result);
        }
        if (tracingLogger.isLogEnabled("MBR_SKIPPED")) {
            while (iterator.hasNext()) {
                reader = iterator.next();
                tracingLogger.log("MBR_SKIPPED", reader.getObj());
            }
        }
        return result;
    }

    private void addExceptionMapper(ExceptionMapper provider, Class providerClass, boolean isBuiltin) {
        if (providerClass.isSynthetic()) {
            providerClass = providerClass.getSuperclass();
        }
        Type exceptionType = Types.getActualTypeArgumentsOfAnInterface(providerClass, ExceptionMapper.class)[0];
        Utils.injectProperties(this, providerClass, provider);
        Class exceptionClass = Types.getRawType((Type)exceptionType);
        if (!Throwable.class.isAssignableFrom(exceptionClass)) {
            throw new RuntimeException(Messages.MESSAGES.incorrectTypeParameterExceptionMapper());
        }
        if (this.sortedExceptionMappers == null) {
            this.sortedExceptionMappers = new CopyOnWriteMap(this.parent.getSortedExceptionMappers());
        }
        int priority = Utils.getPriority(null, null, ExceptionMapper.class, providerClass);
        SortedKey<ExceptionMapper> candidateExceptionMapper = new SortedKey<ExceptionMapper>(null, provider, providerClass, priority, isBuiltin);
        SortedKey<ExceptionMapper> registeredExceptionMapper = this.sortedExceptionMappers.get(exceptionClass);
        if (registeredExceptionMapper != null && candidateExceptionMapper.compareTo(registeredExceptionMapper) > 0) {
            return;
        }
        this.sortedExceptionMappers.put(exceptionClass, candidateExceptionMapper);
    }

    private void addContextInjector(ContextInjector provider, Class providerClass) {
        Type[] typeArgs = Types.getActualTypeArgumentsOfAnInterface((Class)providerClass, ContextInjector.class);
        Utils.injectProperties(this, provider.getClass(), provider);
        if (this.contextInjectors == null) {
            this.contextInjectors = new CopyOnWriteMap<Type, ContextInjector>(this.parent.getContextInjectors());
        }
        this.contextInjectors.put(typeArgs[0], provider);
        if (!Objects.equals(typeArgs[0], typeArgs[1])) {
            if (this.asyncContextInjectors == null) {
                this.asyncContextInjectors = new CopyOnWriteMap<Type, ContextInjector>(this.parent.getAsyncContextInjectors());
            }
            this.asyncContextInjectors.put(typeArgs[1], provider);
        }
    }

    private void addContextResolver(ContextResolver provider, int priority, Class providerClass, boolean builtin) {
        MediaTypeMap<SortedKey<Object>> resolvers;
        if (providerClass.getName().contains("$$Lambda$")) {
            throw new RuntimeException(Messages.MESSAGES.registeringContextResolverAsLambda());
        }
        Type typeParameter = Types.getActualTypeArgumentsOfAnInterface((Class)providerClass, ContextResolver.class)[0];
        Utils.injectProperties(this, providerClass, provider);
        Class parameterClass = Types.getRawType((Type)typeParameter);
        if (this.contextResolvers == null) {
            this.contextResolvers = new ConcurrentHashMap();
            for (Map.Entry<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> entry : this.parent.getContextResolvers().entrySet()) {
                this.contextResolvers.put(entry.getKey(), new MediaTypeMap<SortedKey<ContextResolver>>(entry.getValue()));
            }
        }
        if ((resolvers = this.contextResolvers.get(parameterClass)) == null) {
            resolvers = new MediaTypeMap();
            this.contextResolvers.put(parameterClass, resolvers);
        }
        Produces produces = provider.getClass().getAnnotation(Produces.class);
        SortedKey<ContextResolver> key = new SortedKey<ContextResolver>(ContextResolver.class, provider, providerClass, priority, builtin);
        if (produces != null) {
            for (String produce : produces.value()) {
                MediaType mime = MediaType.valueOf((String)produce);
                resolvers.add(mime, key);
            }
        } else {
            resolvers.add(new MediaType("*", "*"), key);
        }
    }

    private void addStringParameterUnmarshaller(Class<? extends StringParameterUnmarshaller> provider) {
        Type[] intfs;
        if (this.stringParameterUnmarshallers == null) {
            this.stringParameterUnmarshallers = new CopyOnWriteMap(this.parent.getStringParameterUnmarshallers());
        }
        for (Type type : intfs = provider.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(StringParameterUnmarshaller.class)) continue;
            Class aClass = Types.getRawType((Type)pt.getActualTypeArguments()[0]);
            this.stringParameterUnmarshallers.put(aClass, provider);
        }
    }

    public List<ContextResolver> getContextResolvers(Class<?> clazz, MediaType type) {
        MediaTypeMap<SortedKey<ContextResolver>> resolvers = this.getContextResolvers().get(clazz);
        if (resolvers == null) {
            return null;
        }
        ArrayList<ContextResolver> rtn = new ArrayList<ContextResolver>();
        List<SortedKey<ContextResolver>> list = resolvers.getPossible(type);
        list.forEach(resolver -> rtn.add((ContextResolver)resolver.getObj()));
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamConverter getParamConverter(Class clazz, Type genericType, Annotation[] annotations) {
        try {
            ResteasyContext.pushContext(ResteasyProviderFactory.class, this);
            for (SortedKey sortedKey : this.getSortedParamConverterProviders()) {
                ParamConverter converter = ((ParamConverterProvider)sortedKey.getObj()).getConverter(clazz, genericType, annotations);
                if (converter == null) continue;
                ParamConverter paramConverter = converter;
                return paramConverter;
            }
            Iterator<ExtSortedKey<ParamConverterProvider>> iterator = null;
            return iterator;
        }
        finally {
            ResteasyContext.popContextData(ResteasyProviderFactory.class);
        }
    }

    public <T> StringParameterUnmarshaller<T> createStringParameterUnmarshaller(Class<T> clazz) {
        if (this.getStringParameterUnmarshallers().size() == 0) {
            return null;
        }
        Class<? extends StringParameterUnmarshaller> un = this.getStringParameterUnmarshallers().get(clazz);
        if (un == null) {
            return null;
        }
        StringParameterUnmarshaller provider = this.injectedInstance(un);
        return provider;
    }

    public void registerProvider(Class provider) {
        this.registerProvider(provider, false);
    }

    public String toString(Object object, Class clazz, Type genericType, Annotation[] annotations) {
        if (object instanceof String) {
            return (String)object;
        }
        ParamConverter paramConverter = this.getParamConverter(clazz, genericType, annotations);
        if (paramConverter != null) {
            return paramConverter.toString(object);
        }
        return object.toString();
    }

    public String toHeaderString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        Class<?> aClass = object.getClass();
        ParamConverter paramConverter = this.getParamConverter(aClass, null, null);
        if (paramConverter != null) {
            return paramConverter.toString(object);
        }
        RuntimeDelegate.HeaderDelegate delegate = this.getHeaderDelegate(aClass);
        if (delegate != null) {
            return delegate.toString(object);
        }
        return object.toString();
    }

    public RuntimeDelegate.HeaderDelegate getHeaderDelegate(Class<?> aClass) {
        RuntimeDelegate.HeaderDelegate delegate = null;
        delegate = RuntimeDelegate.getInstance() instanceof ResteasyProviderFactory ? this.createHeaderDelegate(aClass) : RuntimeDelegate.getInstance().createHeaderDelegate(aClass);
        return delegate;
    }

    public void registerProvider(Class provider, boolean isBuiltin) {
        this.registerProvider(provider, null, isBuiltin, null);
    }

    public void registerProvider(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts) {
        Map<Class<?>, Map<Class<?>, Integer>> classContracts = this.getClassContracts();
        if (classContracts.containsKey(provider)) {
            LogMessages.LOGGER.providerClassAlreadyRegistered(provider.getName());
            return;
        }
        CopyOnWriteMap newContracts = new CopyOnWriteMap();
        this.processProviderContracts(provider, priorityOverride, isBuiltin, contracts, newContracts);
        this.providerClasses.add(provider);
        classContracts.put(provider, newContracts);
    }

    private void processProviderContracts(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts, Map<Class<?>, Integer> newContracts) {
        int priority;
        this.clientHelper.processProviderContracts(provider, priorityOverride, isBuiltin, contracts, newContracts, this.parent);
        this.serverHelper.processProviderContracts(provider, priorityOverride, isBuiltin, contracts, newContracts, this.parent);
        if (Utils.isA(provider, ParamConverterProvider.class, contracts)) {
            ParamConverterProvider paramConverterProvider = (ParamConverterProvider)this.injectedInstance(provider);
            this.injectProperties(provider);
            if (this.sortedParamConverterProviders == null) {
                this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet<ExtSortedKey<ParamConverterProvider>>(this.parent.getSortedParamConverterProviders()));
            }
            priority = Utils.getPriority(priorityOverride, contracts, ParamConverterProvider.class, provider);
            this.sortedParamConverterProviders.add(new ExtSortedKey<ParamConverterProvider>(null, paramConverterProvider, provider, priority, isBuiltin));
            newContracts.put(ParamConverterProvider.class, priority);
        }
        if (Utils.isA(provider, ExceptionMapper.class, contracts)) {
            try {
                this.addExceptionMapper((ExceptionMapper)this.createProviderInstance(provider), provider, isBuiltin);
                newContracts.put(ExceptionMapper.class, Utils.getPriority(priorityOverride, contracts, ExceptionMapper.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
        if (Utils.isA(provider, ContextResolver.class, contracts)) {
            try {
                int priority2 = Utils.getPriority(priorityOverride, contracts, ContextResolver.class, provider);
                this.addContextResolver((ContextResolver)this.createProviderInstance(provider), priority2, provider, isBuiltin);
                newContracts.put(ContextResolver.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextResolver(), e);
            }
        }
        if (Utils.isA(provider, ContextInjector.class, contracts)) {
            try {
                this.addContextInjector((ContextInjector)this.createProviderInstance(provider), provider);
                int priority3 = Utils.getPriority(priorityOverride, contracts, ContextInjector.class, provider);
                newContracts.put(ContextInjector.class, priority3);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextInjector(), e);
            }
        }
        if (Utils.isA(provider, StringParameterUnmarshaller.class, contracts)) {
            this.addStringParameterUnmarshaller(provider);
            int priority4 = Utils.getPriority(priorityOverride, contracts, StringParameterUnmarshaller.class, provider);
            newContracts.put(StringParameterUnmarshaller.class, priority4);
        }
        if (Utils.isA(provider, InjectorFactory.class, contracts)) {
            try {
                this.injectorFactory = (InjectorFactory)provider.newInstance();
                newContracts.put(InjectorFactory.class, 0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (Utils.isA(provider, Feature.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, Feature.class, provider);
            Feature feature = (Feature)this.injectedInstance(provider);
            if ((constrainedTo == null || constrainedTo.value() == this.getRuntimeType()) && feature.configure((FeatureContext)new FeatureContextDelegate(this))) {
                this.enabledFeatures.add(feature);
            }
            newContracts.put(Feature.class, priority);
        }
        if (Utils.isA(provider, ResourceClassProcessor.class, contracts)) {
            int priority5 = Utils.getPriority(priorityOverride, contracts, ResourceClassProcessor.class, provider);
            this.addResourceClassProcessor(provider, priority5);
            newContracts.put(ResourceClassProcessor.class, priority5);
        }
        if (Utils.isA(provider, RuntimeDelegate.HeaderDelegate.class, contracts)) {
            Type[] headerTypes = Types.getActualTypeArgumentsOfAnInterface((Class)provider, RuntimeDelegate.HeaderDelegate.class);
            if (headerTypes.length == 0) {
                LogMessages.LOGGER.cannotRegisterheaderDelegate(provider);
            } else {
                Class headerClass = Types.getRawType((Type)headerTypes[0]);
                RuntimeDelegate.HeaderDelegate delegate = (RuntimeDelegate.HeaderDelegate)this.createProviderInstance(provider);
                this.addHeaderDelegate(headerClass, delegate);
            }
        }
    }

    public void registerProviderInstance(Object provider) {
        this.registerProviderInstance(provider, null, null, false);
    }

    public void registerProviderInstance(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn) {
        Class<?> providerClass = provider.getClass();
        Map<Class<?>, Map<Class<?>, Integer>> classContracts = this.getClassContracts();
        if (classContracts.containsKey(providerClass)) {
            LogMessages.LOGGER.providerInstanceAlreadyRegistered(providerClass.getName());
            return;
        }
        CopyOnWriteMap newContracts = new CopyOnWriteMap();
        this.processProviderInstanceContracts(provider, contracts, priorityOverride, builtIn, newContracts);
        this.providerInstances.add(provider);
        classContracts.put(providerClass, newContracts);
    }

    private void processProviderInstanceContracts(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn, Map<Class<?>, Integer> newContracts) {
        int priority;
        this.clientHelper.processProviderInstanceContracts(provider, contracts, priorityOverride, builtIn, newContracts, this.parent);
        this.serverHelper.processProviderInstanceContracts(provider, contracts, priorityOverride, builtIn, newContracts, this.parent);
        if (Utils.isA(provider, ParamConverterProvider.class, contracts)) {
            this.injectProperties(provider);
            if (this.sortedParamConverterProviders == null) {
                this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet<ExtSortedKey<ParamConverterProvider>>(this.parent.getSortedParamConverterProviders()));
            }
            priority = Utils.getPriority(priorityOverride, contracts, ParamConverterProvider.class, provider.getClass());
            this.sortedParamConverterProviders.add(new ExtSortedKey<ParamConverterProvider>(null, (ParamConverterProvider)provider, provider.getClass(), priority, builtIn));
            newContracts.put(ParamConverterProvider.class, priority);
        }
        if (Utils.isA(provider, ExceptionMapper.class, contracts)) {
            try {
                this.addExceptionMapper((ExceptionMapper)provider, provider.getClass(), builtIn);
                priority = Utils.getPriority(priorityOverride, contracts, ExceptionMapper.class, provider.getClass());
                newContracts.put(ExceptionMapper.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
        if (Utils.isA(provider, ContextResolver.class, contracts)) {
            try {
                priority = Utils.getPriority(priorityOverride, contracts, ContextResolver.class, provider.getClass());
                this.addContextResolver((ContextResolver)provider, priority, provider.getClass(), false);
                newContracts.put(ContextResolver.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextResolver(), e);
            }
        }
        if (Utils.isA(provider, ContextInjector.class, contracts)) {
            try {
                this.addContextInjector((ContextInjector)provider, provider.getClass());
                priority = Utils.getPriority(priorityOverride, contracts, ContextInjector.class, provider.getClass());
                newContracts.put(ContextInjector.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextInjector(), e);
            }
        }
        if (Utils.isA(provider, InjectorFactory.class, contracts)) {
            this.injectorFactory = (InjectorFactory)provider;
            newContracts.put(InjectorFactory.class, 0);
        }
        if (Utils.isA(provider, Feature.class, contracts)) {
            Feature feature = (Feature)provider;
            Utils.injectProperties(this, provider.getClass(), provider);
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            if ((constrainedTo == null || constrainedTo.value() == this.getRuntimeType()) && feature.configure((FeatureContext)new FeatureContextDelegate(this))) {
                this.enabledFeatures.add(feature);
            }
            int priority2 = Utils.getPriority(priorityOverride, contracts, Feature.class, provider.getClass());
            newContracts.put(Feature.class, priority2);
        }
        if (Utils.isA(provider, ResourceClassProcessor.class, contracts)) {
            int priority3 = Utils.getPriority(priorityOverride, contracts, ResourceClassProcessor.class, provider.getClass());
            this.addResourceClassProcessor((ResourceClassProcessor)provider, priority3);
            newContracts.put(ResourceClassProcessor.class, priority3);
        }
        if (Utils.isA(provider, RuntimeDelegate.HeaderDelegate.class, contracts)) {
            Type[] headerTypes = Types.getActualTypeArgumentsOfAnInterface(provider.getClass(), RuntimeDelegate.HeaderDelegate.class);
            if (headerTypes.length == 0) {
                LogMessages.LOGGER.cannotRegisterheaderDelegate(provider.getClass());
            } else {
                Class headerClass = Types.getRawType((Type)headerTypes[0]);
                this.addHeaderDelegate(headerClass, (RuntimeDelegate.HeaderDelegate)provider);
            }
        }
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        Class<T> exceptionType = type;
        SortedKey<ExceptionMapper> mapper = null;
        Map<Class<?>, SortedKey<ExceptionMapper>> mappers = this.getSortedExceptionMappers();
        while (mapper == null && exceptionType != null) {
            mapper = mappers.get(exceptionType);
            if (mapper != null) continue;
            exceptionType = exceptionType.getSuperclass();
        }
        return mapper != null ? (ExceptionMapper)mapper.getObj() : null;
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapperForClass(Class<T> type) {
        Map<Class<?>, SortedKey<ExceptionMapper>> mappers = this.getSortedExceptionMappers();
        SortedKey<ExceptionMapper> mapper = mappers.get(type);
        return mapper != null ? mapper.getObj() : null;
    }

    public <T> AsyncResponseProvider<T> getAsyncResponseProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncResponseProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncResponseProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public <T> AsyncClientResponseProvider<T> getAsyncClientResponseProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncClientResponseProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncClientResponseProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public <T> AsyncStreamProvider<T> getAsyncStreamProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncStreamProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncStreamProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public MediaType getConcreteMediaTypeFromMessageBodyWriters(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<SortedKey<MessageBodyWriter>> writers = this.getServerMessageBodyWriters().getPossible(mediaType, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            Produces produces;
            MessageBodyWriter mbw;
            Class writerType;
            if (!writer.getObj().isWriteable(type, genericType, annotations, mediaType) || (writerType = Types.getTemplateParameterOfInterface((mbw = writer.getObj()).getClass(), MessageBodyWriter.class)) == null || writerType.equals(Object.class) || !writerType.isAssignableFrom(type) || (produces = mbw.getClass().getAnnotation(Produces.class)) == null) continue;
            for (String produce : produces.value()) {
                MediaType mt = MediaType.valueOf((String)produce);
                if (mt.isWildcardType() || mt.isWildcardSubtype()) continue;
                return mt;
            }
        }
        return null;
    }

    public Map<MessageBodyWriter<?>, Class<?>> getPossibleMessageBodyWritersMap(Class type, Type genericType, Annotation[] annotations, MediaType accept) {
        HashMap map = new HashMap();
        List<SortedKey<MessageBodyWriter>> writers = this.getServerMessageBodyWriters().getPossible(accept, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            Class writerType;
            if (!writer.getObj().isWriteable(type, genericType, annotations, accept)) continue;
            Class<?> mbwc = writer.getObj().getClass();
            if (!mbwc.isInterface() && mbwc.getSuperclass() != null && !mbwc.getSuperclass().equals(Object.class) && mbwc.isSynthetic()) {
                mbwc = mbwc.getSuperclass();
            }
            if ((writerType = Types.getTemplateParameterOfInterface(mbwc, MessageBodyWriter.class)) == null || !writerType.isAssignableFrom(type)) continue;
            map.put(writer.getObj(), writerType);
        }
        return map;
    }

    @Deprecated
    public <T> MessageBodyWriter<T> getServerMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
    }

    public <T> MessageBodyWriter<T> getServerMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, RESTEasyTracingLogger tracingLogger) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters, tracingLogger);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        MessageBodyWriter<T> writer = this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
        if (writer != null) {
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
        }
        return writer;
    }

    public <T> MessageBodyWriter<T> getClientMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getClientMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
    }

    @Deprecated
    private <T> MessageBodyWriter<T> resolveMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters) {
        List<SortedKey<MessageBodyWriter>> writers = availableWriters.getPossible(mediaType, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            if (!writer.getObj().isWriteable(type, genericType, annotations, mediaType)) continue;
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
            return writer.getObj();
        }
        return null;
    }

    private <T> MessageBodyWriter<T> resolveMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters, RESTEasyTracingLogger tracingLogger) {
        SortedKey<MessageBodyWriter> writer;
        List<SortedKey<MessageBodyWriter>> writers = availableWriters.getPossible(mediaType, type);
        if (tracingLogger.isLogEnabled("MBW_FIND")) {
            tracingLogger.log("MBW_FIND", type.getName(), genericType instanceof Class ? ((Class)genericType).getName() : genericType, mediaType, Arrays.toString(annotations));
        }
        MessageBodyWriter result = null;
        Iterator<SortedKey<MessageBodyWriter>> iterator = writers.iterator();
        while (iterator.hasNext()) {
            writer = iterator.next();
            if (writer.getObj().isWriteable(type, genericType, annotations, mediaType)) {
                LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
                result = writer.getObj();
                tracingLogger.log("MBW_SELECTED", result);
                break;
            }
            tracingLogger.log("MBW_NOT_WRITEABLE", result);
        }
        if (tracingLogger.isLogEnabled("MBW_SKIPPED")) {
            while (iterator.hasNext()) {
                writer = iterator.next();
                tracingLogger.log("MBW_SKIPPED", writer.getObj());
            }
        }
        return result;
    }

    public <T> T createEndpoint(Application applicationConfig, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        if (applicationConfig == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.applicationParamNull());
        }
        throw new UnsupportedOperationException();
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        final List<ContextResolver> resolvers = this.getContextResolvers(contextType, mediaType);
        if (resolvers == null) {
            return null;
        }
        if (resolvers.size() == 1) {
            return resolvers.get(0);
        }
        return new ContextResolver<T>(){

            public T getContext(Class type) {
                for (ContextResolver resolver : resolvers) {
                    Object rtn = resolver.getContext(type);
                    if (rtn == null) continue;
                    return rtn;
                }
                return null;
            }
        };
    }

    public <T> T createProviderInstance(Class<? extends T> clazz) {
        return Utils.createProviderInstance(this, clazz);
    }

    public <T> T injectedInstance(Class<? extends T> clazz) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        ConstructorInjector constructorInjector = this.getInjectorFactory().createConstructor(constructor, (ResteasyProviderFactory)this);
        return constructorInjector.construct(false).thenCompose(obj -> {
            PropertyInjector propertyInjector = this.getInjectorFactory().createPropertyInjector(clazz, (ResteasyProviderFactory)this);
            return propertyInjector.inject(obj, false).thenApply(val -> obj);
        }).toCompletableFuture().getNow(null);
    }

    public <T> T injectedInstance(Class<? extends T> clazz, HttpRequest request, HttpResponse response) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        T obj = null;
        if (constructor == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.unableToFindPublicConstructorForClass(clazz.getName()));
        }
        ConstructorInjector constructorInjector = this.getInjectorFactory().createConstructor(constructor, (ResteasyProviderFactory)this);
        obj = constructorInjector.construct(request, response, false).toCompletableFuture().getNow(null);
        PropertyInjector propertyInjector = this.getInjectorFactory().createPropertyInjector(clazz, (ResteasyProviderFactory)this);
        propertyInjector.inject(request, response, obj, false).toCompletableFuture().getNow(null);
        return obj;
    }

    public Map<String, Object> getMutableProperties() {
        return this.properties;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public ResteasyProviderFactory setProperties(Map<String, Object> properties) {
        this.properties = new CopyOnWriteMap<String, Object>(properties);
        return this;
    }

    public ResteasyProviderFactory property(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        return this;
    }

    public Collection<Feature> getEnabledFeatures() {
        if (this.initialized) {
            return this.enabledFeatures;
        }
        HashSet<Feature> set = new HashSet<Feature>();
        if (this.parent != null) {
            set.addAll(this.parent.getEnabledFeatures());
        }
        set.addAll(this.enabledFeatures);
        return set;
    }

    public ResteasyProviderFactory register(Class<?> providerClass) {
        this.registerProvider(providerClass);
        return this;
    }

    public ResteasyProviderFactory register(Object provider) {
        this.registerProviderInstance(provider);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, int priority) {
        this.registerProvider(componentClass, priority, false, null);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LogMessages.LOGGER.attemptingToRegisterEmptyContracts(componentClass.getName());
            return this;
        }
        HashMap cons = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(componentClass)) {
                LogMessages.LOGGER.attemptingToRegisterUnassignableContract(componentClass.getName());
                return this;
            }
            cons.put(contract, 5000);
        }
        this.registerProvider(componentClass, null, false, cons);
        return this;
    }

    public ResteasyProviderFactory register(Object component, int priority) {
        this.registerProviderInstance(component, null, priority, false);
        return this;
    }

    public ResteasyProviderFactory register(Object component, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LogMessages.LOGGER.attemptingToRegisterEmptyContracts(component.getClass().getName());
            return this;
        }
        HashMap cons = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(component.getClass())) {
                LogMessages.LOGGER.attemptingToRegisterUnassignableContract(component.getClass().getName());
                return this;
            }
            cons.put(contract, 5000);
        }
        this.registerProviderInstance(component, cons, null, false);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        for (Class<?> contract : contracts.keySet()) {
            if (contract.isAssignableFrom(componentClass)) continue;
            LogMessages.LOGGER.attemptingToRegisterUnassignableContract(componentClass.getName());
            return this;
        }
        this.registerProvider(componentClass, null, false, contracts);
        return this;
    }

    public ResteasyProviderFactory register(Object component, Map<Class<?>, Integer> contracts) {
        for (Class<?> contract : contracts.keySet()) {
            if (contract.isAssignableFrom(component.getClass())) continue;
            LogMessages.LOGGER.attemptingToRegisterUnassignableContract(component.getClass().getName());
            return this;
        }
        this.registerProviderInstance(component, contracts, null, false);
        return this;
    }

    public Configuration getConfiguration() {
        return this;
    }

    public RuntimeType getRuntimeType() {
        return RuntimeType.SERVER;
    }

    public Collection<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public boolean isEnabled(Feature feature) {
        return this.getEnabledFeatures().contains(feature);
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        Collection<Feature> enabled = this.getEnabledFeatures();
        if (enabled == null) {
            return false;
        }
        for (Feature feature : enabled) {
            if (!featureClass.equals(feature.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Object component) {
        return this.getProviderInstances().contains(component);
    }

    public boolean isRegistered(Class<?> componentClass) {
        return this.getClassContracts().containsKey(componentClass);
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        if (this.classContracts == null && this.parent == null) {
            return Collections.emptyMap();
        }
        if (this.classContracts == null) {
            return this.parent.getContracts(componentClass);
        }
        Map<Class<?>, Integer> classIntegerMap = this.classContracts.get(componentClass);
        if (classIntegerMap == null) {
            return Collections.emptyMap();
        }
        return classIntegerMap;
    }

    public Set<Class<?>> getClasses() {
        Set<Class<?>> providerClasses = this.getProviderClasses();
        return providerClasses == null || providerClasses.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(providerClasses);
    }

    public Set<Object> getInstances() {
        Set<Object> providerInstances = this.getProviderInstances();
        return providerInstances == null || providerInstances.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(providerInstances);
    }

    public Link.Builder createLinkBuilder() {
        return Utils.createLinkBuilder();
    }

    public <I extends RxInvoker> RxInvokerProvider<I> getRxInvokerProvider(Class<I> clazz) {
        for (Map.Entry<Class<?>, Map<Class<?>, Integer>> entry : this.classContracts.entrySet()) {
            RxInvokerProvider rip;
            if (!entry.getValue().containsKey(RxInvokerProvider.class) || !(rip = (RxInvokerProvider)this.createProviderInstance(entry.getKey())).isProviderFor(clazz)) continue;
            return rip;
        }
        return null;
    }

    public RxInvokerProvider<?> getRxInvokerProviderFromReactiveClass(Class<?> clazz) {
        return this.clientHelper.getRxInvokerProviderFromReactiveClass(clazz);
    }

    public boolean isReactive(Class<?> clazz) {
        return this.clientHelper.isReactive(clazz);
    }

    private void addResourceClassProcessor(Class<ResourceClassProcessor> processorClass, int priority) {
        ResourceClassProcessor processor = this.createProviderInstance(processorClass);
        this.addResourceClassProcessor(processor, priority);
    }

    private void addResourceClassProcessor(ResourceClassProcessor processor, int priority) {
        this.resourceBuilder.registerResourceClassProcessor(processor, priority);
    }

    public ResourceBuilder getResourceBuilder() {
        return this.resourceBuilder;
    }

    public <T> T getContextData(Class<T> type) {
        return ResteasyContext.getContextData(type);
    }

    public void initializeClientProviders(ResteasyProviderFactory factory) {
        this.clientHelper.initializeClientProviders(factory);
    }

    public void injectProperties(Object obj) {
        Utils.injectProperties(this, obj);
    }

    public void injectProperties(Object obj, HttpRequest request, HttpResponse response) {
        Utils.injectProperties(this, obj, request, response);
    }

    public StatisticsController getStatisticsController() {
        return this.statisticsController;
    }
}

