/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.annotations.Query;
import org.jboss.resteasy.annotations.jaxrs.CookieParam;
import org.jboss.resteasy.annotations.jaxrs.FormParam;
import org.jboss.resteasy.annotations.jaxrs.HeaderParam;
import org.jboss.resteasy.annotations.jaxrs.PathParam;
import org.jboss.resteasy.core.AsynchronousResponseInjector;
import org.jboss.resteasy.core.ConstructorInjectorImpl;
import org.jboss.resteasy.core.ContextParameterInjector;
import org.jboss.resteasy.core.CookieParamInjector;
import org.jboss.resteasy.core.FormInjector;
import org.jboss.resteasy.core.FormParamInjector;
import org.jboss.resteasy.core.HeaderParamInjector;
import org.jboss.resteasy.core.ListFormInjector;
import org.jboss.resteasy.core.MapFormInjector;
import org.jboss.resteasy.core.MatrixParamInjector;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.core.PathParamInjector;
import org.jboss.resteasy.core.PrefixedFormInjector;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.core.QueryInjector;
import org.jboss.resteasy.core.QueryParamInjector;
import org.jboss.resteasy.core.ResourcePropertyInjector;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceConstructor;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.util.FindAnnotation;
import org.jboss.resteasy.spi.util.Types;

public class InjectorFactoryImpl
implements InjectorFactory {
    public static final InjectorFactoryImpl INSTANCE = new InjectorFactoryImpl();

    public ConstructorInjector createConstructor(Constructor constructor, ResteasyProviderFactory providerFactory) {
        return new ConstructorInjectorImpl(constructor, providerFactory);
    }

    public ConstructorInjector createConstructor(ResourceConstructor constructor, ResteasyProviderFactory providerFactory) {
        return new ConstructorInjectorImpl(constructor, providerFactory);
    }

    public PropertyInjector createPropertyInjector(Class resourceClass, ResteasyProviderFactory providerFactory) {
        return new PropertyInjectorImpl(resourceClass, providerFactory);
    }

    public PropertyInjector createPropertyInjector(ResourceClass resourceClass, ResteasyProviderFactory providerFactory) {
        return new ResourcePropertyInjector(resourceClass, providerFactory);
    }

    public MethodInjector createMethodInjector(ResourceLocator method, ResteasyProviderFactory factory) {
        return new MethodInjectorImpl(method, factory);
    }

    public ValueInjector createParameterExtractor(Parameter parameter, ResteasyProviderFactory providerFactory) {
        return OptionalInjections.wrap(parameter.getGenericType(), innerType -> this.createParameterExtractor0(parameter, providerFactory, (Type)innerType));
    }

    private ValueInjector createParameterExtractor0(Parameter parameter, ResteasyProviderFactory providerFactory, Type parameterType) {
        Class rawType = Types.getRawType((Type)parameterType);
        switch (parameter.getParamType()) {
            case QUERY_PARAM: {
                return new QueryParamInjector(rawType, parameterType, parameter.getAccessibleObject(), parameter.getParamName(), parameter.getDefaultValue(), parameter.isEncoded(), parameter.getAnnotations(), providerFactory);
            }
            case QUERY: {
                return new QueryInjector(rawType, providerFactory);
            }
            case HEADER_PARAM: {
                return new HeaderParamInjector(rawType, parameterType, parameter.getAccessibleObject(), parameter.getParamName(), parameter.getDefaultValue(), parameter.getAnnotations(), providerFactory);
            }
            case FORM_PARAM: {
                return new FormParamInjector(rawType, parameterType, parameter.getAccessibleObject(), parameter.getParamName(), parameter.getDefaultValue(), parameter.isEncoded(), parameter.getAnnotations(), providerFactory);
            }
            case COOKIE_PARAM: {
                return new CookieParamInjector(rawType, parameterType, parameter.getAccessibleObject(), parameter.getParamName(), parameter.getDefaultValue(), parameter.getAnnotations(), providerFactory);
            }
            case PATH_PARAM: {
                return new PathParamInjector(parameter.getType(), parameter.getGenericType(), parameter.getAccessibleObject(), parameter.getParamName(), parameter.getDefaultValue(), parameter.isEncoded(), parameter.getAnnotations(), providerFactory);
            }
            case FORM: {
                String prefix = parameter.getParamName();
                if (prefix.length() > 0) {
                    if (parameterType instanceof ParameterizedType) {
                        ParameterizedType pType = (ParameterizedType)parameterType;
                        if (Types.isA(List.class, (ParameterizedType)pType)) {
                            return new ListFormInjector(rawType, Types.getArgumentType((ParameterizedType)pType, (int)0), prefix, providerFactory);
                        }
                        if (Types.isA(Map.class, (ParameterizedType)pType)) {
                            return new MapFormInjector(rawType, Types.getArgumentType((ParameterizedType)pType, (int)0), Types.getArgumentType((ParameterizedType)pType, (int)1), prefix, providerFactory);
                        }
                    }
                    return new PrefixedFormInjector(rawType, prefix, providerFactory);
                }
                return new FormInjector(rawType, providerFactory);
            }
            case BEAN_PARAM: {
                return new FormInjector(rawType, providerFactory);
            }
            case MATRIX_PARAM: {
                return new MatrixParamInjector(rawType, parameterType, parameter.getAccessibleObject(), parameter.getParamName(), parameter.getDefaultValue(), parameter.isEncoded(), parameter.getAnnotations(), providerFactory);
            }
            case CONTEXT: {
                return new ContextParameterInjector(null, rawType, parameterType, parameter.getAnnotations(), providerFactory);
            }
            case SUSPENDED: {
                return new AsynchronousResponseInjector();
            }
            case MESSAGE_BODY: {
                return new MessageBodyParameterInjector(parameter.getResourceClass().getClazz(), parameter.getAccessibleObject(), rawType, parameterType, parameter.getAnnotations(), providerFactory);
            }
        }
        return null;
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, String defaultName, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory providerFactory) {
        return this.createParameterExtractor(injectTargetClass, injectTarget, defaultName, type, genericType, annotations, true, providerFactory);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, String defaultName, Class type, Type genericType, Annotation[] annotations, boolean useDefault, ResteasyProviderFactory providerFactory) {
        QueryParam queryParam;
        DefaultValue defaultValue = (DefaultValue)FindAnnotation.findAnnotation((Annotation[])annotations, DefaultValue.class);
        boolean encode = FindAnnotation.findAnnotation((Annotation[])annotations, Encoded.class) != null || injectTarget.isAnnotationPresent(Encoded.class) || type.isAnnotationPresent(Encoded.class);
        String defaultVal = null;
        if (defaultValue != null) {
            defaultVal = defaultValue.value();
        }
        if ((queryParam = (QueryParam)FindAnnotation.findAnnotation((Annotation[])annotations, QueryParam.class)) != null) {
            return new QueryParamInjector(type, genericType, injectTarget, queryParam.value(), defaultVal, encode, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, org.jboss.resteasy.annotations.jaxrs.QueryParam.class) != null) {
            return new QueryParamInjector(type, genericType, injectTarget, defaultName, defaultVal, encode, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, Query.class) != null) {
            return new QueryInjector(type, providerFactory);
        }
        javax.ws.rs.HeaderParam header = (javax.ws.rs.HeaderParam)FindAnnotation.findAnnotation((Annotation[])annotations, javax.ws.rs.HeaderParam.class);
        if (header != null) {
            return new HeaderParamInjector(type, genericType, injectTarget, header.value(), defaultVal, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, HeaderParam.class) != null) {
            return new HeaderParamInjector(type, genericType, injectTarget, defaultName, defaultVal, annotations, providerFactory);
        }
        javax.ws.rs.FormParam formParam = (javax.ws.rs.FormParam)FindAnnotation.findAnnotation((Annotation[])annotations, javax.ws.rs.FormParam.class);
        if (formParam != null) {
            return new FormParamInjector(type, genericType, injectTarget, formParam.value(), defaultVal, encode, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, FormParam.class) != null) {
            return new FormParamInjector(type, genericType, injectTarget, defaultName, defaultVal, encode, annotations, providerFactory);
        }
        javax.ws.rs.CookieParam cookie = (javax.ws.rs.CookieParam)FindAnnotation.findAnnotation((Annotation[])annotations, javax.ws.rs.CookieParam.class);
        if (cookie != null) {
            return new CookieParamInjector(type, genericType, injectTarget, cookie.value(), defaultVal, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, CookieParam.class) != null) {
            return new CookieParamInjector(type, genericType, injectTarget, defaultName, defaultVal, annotations, providerFactory);
        }
        javax.ws.rs.PathParam uriParam = (javax.ws.rs.PathParam)FindAnnotation.findAnnotation((Annotation[])annotations, javax.ws.rs.PathParam.class);
        if (uriParam != null) {
            return new PathParamInjector(type, genericType, injectTarget, uriParam.value(), defaultVal, encode, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, PathParam.class) != null) {
            return new PathParamInjector(type, genericType, injectTarget, defaultName, defaultVal, encode, annotations, providerFactory);
        }
        Form form = (Form)FindAnnotation.findAnnotation((Annotation[])annotations, Form.class);
        if (form != null) {
            String prefix = form.prefix();
            if (prefix.length() > 0) {
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)genericType;
                    if (Types.isA(List.class, (ParameterizedType)pType)) {
                        return new ListFormInjector(type, Types.getArgumentType((ParameterizedType)pType, (int)0), prefix, providerFactory);
                    }
                    if (Types.isA(Map.class, (ParameterizedType)pType)) {
                        return new MapFormInjector(type, Types.getArgumentType((ParameterizedType)pType, (int)0), Types.getArgumentType((ParameterizedType)pType, (int)1), prefix, providerFactory);
                    }
                }
                return new PrefixedFormInjector(type, prefix, providerFactory);
            }
            return new FormInjector(type, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, BeanParam.class) != null) {
            return new FormInjector(type, providerFactory);
        }
        MatrixParam matrix = (MatrixParam)FindAnnotation.findAnnotation((Annotation[])annotations, MatrixParam.class);
        if (matrix != null) {
            return new MatrixParamInjector(type, genericType, injectTarget, matrix.value(), defaultVal, encode, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, org.jboss.resteasy.annotations.jaxrs.MatrixParam.class) != null) {
            return new MatrixParamInjector(type, genericType, injectTarget, defaultName, defaultVal, encode, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, Context.class) != null) {
            return new ContextParameterInjector(null, type, genericType, annotations, providerFactory);
        }
        if (FindAnnotation.findAnnotation((Annotation[])annotations, Suspended.class) != null) {
            return new AsynchronousResponseInjector();
        }
        if (AsyncResponse.class.isAssignableFrom(type)) {
            return new AsynchronousResponseInjector();
        }
        if (useDefault) {
            return new MessageBodyParameterInjector(injectTargetClass, injectTarget, type, genericType, annotations, providerFactory);
        }
        return null;
    }

    static enum OptionalInjections {
        OPT(Optional.class, OptionalInjections::getTypeArgument, Optional::empty, Optional::of),
        OINT(OptionalInt.class, x -> Integer.class, OptionalInt::empty, v -> OptionalInt.of((Integer)v)),
        OLONG(OptionalLong.class, x -> Long.class, OptionalLong::empty, v -> OptionalLong.of((Long)v)),
        ODOUBLE(OptionalDouble.class, x -> Double.class, OptionalDouble::empty, v -> OptionalDouble.of((Double)v));

        static Map<Class<?>, OptionalInjections> optionalTypes;
        final Class<?> optional;
        final Function<Type, Type> valueType;
        final Supplier<Object> empty;
        final Function<Object, Object> present;

        private OptionalInjections(Class<?> optional, Function<Type, Type> valueType, Supplier<Object> empty, Function<Object, Object> present) {
            this.optional = optional;
            this.valueType = valueType;
            this.empty = empty;
            this.present = present;
        }

        static ValueInjector wrap(Type paramType, Function<Type, ValueInjector> injectorFactory) {
            return Optional.ofNullable(optionalTypes.get(Types.getRawType((Type)paramType))).map(oi -> new DelegatingInjector((OptionalInjections)((Object)oi), (ValueInjector)injectorFactory.apply(oi.valueType.apply(paramType)))).orElseGet(() -> (ValueInjector)injectorFactory.apply(paramType));
        }

        static Type getTypeArgument(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new UnsupportedOperationException("non-parameterized Optional type: " + type);
            }
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }

        static {
            optionalTypes = Arrays.stream(OptionalInjections.values()).collect(Collectors.toMap(o -> o.optional, Function.identity()));
        }

        static class DelegatingInjector
        implements ValueInjector {
            private final OptionalInjections oi;
            private final ValueInjector delegate;

            DelegatingInjector(OptionalInjections oi, ValueInjector delegate) {
                this.oi = oi;
                this.delegate = delegate;
            }

            public CompletionStage<Object> inject(boolean unwrapAsync) {
                return this.delegate.inject(unwrapAsync).thenApply(this::wrap);
            }

            public CompletionStage<Object> inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
                return this.delegate.inject(request, response, unwrapAsync).thenApply(this::wrap);
            }

            public Object wrap(Object value) {
                if (value == null) {
                    return this.oi.empty.get();
                }
                return this.oi.present.apply(value);
            }
        }
    }
}

