/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.util.MediaTypeHelper;

public class MediaTypeMap<T> {
    private static final Pattern COMPOSITE_PATTERN = Pattern.compile("([^\\+]+)\\+(.+)");
    public static final Pattern COMPOSITE_SUBTYPE_WILDCARD_PATTERN = Pattern.compile("\\*\\+(.+)");
    public static final Pattern WILD_SUBTYPE_COMPOSITE_PATTERN = Pattern.compile("([^\\+]+)\\+\\*");
    private volatile Map<String, SubtypeMap<T>> index = new HashMap<String, SubtypeMap<T>>();
    private volatile Map<CachedMediaTypeAndClass, List<T>> classCache = new HashMap<CachedMediaTypeAndClass, List<T>>();
    private final CopyOnWriteArrayList<Entry<T>> wildcards;
    private final CopyOnWriteArrayList<Entry<T>> all;
    public static boolean useCache = true;

    public MediaTypeMap() {
        this.wildcards = new CopyOnWriteArrayList();
        this.all = new CopyOnWriteArrayList();
    }

    public MediaTypeMap(MediaTypeMap<T> mediaTypeMap) {
        this.index = mediaTypeMap.index;
        this.wildcards = new CopyOnWriteArrayList<Entry<T>>(mediaTypeMap.wildcards);
        this.all = new CopyOnWriteArrayList<Entry<T>>(mediaTypeMap.all);
        this.classCache = mediaTypeMap.classCache;
    }

    public synchronized void add(MediaType type, T obj) {
        MediaType newType = new MediaType(type.getType().toLowerCase(), type.getSubtype().toLowerCase(), type.getParameters());
        Entry entry = new Entry(newType, obj);
        this.classCache = new HashMap<CachedMediaTypeAndClass, List<T>>();
        this.all.add(entry);
        Collections.sort(this.all);
        Map<String, SubtypeMap<T>> oldIndex = this.index;
        this.index = new HashMap<String, SubtypeMap<T>>();
        oldIndex.forEach((key, value) -> this.index.put((String)key, new SubtypeMap((SubtypeMap)value)));
        if (newType.isWildcardType()) {
            this.wildcards.add(entry);
        } else {
            this.index.putIfAbsent(newType.getType(), new SubtypeMap());
            ((SubtypeMap)this.index.get(newType.getType())).add(newType, obj);
        }
    }

    private static <T> List<T> convert(List<Entry<T>> list) {
        ArrayList newList = new ArrayList(list.size());
        for (Entry<T> entry : list) {
            newList.add(entry.object);
        }
        return newList;
    }

    public List<T> getPossible(MediaType accept) {
        accept = new MediaType(accept.getType().toLowerCase(), accept.getSubtype().toLowerCase(), accept.getParameters());
        ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
        if (accept.isWildcardType()) {
            return MediaTypeMap.convert(this.all);
        }
        matches.addAll(this.wildcards);
        SubtypeMap<T> indexed = this.index.get(accept.getType());
        if (indexed != null) {
            matches.addAll(((SubtypeMap)indexed).getPossible(accept));
        }
        Collections.sort(matches);
        return MediaTypeMap.convert(matches);
    }

    public List<T> getPossible(MediaType accept, Class<?> type) {
        List<T> cached = null;
        CachedMediaTypeAndClass cacheEntry = null;
        if (useCache && (cached = this.classCache.get(cacheEntry = new CachedMediaTypeAndClass(type, accept))) != null) {
            return cached;
        }
        accept = new MediaType(accept.getType().toLowerCase(), accept.getSubtype().toLowerCase(), accept.getParameters());
        ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
        if (accept.isWildcardType()) {
            matches.addAll(this.all);
        } else {
            matches.addAll(this.wildcards);
            SubtypeMap<T> indexed = this.index.get(accept.getType());
            if (indexed != null) {
                matches.addAll(((SubtypeMap)indexed).getPossible(accept));
            }
        }
        Collections.sort(matches, new TypedEntryComparator(type));
        cached = MediaTypeMap.convert(matches);
        if (useCache) {
            this.classCache.put(cacheEntry, cached);
        }
        return cached;
    }

    private static class CachedMediaTypeAndClass {
        private WeakReference<Class<?>> clazz;
        private MediaType mediaType;
        private final int hash;

        private CachedMediaTypeAndClass(Class clazz, MediaType mediaType) {
            this.clazz = new WeakReference<Class>(clazz);
            this.mediaType = mediaType;
            int result = clazz.hashCode();
            this.hash = result = 31 * result + (mediaType.getType() != null ? mediaType.getType().hashCode() : 0) + (mediaType.getSubtype() != null ? mediaType.getSubtype().hashCode() : 0);
        }

        private Class<?> getClazz() {
            return (Class)this.clazz.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedMediaTypeAndClass that = (CachedMediaTypeAndClass)o;
            Class<?> clazz = this.getClazz();
            if (clazz == null || that.getClazz() == null) {
                return false;
            }
            if (!clazz.equals(that.getClazz())) {
                return false;
            }
            if (this.mediaType.getType() != null ? !this.mediaType.getType().equals(that.mediaType.getType()) : this.mediaType.getType() != that.mediaType.getType()) {
                return false;
            }
            return !(this.mediaType.getSubtype() != null ? !this.mediaType.getSubtype().equals(that.mediaType.getSubtype()) : this.mediaType.getSubtype() != that.mediaType.getSubtype());
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class SubtypeMap<T> {
        private volatile Map<String, List<Entry<T>>> index;
        private volatile Map<String, List<Entry<T>>> compositeIndex;
        private volatile Map<String, List<Entry<T>>> wildCompositeIndex;
        private final CopyOnWriteArrayList<Entry<T>> wildcards;
        private final CopyOnWriteArrayList<Entry<T>> all;

        private SubtypeMap() {
            this.index = new HashMap<String, List<Entry<T>>>();
            this.compositeIndex = new HashMap<String, List<Entry<T>>>();
            this.wildCompositeIndex = new HashMap<String, List<Entry<T>>>();
            this.wildcards = new CopyOnWriteArrayList();
            this.all = new CopyOnWriteArrayList();
        }

        private SubtypeMap(SubtypeMap<T> subtypeMap) {
            this.index = subtypeMap.index;
            this.compositeIndex = subtypeMap.compositeIndex;
            this.wildCompositeIndex = subtypeMap.wildCompositeIndex;
            this.wildcards = new CopyOnWriteArrayList<Entry<T>>(subtypeMap.wildcards);
            this.all = new CopyOnWriteArrayList<Entry<T>>(subtypeMap.all);
        }

        private void add(MediaType type, T obj) {
            Entry entry = new Entry(type, obj);
            this.all.add(entry);
            Matcher matcher = COMPOSITE_SUBTYPE_WILDCARD_PATTERN.matcher(type.getSubtype());
            Matcher wildCompositeMatcher = WILD_SUBTYPE_COMPOSITE_PATTERN.matcher(type.getSubtype());
            this.index = this.copy(this.index);
            this.compositeIndex = this.copy(this.compositeIndex);
            this.wildCompositeIndex = this.copy(this.wildCompositeIndex);
            if (type.isWildcardSubtype()) {
                this.wildcards.add(entry);
            } else if (matcher.matches()) {
                this.add(this.compositeIndex, matcher.group(1), entry);
            } else if (wildCompositeMatcher.matches()) {
                this.add(this.wildCompositeIndex, wildCompositeMatcher.group(1), entry);
            } else {
                this.add(this.index, type.getSubtype(), entry);
            }
        }

        private Map<String, List<Entry<T>>> copy(Map<String, List<Entry<T>>> original) {
            HashMap copy = new HashMap(original.size());
            original.forEach((key, value) -> {
                List cfr_ignored_0 = copy.put((String)key, new CopyOnWriteArrayList(value));
            });
            return copy;
        }

        private void add(Map<String, List<Entry<T>>> map, String key, Entry<T> entry) {
            map.putIfAbsent(key, new CopyOnWriteArrayList());
            map.get(key).add(entry);
        }

        private List<Entry<T>> getPossible(MediaType accept) {
            List<Entry<T>> indexed2;
            if (accept.isWildcardSubtype()) {
                return this.all;
            }
            ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
            List<Entry<T>> indexed = this.index.get(accept.getSubtype());
            if (indexed != null) {
                matches.addAll(indexed);
            }
            Matcher matcher = COMPOSITE_PATTERN.matcher(accept.getSubtype());
            String compositeKey = accept.getSubtype();
            if (matcher.matches()) {
                String wildCompositeKey = matcher.group(1);
                List<Entry<T>> windex = this.wildCompositeIndex.get(wildCompositeKey);
                if (windex != null) {
                    matches.addAll(windex);
                }
                compositeKey = matcher.group(2);
            }
            if ((indexed2 = this.compositeIndex.get(compositeKey)) != null) {
                matches.addAll(indexed2);
            }
            matches.addAll(this.wildcards);
            return matches;
        }
    }

    private static class Entry<T>
    implements Comparable<Entry<?>> {
        public MediaType mediaType;
        public T object;

        private Entry(MediaType mediaType, T object) {
            this.mediaType = mediaType;
            this.object = object;
        }

        @Override
        public int compareTo(Entry<?> entry) {
            int val = MediaTypeHelper.compareWeight(this.mediaType, entry.mediaType);
            if (val == 0 && this.object instanceof Comparable && entry.object instanceof Comparable) {
                return ((Comparable)this.object).compareTo(entry.object);
            }
            return val;
        }
    }

    private static class TypedEntryComparator
    implements Comparator<Entry<?>>,
    Serializable {
        private static final long serialVersionUID = -8815419198743440920L;
        private Class<?> type;

        TypedEntryComparator(Class<?> type) {
            this.type = type;
        }

        private boolean isAssignableFrom(Typed typed) {
            if (typed.getType() == null) {
                return false;
            }
            return typed.getType().isAssignableFrom(this.type);
        }

        private int compareTypes(Entry<?> entry, Entry<?> entry1) {
            int val = 0;
            if (entry.object instanceof Typed && entry1.object instanceof Typed && this.type != null) {
                boolean twoTyped;
                Typed one = (Typed)entry.object;
                Typed two = (Typed)entry1.object;
                boolean oneTyped = this.isAssignableFrom(one);
                val = oneTyped == (twoTyped = this.isAssignableFrom(two)) && !oneTyped && !twoTyped ? 0 : (oneTyped == twoTyped ? (one.getType().equals(two.getType()) ? 0 : (one.getType().isAssignableFrom(two.getType()) ? 1 : -1)) : (oneTyped ? -1 : 1));
            }
            return val;
        }

        @Override
        public int compare(Entry<?> entry, Entry<?> entry1) {
            int val = this.compareTypes(entry, entry1);
            if (val == 0) {
                val = entry.compareTo(entry1);
            }
            return val;
        }
    }

    public static interface Typed {
        public Class<?> getType();
    }
}

