/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.annotations.StringParameterUnmarshallerBinder;
import org.jboss.resteasy.annotations.jaxrs.HeaderParam;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.util.StringToPrimitive;

public class StringParameterInjector {
    private static final ParamConverter<Character> characterParamConverter = new ParamConverter<Character>(){

        public Character fromString(String value) {
            if (value != null && value.length() == 1) {
                return Character.valueOf(value.charAt(0));
            }
            return null;
        }

        public String toString(Character value) {
            return null;
        }
    };
    protected Class<?> type;
    protected Class<?> baseType;
    protected Type baseGenericType;
    protected Constructor<?> constructor;
    protected Method valueOf;
    protected String defaultValue;
    protected String paramName;
    protected Class<?> paramType;
    protected boolean isCollection;
    protected boolean isArray;
    protected Class<? extends Collection> collectionType;
    protected AccessibleObject target;
    protected ParamConverter<?> paramConverter;
    protected StringParameterUnmarshaller<?> unmarshaller;
    protected RuntimeDelegate.HeaderDelegate<?> delegate;

    public StringParameterInjector() {
    }

    public StringParameterInjector(Class<?> type, Type genericType, String paramName, Class<?> paramType, String defaultValue, AccessibleObject target, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.initialize(type, genericType, paramName, paramType, defaultValue, target, annotations, factory);
    }

    public boolean isCollectionOrArray() {
        return this.isCollection || this.isArray;
    }

    protected void initialize(Class<?> type, Type genericType, String paramName, Class<?> paramType, String defaultValue, AccessibleObject target, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.type = type;
        this.paramName = paramName;
        this.paramType = paramType;
        this.defaultValue = defaultValue;
        this.target = target;
        this.baseType = type;
        this.baseGenericType = genericType;
        if (this.initialize(annotations, factory)) {
            return;
        }
        if (type.isArray()) {
            this.isArray = true;
            this.baseType = type.getComponentType();
            if (this.initialize(annotations, factory)) {
                return;
            }
        }
        this.collectionType = this.convertParameterTypeToCollectionType();
        if (this.collectionType != null) {
            this.isCollection = true;
            if (genericType instanceof ParameterizedType) {
                ParameterizedType zType = (ParameterizedType)this.baseGenericType;
                this.baseType = Types.getRawType((Type)zType.getActualTypeArguments()[0]);
                this.baseGenericType = zType.getActualTypeArguments()[0];
            } else {
                this.baseType = String.class;
                this.baseGenericType = null;
            }
            if (this.initialize(annotations, factory)) {
                return;
            }
        }
        throw new RuntimeException(Messages.MESSAGES.unableToFindConstructor(this.getParamSignature(), target, this.baseType.getName()));
    }

    private boolean initialize(Annotation[] annotations, ResteasyProviderFactory factory) {
        this.paramConverter = factory.getParamConverter(this.baseType, this.baseGenericType, annotations);
        if (this.paramConverter != null) {
            return true;
        }
        this.unmarshaller = factory.createStringParameterUnmarshaller(this.baseType);
        if (this.unmarshaller != null) {
            this.unmarshaller.setAnnotations(annotations);
            return true;
        }
        for (Annotation annotation : annotations) {
            StringParameterUnmarshallerBinder binder = annotation.annotationType().getAnnotation(StringParameterUnmarshallerBinder.class);
            if (binder == null) continue;
            try {
                this.unmarshaller = (StringParameterUnmarshaller)binder.value().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            factory.injectProperties(this.unmarshaller);
            this.unmarshaller.setAnnotations(annotations);
            return true;
        }
        if (javax.ws.rs.HeaderParam.class.equals(this.paramType) || HeaderParam.class.equals(this.paramType)) {
            this.delegate = factory.getHeaderDelegate(this.baseType);
            if (this.delegate != null) {
                return true;
            }
        }
        try {
            this.constructor = this.baseType.getConstructor(String.class);
            if (Modifier.isPublic(this.constructor.getModifiers())) {
                return true;
            }
            this.constructor = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            Method fromValue = this.baseType.getDeclaredMethod("fromValue", String.class);
            if (Modifier.isPublic(fromValue.getModifiers())) {
                for (Annotation ann : this.baseType.getAnnotations()) {
                    if (!ann.annotationType().getName().equals("javax.xml.bind.annotation.XmlEnum")) continue;
                    this.valueOf = fromValue;
                }
            }
        }
        catch (NoSuchMethodException fromValue) {
            // empty catch block
        }
        if (StringToPrimitive.isPrimitive(this.baseType)) {
            return true;
        }
        if (this.valueOf == null) {
            Method fromString = null;
            try {
                fromString = this.baseType.getDeclaredMethod("fromString", String.class);
                if (!Modifier.isStatic(fromString.getModifiers())) {
                    fromString = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                this.valueOf = this.baseType.getDeclaredMethod("valueOf", String.class);
                if (!Modifier.isStatic(this.valueOf.getModifiers())) {
                    this.valueOf = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (this.baseType.isEnum()) {
                if (fromString != null) {
                    this.valueOf = fromString;
                }
            } else if (this.valueOf == null) {
                this.valueOf = fromString;
            }
            if (this.valueOf == null && Character.class.equals(this.baseType)) {
                this.paramConverter = characterParamConverter;
                return true;
            }
        }
        return this.valueOf != null;
    }

    private Class<? extends Collection> convertParameterTypeToCollectionType() {
        if (List.class.equals(this.type) || ArrayList.class.equals(this.type)) {
            return ArrayList.class;
        }
        if (SortedSet.class.equals(this.type) || TreeSet.class.equals(this.type)) {
            return TreeSet.class;
        }
        if (Set.class.equals(this.type) || HashSet.class.equals(this.type)) {
            return HashSet.class;
        }
        return null;
    }

    public String getParamSignature() {
        return (this.paramType != null ? this.paramType.getName() : "") + "(\"" + this.paramName + "\")";
    }

    public Object extractValues(List<String> values) {
        if (values == null && (this.isArray || this.isCollection) && this.defaultValue != null) {
            values = new ArrayList<String>(1);
            values.add(this.defaultValue);
        } else if (values == null) {
            values = Collections.emptyList();
        }
        if (this.isArray) {
            if (values == null) {
                return null;
            }
            Object vals = Array.newInstance(this.type.getComponentType(), values.size());
            for (int i = 0; i < values.size(); ++i) {
                Array.set(vals, i, this.extractValue(values.get(i)));
            }
            return vals;
        }
        if (this.isCollection) {
            if (values == null) {
                return null;
            }
            Collection collection = null;
            try {
                collection = this.collectionType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (String str : values) {
                collection.add(this.extractValue(str));
            }
            if (ArrayList.class.equals(this.collectionType)) {
                return new UnmodifiableArrayList(collection);
            }
            if (TreeSet.class.equals(this.collectionType)) {
                return new UnmodifiableTreeSet(collection);
            }
            if (HashSet.class.equals(this.collectionType)) {
                return new UnmodifiableHashSet(collection);
            }
            throw new RuntimeException("Unable to handle " + this.collectionType);
        }
        if (values == null) {
            return this.extractValue(null);
        }
        if (values.size() == 0) {
            return this.extractValue(null);
        }
        return this.extractValue(values.get(0));
    }

    public Object extractValue(String strVal) {
        block26: {
            if (strVal == null) {
                if (this.defaultValue == null) {
                    if (!StringToPrimitive.isPrimitive(this.baseType)) {
                        return null;
                    }
                    return StringToPrimitive.stringToPrimitiveBoxType(this.baseType, strVal);
                }
                strVal = this.defaultValue;
            }
            if (this.paramConverter != null) {
                try {
                    return this.paramConverter.fromString(strVal);
                }
                catch (Exception pce) {
                    this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), pce);
                }
            }
            if (this.unmarshaller != null) {
                try {
                    return this.unmarshaller.fromString(strVal);
                }
                catch (Exception ue) {
                    this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), ue);
                    break block26;
                }
            }
            if (this.delegate != null) {
                try {
                    return this.delegate.fromString(strVal);
                }
                catch (Exception pce) {
                    this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), pce);
                    break block26;
                }
            }
            if (this.constructor != null) {
                try {
                    return this.constructor.newInstance(strVal);
                }
                catch (InstantiationException e) {
                    this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), e);
                    break block26;
                }
                catch (IllegalAccessException e) {
                    this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), e);
                    break block26;
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof WebApplicationException) {
                        throw (WebApplicationException)targetException;
                    }
                    this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), targetException);
                    break block26;
                }
            }
            if (this.valueOf != null) {
                try {
                    return this.valueOf.invoke(null, strVal);
                }
                catch (IllegalAccessException e) {
                    this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), e);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof WebApplicationException) {
                        throw (WebApplicationException)targetException;
                    }
                    this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), targetException);
                }
            }
        }
        try {
            if (StringToPrimitive.isPrimitive(this.baseType)) {
                return StringToPrimitive.stringToPrimitiveBoxType(this.baseType, strVal);
            }
        }
        catch (Exception e) {
            this.throwProcessingException(Messages.MESSAGES.unableToExtractParameter(this.getParamSignature(), strVal, this.target), e);
        }
        return null;
    }

    public ParamConverter<?> getParamConverter() {
        return this.paramConverter;
    }

    public RuntimeDelegate.HeaderDelegate<?> getHeaderDelegate() {
        return this.delegate;
    }

    protected void throwProcessingException(String message, Throwable cause) {
        throw new BadRequestException(message, cause);
    }

    private static final class UnmodifiableTreeSet<E>
    extends TreeSet<E> {
        private static final long serialVersionUID = 6337958351217117300L;
        private final boolean initialized;

        private UnmodifiableTreeSet(Collection<E> collection) {
            super(collection);
            this.initialized = true;
        }

        private UnmodifiableTreeSet(Comparator<? super E> comparator, Collection<E> collection) {
            super(comparator);
            this.addAll(collection);
            this.initialized = true;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new UnmodifiableTreeSet<E>(super.subSet(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new UnmodifiableTreeSet<E>(super.subSet(fromElement, toElement));
        }

        @Override
        public NavigableSet<E> descendingSet() {
            NavigableSet descendingSet = super.descendingSet();
            return new UnmodifiableTreeSet(descendingSet.comparator(), descendingSet);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new UnmodifiableTreeSet<E>(super.headSet(toElement));
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new UnmodifiableTreeSet<E>(super.headSet(toElement, inclusive));
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new UnmodifiableTreeSet<E>(super.tailSet(fromElement));
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new UnmodifiableTreeSet<E>(super.tailSet(fromElement, inclusive));
        }

        @Override
        public boolean add(E e) {
            if (this.initialized) {
                throw new UnsupportedOperationException();
            }
            return super.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (this.initialized) {
                throw new UnsupportedOperationException();
            }
            return super.addAll(c);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> iterator;
                {
                    this.iterator = UnmodifiableTreeSet.super.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.iterator.forEachRemaining(action);
                }
            };
        }

        @Override
        public Iterator<E> descendingIterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> iterator;
                {
                    this.iterator = UnmodifiableTreeSet.super.descendingIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.iterator.forEachRemaining(action);
                }
            };
        }
    }

    private static final class UnmodifiableHashSet<E>
    extends HashSet<E> {
        private static final long serialVersionUID = 9175388977415467750L;
        private final boolean initialized;

        private UnmodifiableHashSet(Collection<E> collection) {
            super(collection);
            this.initialized = true;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E e) {
            if (this.initialized) {
                throw new UnsupportedOperationException();
            }
            return super.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (this.initialized) {
                throw new UnsupportedOperationException();
            }
            return super.addAll(c);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> iterator;
                {
                    this.iterator = UnmodifiableHashSet.super.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.iterator.forEachRemaining(action);
                }
            };
        }
    }

    private static final class UnmodifiableArrayList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = -4912938596876802150L;

        private UnmodifiableArrayList(Collection<E> collection) {
            super(collection);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new UnmodifiableArrayList(super.subList(fromIndex, toIndex));
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> iterator;
                {
                    this.iterator = UnmodifiableArrayList.super.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.iterator.forEachRemaining(action);
                }
            };
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> iterator;
                {
                    this.iterator = UnmodifiableArrayList.super.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.iterator.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.iterator.previous();
                }

                @Override
                public int nextIndex() {
                    return this.iterator.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.iterator.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.iterator.forEachRemaining(action);
                }
            };
        }
    }
}

