/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jose.jwe.CompressionAlgorithm;
import org.jboss.resteasy.jose.jwe.crypto.DeflateUtils;

class DeflateHelper {
    DeflateHelper() {
    }

    public static byte[] applyCompression(CompressionAlgorithm compressionAlg, byte[] bytes) throws RuntimeException {
        if (compressionAlg == null) {
            return bytes;
        }
        if (compressionAlg.equals((Object)CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.compress(bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.couldntCompressPlainText(e.getLocalizedMessage()), e);
            }
        }
        throw new RuntimeException(Messages.MESSAGES.unsupportedCompressionAlgorithm(compressionAlg));
    }

    public static byte[] applyDecompression(CompressionAlgorithm compressionAlg, byte[] bytes) throws RuntimeException {
        if (compressionAlg == null) {
            return bytes;
        }
        if (compressionAlg.equals((Object)CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.decompress(bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.couldntDecompressPlainText(e.getLocalizedMessage()), e);
            }
        }
        throw new RuntimeException(Messages.MESSAGES.unsupportedCompressionAlgorithm(compressionAlg));
    }
}

