/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.ActiveContextState;
import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.impl.ThreadContextProviderPlan;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class CapturedContextState {
    private List<ThreadContextSnapshot> threadContext = new LinkedList<ThreadContextSnapshot>();
    private SmallRyeContextManager context;

    CapturedContextState(SmallRyeContextManager context, ThreadContextProviderPlan plan, Map<String, String> props) {
        ThreadContextSnapshot snapshot;
        this.context = context;
        for (ThreadContextProvider provider : plan.propagatedProviders) {
            snapshot = provider.currentContext(props);
            if (snapshot == null) continue;
            this.threadContext.add(snapshot);
        }
        for (ThreadContextProvider provider : plan.clearedProviders) {
            snapshot = provider.clearedContext(props);
            if (snapshot == null) continue;
            this.threadContext.add(snapshot);
        }
    }

    public ActiveContextState begin() {
        return new ActiveContextState(this.context, this.threadContext);
    }
}

