/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.CleanAutoCloseable;
import io.smallrye.context.JdkSpecific;
import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.SmallRyeContextManagerProvider;
import io.smallrye.context.impl.CapturedContextState;
import io.smallrye.context.impl.Contextualized;
import io.smallrye.context.impl.DefaultValues;
import io.smallrye.context.impl.SlowCapturedContextState;
import io.smallrye.context.impl.SmallRyeThreadContextStorageDeclaration;
import io.smallrye.context.impl.ThreadContextProviderPlan;
import io.smallrye.context.impl.wrappers.ContextualBiConsumer;
import io.smallrye.context.impl.wrappers.ContextualBiConsumer1;
import io.smallrye.context.impl.wrappers.ContextualBiConsumer2;
import io.smallrye.context.impl.wrappers.ContextualBiConsumerN;
import io.smallrye.context.impl.wrappers.ContextualBiFunction;
import io.smallrye.context.impl.wrappers.ContextualBiFunction1;
import io.smallrye.context.impl.wrappers.ContextualBiFunction2;
import io.smallrye.context.impl.wrappers.ContextualBiFunctionN;
import io.smallrye.context.impl.wrappers.ContextualCallable;
import io.smallrye.context.impl.wrappers.ContextualCallable1;
import io.smallrye.context.impl.wrappers.ContextualCallable2;
import io.smallrye.context.impl.wrappers.ContextualCallableN;
import io.smallrye.context.impl.wrappers.ContextualConsumer;
import io.smallrye.context.impl.wrappers.ContextualConsumer1;
import io.smallrye.context.impl.wrappers.ContextualConsumer2;
import io.smallrye.context.impl.wrappers.ContextualConsumerN;
import io.smallrye.context.impl.wrappers.ContextualExecutor;
import io.smallrye.context.impl.wrappers.ContextualExecutor1;
import io.smallrye.context.impl.wrappers.ContextualExecutor2;
import io.smallrye.context.impl.wrappers.ContextualExecutorN;
import io.smallrye.context.impl.wrappers.ContextualFunction;
import io.smallrye.context.impl.wrappers.ContextualFunction1;
import io.smallrye.context.impl.wrappers.ContextualFunction2;
import io.smallrye.context.impl.wrappers.ContextualFunctionN;
import io.smallrye.context.impl.wrappers.ContextualRunnable;
import io.smallrye.context.impl.wrappers.ContextualRunnable1;
import io.smallrye.context.impl.wrappers.ContextualRunnable2;
import io.smallrye.context.impl.wrappers.ContextualRunnableN;
import io.smallrye.context.impl.wrappers.ContextualSupplier;
import io.smallrye.context.impl.wrappers.ContextualSupplier1;
import io.smallrye.context.impl.wrappers.ContextualSupplier2;
import io.smallrye.context.impl.wrappers.ContextualSupplierN;
import io.smallrye.context.impl.wrappers.SlowContextualBiConsumer;
import io.smallrye.context.impl.wrappers.SlowContextualBiFunction;
import io.smallrye.context.impl.wrappers.SlowContextualCallable;
import io.smallrye.context.impl.wrappers.SlowContextualConsumer;
import io.smallrye.context.impl.wrappers.SlowContextualExecutor;
import io.smallrye.context.impl.wrappers.SlowContextualFunction;
import io.smallrye.context.impl.wrappers.SlowContextualRunnable;
import io.smallrye.context.impl.wrappers.SlowContextualSupplier;
import io.smallrye.context.storage.spi.StorageManager;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ThreadContext;

public class SmallRyeThreadContext
implements ThreadContext {
    static final ThreadLocal<SmallRyeThreadContext> currentThreadContext = StorageManager.threadLocal(SmallRyeThreadContextStorageDeclaration.class);
    private static final CleanAutoCloseable NULL_THREAD_STATE = new CleanAutoCloseable(){

        @Override
        public void close() {
            currentThreadContext.remove();
        }
    };
    private static final Executor PASSTHROUGH_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    private final ThreadContextProviderPlan plan;
    private final String injectionPointName;
    private final ExecutorService defaultExecutor;

    public static CleanAutoCloseable withThreadContext(SmallRyeThreadContext threadContext) {
        final SmallRyeThreadContext oldValue = currentThreadContext.get();
        currentThreadContext.set(threadContext);
        if (oldValue == null) {
            return NULL_THREAD_STATE;
        }
        return new CleanAutoCloseable(){

            @Override
            public void close() {
                currentThreadContext.set(oldValue);
            }
        };
    }

    public static void withThreadContext(SmallRyeThreadContext threadContext, Runnable f) {
        SmallRyeThreadContext oldValue = currentThreadContext.get();
        currentThreadContext.set(threadContext);
        try {
            f.run();
        }
        finally {
            if (oldValue == null) {
                currentThreadContext.remove();
            } else {
                currentThreadContext.set(oldValue);
            }
        }
    }

    public static SmallRyeThreadContext getCurrentThreadContextOrPropagatedContexts() {
        return SmallRyeThreadContext.getCurrentThreadContext(SmallRyeContextManagerProvider.getManager().allPropagatedThreadContext());
    }

    public static SmallRyeThreadContext getCurrentThreadContextOrClearedContexts() {
        return SmallRyeThreadContext.getCurrentThreadContext(SmallRyeContextManagerProvider.getManager().allClearedThreadContext());
    }

    public static SmallRyeThreadContext getCurrentThreadContext(SmallRyeThreadContext defaultValue) {
        SmallRyeThreadContext threadContext = currentThreadContext.get();
        return threadContext != null ? threadContext : defaultValue;
    }

    public static SmallRyeThreadContext getCurrentThreadContext() {
        return SmallRyeThreadContext.getCurrentThreadContext(null);
    }

    public SmallRyeThreadContext(SmallRyeContextManager manager, String[] propagated, String[] unchanged, String[] cleared, String injectionPointName, ExecutorService defaultExecutor) {
        this.plan = manager.getProviderPlan(propagated, unchanged, cleared);
        this.injectionPointName = injectionPointName;
        this.defaultExecutor = defaultExecutor;
    }

    private void checkPrecontextualized(Object action) {
        if (action instanceof Contextualized) {
            throw new IllegalArgumentException("Action is already contextualized");
        }
    }

    public ThreadContextProviderPlan getPlan() {
        return this.plan;
    }

    public ExecutorService getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public boolean isEmpty() {
        return this.plan.isEmpty();
    }

    public boolean isContextualized(Object lambda) {
        return lambda instanceof Contextualized;
    }

    public static Builder builder() {
        return SmallRyeContextManagerProvider.instance().getContextManager().newThreadContextBuilder();
    }

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> future) {
        return this.withContextCapture(future, this.defaultExecutor, 2);
    }

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> future, Executor executor, int flags) {
        return JdkSpecific.newCompletableFutureWrapper(this, future, executor, flags);
    }

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> stage) {
        return this.withContextCapture(stage, this.defaultExecutor);
    }

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> stage, Executor executor) {
        if (stage instanceof CompletableFuture) {
            return JdkSpecific.newCompletableFutureWrapper(this, (CompletableFuture)stage, executor, 3);
        }
        return JdkSpecific.newCompletionStageWrapper(this, stage, executor);
    }

    public <U> CompletableFuture<U> completedFuture(U value) {
        return this.withContextCapture(CompletableFuture.completedFuture(value), this.defaultExecutor, 0);
    }

    public <U> CompletionStage<U> completedStage(U value) {
        return this.completedFuture(value);
    }

    public <U> CompletableFuture<U> failedFuture(Throwable ex) {
        CompletableFuture ret = new CompletableFuture();
        ret.completeExceptionally(ex);
        return this.withContextCapture(ret, this.defaultExecutor, 0);
    }

    public <U> CompletionStage<U> failedStage(Throwable ex) {
        return this.failedFuture(ex);
    }

    public <U> CompletableFuture<U> newIncompleteFuture() {
        CompletableFuture ret = new CompletableFuture();
        return this.withContextCapture(ret, this.defaultExecutor, 0);
    }

    public <T> CompletableFuture<T> copy(CompletableFuture<T> stage) {
        return this.withContextCapture(stage, this.defaultExecutor, 0);
    }

    public <T> CompletionStage<T> copy(CompletionStage<T> stage) {
        return this.withContextCapture(stage, this.defaultExecutor);
    }

    public Executor currentContextExecutor() {
        if (this.plan.isEmpty()) {
            return PASSTHROUGH_EXECUTOR;
        }
        if (this.plan.isFast()) {
            ContextualExecutor ret = null;
            switch (this.plan.size()) {
                case 1: {
                    ret = new ContextualExecutor1();
                    break;
                }
                case 2: {
                    ret = new ContextualExecutor2();
                    break;
                }
                default: {
                    ret = new ContextualExecutorN(this.plan.size());
                }
            }
            this.plan.takeThreadContextSnapshotsFast(this, currentThreadContext, ret);
            return ret;
        }
        return new SlowContextualExecutor(this.captureContext());
    }

    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> consumer) {
        this.checkPrecontextualized(consumer);
        if (this.plan.isEmpty()) {
            return consumer;
        }
        if (this.plan.isFast()) {
            ContextualBiConsumer<T, U> ret = null;
            switch (this.plan.size()) {
                case 1: {
                    ret = new ContextualBiConsumer1<T, U>(consumer);
                    break;
                }
                case 2: {
                    ret = new ContextualBiConsumer2<T, U>(consumer);
                    break;
                }
                default: {
                    ret = new ContextualBiConsumerN<T, U>(consumer, this.plan.size());
                }
            }
            this.plan.takeThreadContextSnapshotsFast(this, currentThreadContext, ret);
            return ret;
        }
        return new SlowContextualBiConsumer<T, U>(this.captureContext(), consumer);
    }

    <T, U> BiConsumer<T, U> contextualConsumerUnlessContextualized(BiConsumer<T, U> consumer) {
        if (consumer instanceof Contextualized) {
            return consumer;
        }
        return this.contextualConsumer(consumer);
    }

    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> function) {
        this.checkPrecontextualized(function);
        if (this.plan.isEmpty()) {
            return function;
        }
        if (this.plan.isFast()) {
            ContextualBiFunction<T, U, R> ret = null;
            switch (this.plan.size()) {
                case 1: {
                    ret = new ContextualBiFunction1<T, U, R>(function);
                    break;
                }
                case 2: {
                    ret = new ContextualBiFunction2<T, U, R>(function);
                    break;
                }
                default: {
                    ret = new ContextualBiFunctionN<T, U, R>(function, this.plan.size());
                }
            }
            this.plan.takeThreadContextSnapshotsFast(this, currentThreadContext, ret);
            return ret;
        }
        return new SlowContextualBiFunction<T, U, R>(this.captureContext(), function);
    }

    <T, U, R> BiFunction<T, U, R> contextualFunctionUnlessContextualized(BiFunction<T, U, R> function) {
        if (function instanceof Contextualized) {
            return function;
        }
        return this.contextualFunction(function);
    }

    public <R> Callable<R> contextualCallable(Callable<R> callable) {
        this.checkPrecontextualized(callable);
        if (this.plan.isEmpty()) {
            return callable;
        }
        if (this.plan.isFast()) {
            ContextualCallable<R> ret = null;
            switch (this.plan.size()) {
                case 1: {
                    ret = new ContextualCallable1<R>(callable);
                    break;
                }
                case 2: {
                    ret = new ContextualCallable2<R>(callable);
                    break;
                }
                default: {
                    ret = new ContextualCallableN<R>(callable, this.plan.size());
                }
            }
            this.plan.takeThreadContextSnapshotsFast(this, currentThreadContext, ret);
            return ret;
        }
        return new SlowContextualCallable<R>(this.captureContext(), callable);
    }

    <R> Callable<R> contextualCallableUnlessContextualized(Callable<R> callable) {
        if (callable instanceof Contextualized) {
            return callable;
        }
        return this.contextualCallable(callable);
    }

    public <T> Consumer<T> contextualConsumer(Consumer<T> consumer) {
        this.checkPrecontextualized(consumer);
        if (this.plan.isEmpty()) {
            return consumer;
        }
        if (this.plan.isFast()) {
            ContextualConsumer<T> ret = null;
            switch (this.plan.size()) {
                case 1: {
                    ret = new ContextualConsumer1<T>(consumer);
                    break;
                }
                case 2: {
                    ret = new ContextualConsumer2<T>(consumer);
                    break;
                }
                default: {
                    ret = new ContextualConsumerN<T>(consumer, this.plan.size());
                }
            }
            this.plan.takeThreadContextSnapshotsFast(this, currentThreadContext, ret);
            return ret;
        }
        return new SlowContextualConsumer<T>(this.captureContext(), consumer);
    }

    <T> Consumer<T> contextualConsumerUnlessContextualized(Consumer<T> consumer) {
        if (consumer instanceof Contextualized) {
            return consumer;
        }
        return this.contextualConsumer(consumer);
    }

    public <T, R> Function<T, R> contextualFunction(Function<T, R> function) {
        this.checkPrecontextualized(function);
        if (this.plan.isEmpty()) {
            return function;
        }
        if (this.plan.isFast()) {
            ContextualFunction<T, R> ret = null;
            switch (this.plan.size()) {
                case 1: {
                    ret = new ContextualFunction1<T, R>(function);
                    break;
                }
                case 2: {
                    ret = new ContextualFunction2<T, R>(function);
                    break;
                }
                default: {
                    ret = new ContextualFunctionN<T, R>(function, this.plan.size());
                }
            }
            this.plan.takeThreadContextSnapshotsFast(this, currentThreadContext, ret);
            return ret;
        }
        return new SlowContextualFunction<T, R>(this.captureContext(), function);
    }

    <T, R> Function<T, R> contextualFunctionUnlessContextualized(Function<T, R> function) {
        if (function instanceof Contextualized) {
            return function;
        }
        return this.contextualFunction(function);
    }

    public Runnable contextualRunnable(Runnable runnable) {
        this.checkPrecontextualized(runnable);
        if (this.plan.isEmpty()) {
            return runnable;
        }
        if (this.plan.isFast()) {
            ContextualRunnable ret = null;
            switch (this.plan.size()) {
                case 1: {
                    ret = new ContextualRunnable1(runnable);
                    break;
                }
                case 2: {
                    ret = new ContextualRunnable2(runnable);
                    break;
                }
                default: {
                    ret = new ContextualRunnableN(runnable, this.plan.size());
                }
            }
            this.plan.takeThreadContextSnapshotsFast(this, currentThreadContext, ret);
            return ret;
        }
        return new SlowContextualRunnable(this.captureContext(), runnable);
    }

    Runnable contextualRunnableUnlessContextualized(Runnable runnable) {
        if (runnable instanceof Contextualized) {
            return runnable;
        }
        return this.contextualRunnable(runnable);
    }

    public <R> Supplier<R> contextualSupplier(Supplier<R> supplier) {
        this.checkPrecontextualized(supplier);
        if (this.plan.isEmpty()) {
            return supplier;
        }
        if (this.plan.isFast()) {
            ContextualSupplier<R> ret = null;
            switch (this.plan.size()) {
                case 1: {
                    ret = new ContextualSupplier1<R>(supplier);
                    break;
                }
                case 2: {
                    ret = new ContextualSupplier2<R>(supplier);
                    break;
                }
                default: {
                    ret = new ContextualSupplierN<R>(supplier, this.plan.size());
                }
            }
            this.plan.takeThreadContextSnapshotsFast(this, currentThreadContext, ret);
            return ret;
        }
        return new SlowContextualSupplier<R>(this.captureContext(), supplier);
    }

    <R> Supplier<R> contextualSupplierUnlessContextualized(Supplier<R> supplier) {
        if (supplier instanceof Contextualized) {
            return supplier;
        }
        return this.contextualSupplier(supplier);
    }

    private CapturedContextState captureContext() {
        return new SlowCapturedContextState(this);
    }

    public String toString() {
        String DELIMITER = ", ";
        StringBuilder builder = new StringBuilder();
        builder.append(SmallRyeThreadContext.class.getName()).append(", ");
        builder.append("with cleared contexts: ").append(this.plan.clearedProviders).append(", ");
        builder.append("with propagated contexts: ").append(this.plan.propagatedProviders).append(", ");
        builder.append("with unchanged contexts: ").append(this.plan.unchangedProviders);
        if (this.injectionPointName != null) {
            builder.append(", ").append(" with injection point name: ").append(this.injectionPointName);
        }
        return builder.toString();
    }

    public static class Builder
    implements ThreadContext.Builder {
        private String[] propagated;
        private String[] unchanged;
        private String[] cleared;
        private final SmallRyeContextManager manager;
        private String injectionPointName = null;

        public Builder(SmallRyeContextManager manager) {
            this.manager = manager;
            DefaultValues defaultValues = manager.getDefaultValues();
            this.propagated = defaultValues.getThreadPropagated();
            this.unchanged = defaultValues.getThreadUnchanged();
            this.cleared = defaultValues.getThreadCleared();
        }

        public SmallRyeThreadContext build() {
            return new SmallRyeThreadContext(this.manager, this.propagated, this.unchanged, this.cleared, this.injectionPointName, this.manager.getDefaultExecutorService());
        }

        public Builder propagated(String ... types) {
            this.propagated = types;
            return this;
        }

        public Builder unchanged(String ... types) {
            this.unchanged = types;
            return this;
        }

        public Builder cleared(String ... types) {
            this.cleared = types;
            return this;
        }

        public Builder injectionPointName(String name) {
            this.injectionPointName = name;
            return this;
        }
    }
}

