/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Priority;
import javax.json.bind.Jsonb;
import javax.ws.rs.Consumes;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jboss.resteasy.plugins.providers.jsonb.AbstractJsonBindingProvider;
import org.jboss.resteasy.plugins.providers.jsonb.i18n.Messages;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.Types;

@Provider
@Produces(value={"application/json", "application/*+json", "text/json", "*/*"})
@Consumes(value={"application/json", "application/*+json", "text/json", "*/*"})
@Priority(value=4900)
public class JsonBindingProvider
extends AbstractJsonBindingProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.isGenericJaxb(type, genericType)) {
            return false;
        }
        return JsonBindingProvider.isSupportedMediaType(mediaType) && (!this.isJaxbClass(type) || FindAnnotation.findJsonBindingAnnotations((Annotation[])annotations).length != 0);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Jsonb jsonb = this.getJsonb(type);
        try {
            return jsonb.fromJson(entityStream, genericType);
        }
        catch (Throwable e) {
            throw new ProcessingException(Messages.MESSAGES.jsonBDeserializationError(e));
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.isGenericJaxb(type, genericType)) {
            return false;
        }
        return JsonBindingProvider.isSupportedMediaType(mediaType) && (!this.isJaxbClass(type) || FindAnnotation.findJsonBindingAnnotations((Annotation[])annotations).length != 0);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Jsonb jsonb = this.getJsonb(type);
        try {
            entityStream.write(jsonb.toJson(t).getBytes(JsonBindingProvider.getCharset(mediaType)));
            entityStream.flush();
        }
        catch (Throwable e) {
            throw new ProcessingException(Messages.MESSAGES.jsonBSerializationError(e.toString()));
        }
    }

    private boolean isGenericJaxb(Class<?> type, Type genericType) {
        Class baseType;
        Class valueType;
        if (Map.class.isAssignableFrom(type) && genericType != null && (valueType = Types.getMapValueType((Type)genericType)) != null && this.isJaxbClass(valueType)) {
            return true;
        }
        return (Collection.class.isAssignableFrom(type) || type.isArray()) && genericType != null && (baseType = Types.getCollectionBaseType(type, (Type)genericType)) != null && this.isJaxbClass(baseType);
    }

    private boolean isJaxbClass(Class<?> classType) {
        return classType.isAnnotationPresent(XmlRootElement.class) || classType.isAnnotationPresent(XmlType.class) || classType.isAnnotationPresent(XmlJavaTypeAdapter.class) || classType.isAnnotationPresent(XmlSeeAlso.class) || JAXBElement.class.equals(classType);
    }
}

