/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.plugins.providers.multipart.HeaderFlushedOutputStream;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMultipartWriter {
    @Context
    protected Providers workers;

    protected void write(MultipartOutput multipartOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            boundary = multipartOutput.getBoundary();
            httpHeaders.putSingle((Object)"Content-Type", (Object)(mediaType.toString() + "; boundary=" + multipartOutput.getBoundary()));
        }
        byte[] boundaryBytes = ("--" + boundary).getBytes();
        this.writeParts(multipartOutput, entityStream, boundaryBytes);
        entityStream.write(boundaryBytes);
        entityStream.write("--".getBytes());
    }

    protected void writeParts(MultipartOutput multipartOutput, OutputStream entityStream, byte[] boundaryBytes) throws IOException {
        for (OutputPart part : multipartOutput.getParts()) {
            MultivaluedMapImpl headers = new MultivaluedMapImpl();
            this.writePart(entityStream, boundaryBytes, part, (MultivaluedMap<String, Object>)headers);
        }
    }

    protected void writePart(OutputStream entityStream, byte[] boundaryBytes, OutputPart part, MultivaluedMap<String, Object> headers) throws IOException {
        entityStream.write(boundaryBytes);
        entityStream.write("\r\n".getBytes());
        headers.putAll(part.getHeaders());
        headers.putSingle((Object)"Content-Type", (Object)part.getMediaType());
        Object entity = part.getEntity();
        Class entityType = part.getType();
        Type entityGenericType = part.getGenericType();
        MessageBodyWriter writer = this.workers.getMessageBodyWriter(entityType, entityGenericType, null, part.getMediaType());
        long size = writer.getSize(entity, entityType, entityGenericType, null, part.getMediaType());
        if (size > -1L) {
            headers.putSingle((Object)"Content-Length", (Object)Integer.toString((int)size));
        }
        writer.writeTo(entity, entityType, entityGenericType, null, part.getMediaType(), headers, (OutputStream)new HeaderFlushedOutputStream(headers, entityStream));
        entityStream.write("\r\n".getBytes());
    }
}

