/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.message.BinaryBody;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Message;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.message.TextBody;
import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.util.CharsetUtil;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.GenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartInputImpl
implements MultipartInput {
    protected MediaType contentType;
    protected Providers workers;
    protected Message mimeMessage;
    protected List<InputPart> parts = new ArrayList<InputPart>();
    protected static final Annotation[] empty = new Annotation[0];

    public MultipartInputImpl(MediaType contentType, Providers workers) {
        this.contentType = contentType;
        this.workers = workers;
    }

    public void parse(InputStream is) throws IOException {
        this.mimeMessage = new Message(this.addHeaderToHeadlessStream(is));
        this.extractParts();
    }

    protected InputStream addHeaderToHeadlessStream(InputStream is) throws UnsupportedEncodingException {
        return new SequenceInputStream(this.createHeaderInputStream(), is);
    }

    protected InputStream createHeaderInputStream() throws UnsupportedEncodingException {
        String header = "Content-Type: " + this.contentType + "\r\n\r\n";
        return new ByteArrayInputStream(header.getBytes("utf-8"));
    }

    @Override
    public String getPreamble() {
        return ((Multipart)this.mimeMessage.getBody()).getPreamble();
    }

    @Override
    public List<InputPart> getParts() {
        return this.parts;
    }

    protected void extractParts() throws IOException {
        Multipart multipart = (Multipart)this.mimeMessage.getBody();
        for (BodyPart bodyPart : multipart.getBodyParts()) {
            this.parts.add(this.extractPart(bodyPart));
        }
    }

    protected InputPart extractPart(BodyPart bodyPart) throws IOException {
        return new PartImpl(bodyPart);
    }

    public static void main(String[] args) throws Exception {
        String input = "URLSTR: file:/Users/billburke/jboss/resteasy-jaxrs/resteasy-jaxrs/src/test/test-data/data.txt\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"part1\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nThis is Value 1\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"part2\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nThis is Value 2\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"data.txt\"; filename=\"data.txt\"\r\nContent-Type: application/octet-stream; charset=ISO-8859-1\r\nContent-Transfer-Encoding: binary\r\n\r\nhello world\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3--";
        ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("boundary", "B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3");
        MediaType contentType = new MediaType("multipart", "form-data", parameters);
        MultipartInputImpl multipart = new MultipartInputImpl(contentType, null);
        multipart.parse(bais);
        System.out.println(multipart.getPreamble());
        System.out.println("**********");
        for (InputPart part : multipart.getParts()) {
            System.out.println("--");
            System.out.println("\"" + part.getBodyAsString() + "\"");
        }
        System.out.println("done");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PartImpl
    implements InputPart {
        private BodyPart bodyPart;
        private MediaType contentType;
        private MultivaluedMap<String, String> headers = new CaseInsensitiveMap();

        public PartImpl(BodyPart bodyPart) {
            this.bodyPart = bodyPart;
            for (Field field : bodyPart.getHeader()) {
                this.headers.add((Object)field.getName(), (Object)field.getBody());
                if (!(field instanceof ContentTypeField)) continue;
                this.contentType = MediaType.valueOf((String)field.getBody());
            }
            if (this.contentType == null) {
                this.contentType = MediaType.TEXT_PLAIN_TYPE;
            }
        }

        @Override
        public <T> T getBody(Class<T> type, Type genericType) throws IOException {
            MessageBodyReader reader = MultipartInputImpl.this.workers.getMessageBodyReader(type, genericType, empty, this.contentType);
            return (T)reader.readFrom(type, genericType, empty, this.contentType, this.headers, this.getBody());
        }

        @Override
        public <T> T getBody(GenericType<T> type) throws IOException {
            return this.getBody(type.getType(), type.getGenericType());
        }

        public InputStream getBody() throws IOException {
            Body body = this.bodyPart.getBody();
            InputStream result = null;
            if (body instanceof TextBody) {
                final Reader reader = ((TextBody)body).getReader();
                result = new InputStream(){

                    public int read() throws IOException {
                        int c = reader.read();
                        return c;
                    }
                };
            } else if (body instanceof BinaryBody) {
                result = ((BinaryBody)body).getInputStream();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getBodyAsString() throws IOException {
            Body body = this.bodyPart.getBody();
            String result = null;
            if (body instanceof TextBody) {
                Reader reader = ((TextBody)body).getReader();
                try {
                    StringWriter writer = new StringWriter();
                    char[] buffer = new char[4048];
                    int n = 0;
                    while ((n = reader.read(buffer)) != -1) {
                        writer.write(buffer, 0, n);
                    }
                    result = writer.toString();
                }
                finally {
                    reader.close();
                }
            }
            if (body instanceof BinaryBody) {
                InputStream inputStream = ((BinaryBody)body).getInputStream();
                InputStreamReader inputStreamReader = null;
                try {
                    String charset = (String)this.contentType.getParameters().get("charset");
                    if (charset != null) {
                        charset = CharsetUtil.toJavaCharset((String)charset);
                    }
                    inputStreamReader = charset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charset);
                    StringWriter writer = new StringWriter();
                    char[] buffer = new char[4048];
                    int n = 0;
                    while ((n = inputStreamReader.read(buffer)) != -1) {
                        writer.write(buffer, 0, n);
                    }
                    result = writer.toString();
                }
                finally {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    inputStream.close();
                }
            }
            return result;
        }

        @Override
        public MultivaluedMap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public MediaType getMediaType() {
            return this.contentType;
        }
    }
}

