/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.providers.multipart.HeaderFlushedAsyncOutputStream;
import org.jboss.resteasy.plugins.providers.multipart.HeaderFlushedOutputStream;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.DelegatingOutputStream;

public class AbstractMultipartWriter {
    protected static final byte[] DOUBLE_DASH_BYTES = "--".getBytes(StandardCharsets.US_ASCII);
    protected static final byte[] LINE_SEPARATOR_BYTES = "\r\n".getBytes(StandardCharsets.US_ASCII);
    protected static final byte[] COLON_SPACE_BYTES = ": ".getBytes(StandardCharsets.US_ASCII);
    @Context
    protected Providers workers;

    protected void write(MultipartOutput multipartOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            boundary = multipartOutput.getBoundary();
        }
        httpHeaders.putSingle((Object)"Content-Type", (Object)(mediaType.toString() + "; boundary=" + multipartOutput.getBoundary()));
        byte[] boundaryBytes = ("--" + boundary).getBytes(StandardCharsets.US_ASCII);
        this.writeParts(multipartOutput, entityStream, boundaryBytes);
        entityStream.write(boundaryBytes);
        entityStream.write(DOUBLE_DASH_BYTES);
    }

    protected void writeParts(MultipartOutput multipartOutput, OutputStream entityStream, byte[] boundaryBytes) throws IOException {
        for (OutputPart part : multipartOutput.getParts()) {
            MultivaluedMapImpl headers = new MultivaluedMapImpl();
            this.writePart(entityStream, boundaryBytes, part, (MultivaluedMap<String, Object>)headers);
        }
    }

    protected void writePart(OutputStream entityStream, byte[] boundaryBytes, OutputPart part, MultivaluedMap<String, Object> headers) throws IOException {
        entityStream.write(boundaryBytes);
        entityStream.write(LINE_SEPARATOR_BYTES);
        headers.putAll(part.getHeaders());
        headers.putSingle((Object)"Content-Type", (Object)part.getMediaType());
        Object entity = part.getEntity();
        Class<?> entityType = part.getType();
        Type entityGenericType = part.getGenericType();
        MessageBodyWriter writer = this.workers.getMessageBodyWriter(entityType, entityGenericType, null, part.getMediaType());
        LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
        DelegatingOutputStream partStream = new DelegatingOutputStream(entityStream){

            public void close() throws IOException {
            }
        };
        writer.writeTo(entity, entityType, entityGenericType, null, part.getMediaType(), headers, (OutputStream)new HeaderFlushedOutputStream(headers, (OutputStream)partStream));
        entityStream.write(LINE_SEPARATOR_BYTES);
    }

    protected CompletionStage<Void> asyncWrite(MultipartOutput multipartOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            boundary = multipartOutput.getBoundary();
        }
        httpHeaders.putSingle((Object)"Content-Type", (Object)(mediaType.toString() + "; boundary=" + multipartOutput.getBoundary()));
        byte[] boundaryBytes = ("--" + boundary).getBytes(StandardCharsets.US_ASCII);
        return this.asyncWriteParts(multipartOutput, entityStream, boundaryBytes).thenCompose(v -> entityStream.asyncWrite(boundaryBytes)).thenCompose(v -> entityStream.asyncWrite(DOUBLE_DASH_BYTES));
    }

    protected CompletionStage<Void> asyncWriteParts(MultipartOutput multipartOutput, AsyncOutputStream entityStream, byte[] boundaryBytes) {
        CompletionStage<Object> ret = CompletableFuture.completedFuture(null);
        for (OutputPart part : multipartOutput.getParts()) {
            MultivaluedMapImpl headers = new MultivaluedMapImpl();
            ret = ret.thenCompose(arg_0 -> this.lambda$asyncWriteParts$2(entityStream, boundaryBytes, part, (MultivaluedMap)headers, arg_0));
        }
        return ret;
    }

    protected CompletionStage<Void> asyncWritePart(AsyncOutputStream entityStream, byte[] boundaryBytes, OutputPart part, MultivaluedMap<String, Object> headers) {
        headers.putAll(part.getHeaders());
        headers.putSingle((Object)"Content-Type", (Object)part.getMediaType());
        Object entity = part.getEntity();
        Class<?> entityType = part.getType();
        Type entityGenericType = part.getGenericType();
        AsyncMessageBodyWriter writer = (AsyncMessageBodyWriter)this.workers.getMessageBodyWriter(entityType, entityGenericType, null, part.getMediaType());
        LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
        return entityStream.asyncWrite(boundaryBytes).thenCompose(v -> entityStream.asyncWrite(LINE_SEPARATOR_BYTES)).thenCompose(v -> writer.asyncWriteTo(entity, entityType, entityGenericType, null, part.getMediaType(), headers, (AsyncOutputStream)new HeaderFlushedAsyncOutputStream(headers, entityStream))).thenCompose(v -> entityStream.asyncWrite(LINE_SEPARATOR_BYTES));
    }

    private /* synthetic */ CompletionStage lambda$asyncWriteParts$2(AsyncOutputStream entityStream, byte[] boundaryBytes, OutputPart part, MultivaluedMap headers, Void v) {
        return this.asyncWritePart(entityStream, boundaryBytes, part, (MultivaluedMap<String, Object>)headers);
    }
}

