/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.plugins.server.netty.RequestHandler;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpRequestDecoder;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpResponseEncoder;

public class HttpServerPipelineFactory
implements ChannelPipelineFactory {
    private final ChannelHandler resteasyEncoder;
    private final ChannelHandler resteasyDecoder;
    private final ChannelHandler resteasyRequestHandler;
    private final ChannelHandler executionHandler;
    private final int maxRequestSize;

    public HttpServerPipelineFactory(RequestDispatcher dispatcher, String root, int executorThreadCount, int maxRequestSize) {
        this.resteasyDecoder = new RestEasyHttpRequestDecoder(dispatcher.getDispatcher(), root, this.getProtocol());
        this.resteasyEncoder = new RestEasyHttpResponseEncoder(dispatcher);
        this.resteasyRequestHandler = new RequestHandler(dispatcher);
        this.executionHandler = executorThreadCount > 0 ? new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(executorThreadCount, 0L, 0L)) : null;
        this.maxRequestSize = maxRequestSize;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("resteasyDecoder", this.resteasyDecoder);
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.maxRequestSize));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("resteasyEncoder", this.resteasyEncoder);
        if (this.executionHandler != null) {
            pipeline.addLast("executionHandler", this.executionHandler);
        }
        pipeline.addLast("handler", this.resteasyRequestHandler);
        return pipeline;
    }

    protected RestEasyHttpRequestDecoder.Protocol getProtocol() {
        return RestEasyHttpRequestDecoder.Protocol.HTTP;
    }
}

