/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.resteasy.plugins.server.netty.HttpServerPipelineFactory;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpRequestDecoder;

public class HttpsServerPipelineFactory
extends HttpServerPipelineFactory {
    private final SSLContext context;

    public HttpsServerPipelineFactory(RequestDispatcher dispatcher, String root, int executorThreadCount, int maxRequestSize, SSLContext context) {
        super(dispatcher, root, executorThreadCount, maxRequestSize);
        this.context = context;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline cp = super.getPipeline();
        SSLEngine engine = this.context.createSSLEngine();
        engine.setUseClientMode(false);
        cp.addFirst("sslHandler", (ChannelHandler)new SslHandler(engine));
        return cp;
    }

    @Override
    protected RestEasyHttpRequestDecoder.Protocol getProtocol() {
        return RestEasyHttpRequestDecoder.Protocol.HTTPS;
    }
}

