/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import java.io.InputStream;
import java.util.List;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.NettyUtil;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.ResteasyUriInfo;

@ChannelHandler.Sharable
public class RestEasyHttpRequestDecoder
extends MessageToMessageDecoder<HttpRequest> {
    private static final Logger logger = Logger.getLogger(RestEasyHttpRequestDecoder.class);
    private final SynchronousDispatcher dispatcher;
    private final String servletMappingPrefix;
    private final String proto;

    public RestEasyHttpRequestDecoder(SynchronousDispatcher dispatcher, String servletMappingPrefix, Protocol protocol) {
        this.dispatcher = dispatcher;
        this.servletMappingPrefix = servletMappingPrefix;
        this.proto = protocol == Protocol.HTTP ? "http" : "https";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, HttpRequest request, List<Object> out) throws Exception {
        block5: {
            boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
            NettyHttpResponse response = new NettyHttpResponse(ctx, keepAlive, this.dispatcher.getProviderFactory());
            try {
                ResteasyHttpHeaders headers = NettyUtil.extractHttpHeaders(request);
                ResteasyUriInfo uriInfo = NettyUtil.extractUriInfo(request, this.servletMappingPrefix, this.proto);
                NettyHttpRequest nettyRequest = new NettyHttpRequest(ctx, headers, uriInfo, request.getMethod().name(), this.dispatcher, response, HttpHeaders.is100ContinueExpected((HttpMessage)request));
                if (!(request instanceof HttpContent)) break block5;
                HttpContent content = (HttpContent)request;
                ByteBuf buf = content.content().retain();
                try {
                    ByteBufInputStream in = new ByteBufInputStream(buf);
                    nettyRequest.setInputStream((InputStream)in);
                    out.add((Object)nettyRequest);
                }
                finally {
                    ReferenceCountUtil.release((Object)buf);
                }
            }
            catch (Exception e) {
                response.sendError(400);
                logger.warn("Failed to parse request.", (Throwable)e);
            }
        }
    }

    public static enum Protocol {
        HTTPS,
        HTTP;

    }
}

