/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot.reactor;

import io.netty.handler.ssl.ClientAuth;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.springframework.core.env.Environment;

public class ReactorNettyServerConfig {
    private static final String REACTOR_NETTY_SERVER_PORT_PROPERTY = "server.port";
    private static final int REACTOR_NETTY_SERVER_PORT_HTTP_DEFAULT = 8080;
    private static final int REACTOR_NETTY_SERVER_PORT_HTTPS_DEFAULT = 8443;
    private final Integer port;
    private final Duration idleTimeout;
    private final SSLContext sslContext;
    private final ClientAuth clientAuth;
    private final SecurityDomain securityDomain;
    private final List<Runnable> cleanupTasks;

    public ReactorNettyServerConfig(int port, Duration idleTimeout, SSLContext sslContext, ClientAuth clientAuth, SecurityDomain securityDomain, List<Runnable> cleanupTasks) {
        this.port = port;
        this.idleTimeout = idleTimeout;
        this.sslContext = sslContext;
        this.clientAuth = clientAuth;
        this.securityDomain = securityDomain;
        this.cleanupTasks = cleanupTasks;
    }

    public Integer getPort() {
        return this.port;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public List<Runnable> getCleanupTasks() {
        return this.cleanupTasks;
    }

    public static ReactorNettyServerConfig defaultConfig(Environment env) {
        Objects.requireNonNull(env);
        return new Builder().withPort(Integer.parseInt(env.getProperty(REACTOR_NETTY_SERVER_PORT_PROPERTY, String.valueOf(8080)))).build();
    }

    public static class Builder {
        private Integer port;
        private Duration idleTimeout;
        private SSLContext sslContext;
        private ClientAuth clientAuth = ClientAuth.REQUIRE;
        private SecurityDomain securityDomain;
        private List<Runnable> cleanupTasks;

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Builder withSSLContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withClientAuth(ClientAuth clientAuth) {
            Objects.requireNonNull(clientAuth);
            this.clientAuth = clientAuth;
            return this;
        }

        public Builder withSecurityDomain(SecurityDomain securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder withCleanupTasks(Runnable ... tasks) {
            Objects.requireNonNull(tasks);
            this.cleanupTasks = Arrays.asList(tasks);
            return this;
        }

        public ReactorNettyServerConfig build() {
            return new ReactorNettyServerConfig(Optional.ofNullable(this.port).orElseGet(() -> Optional.ofNullable(this.sslContext).map(c -> 8443).orElseGet(() -> 8080)), this.idleTimeout, this.sslContext, this.clientAuth, this.securityDomain, this.cleanupTasks);
        }
    }
}

