/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot.reactor;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.plugins.server.reactor.netty.ReactorNettyJaxrsServer;
import org.jboss.resteasy.plugins.spring.SpringBeanProcessor;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.springboot.common.DeploymentCustomizer;
import org.jboss.resteasy.springboot.common.ResteasyBeanProcessorFactory;
import org.jboss.resteasy.springboot.reactor.ReactorNettyServerConfig;
import org.jboss.resteasy.springboot.reactor.ResteasyBeanProcessorReactorNetty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;

@AutoConfiguration
@EnableConfigurationProperties
public class ResteasyAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ResteasyAutoConfiguration.class);
    private static final String JAXRS_APP_ASYNC_JOB_ENABLE_PROPERTY = "resteasy.async.job.service.enabled";
    private static final String JAXRS_APP_ASYNC_JOB_ENABLE_PROPERTY_DEFAULT = "false";
    private static final String DEFAULT_BASE_APP_PATH = "/";

    @Bean
    public static ResteasyBeanProcessorReactorNetty resteasyBeansProcessor() {
        return new ResteasyBeanProcessorReactorNetty();
    }

    @Bean
    public static BeanFactoryPostProcessor resteasySpringBeanProcessor() {
        return ResteasyBeanProcessorFactory.resteasySpringBeanProcessor();
    }

    @Bean
    public ResteasyReactorNettyServerBean resteasyReactorNettyServerBean(BeanFactoryPostProcessor resteasySpringBeanProcessor, ResteasyBeanProcessorReactorNetty resteasyBeansProcessor, Environment environment, Optional<ReactorNettyServerConfig> maybeServerConfig) throws InterruptedException {
        ReactorNettyJaxrsServer server = new ReactorNettyJaxrsServer();
        server.setDeployment((ResteasyDeployment)new ResteasyDeploymentImpl());
        ReactorNettyServerConfig serverConfig = maybeServerConfig.orElseGet(() -> ReactorNettyServerConfig.defaultConfig(environment));
        this.configureServerAndDeployment(server, resteasyBeansProcessor.getApplications(), (SpringBeanProcessor)resteasySpringBeanProcessor, environment, serverConfig);
        server.getDeployment().start();
        return new ResteasyReactorNettyServerBean(server);
    }

    private void configureServerAndDeployment(ReactorNettyJaxrsServer server, Set<Class<? extends Application>> applications, SpringBeanProcessor resteasySpringBeanProcessor, Environment env, ReactorNettyServerConfig config) {
        ResteasyDeployment deployment = server.getDeployment();
        if (applications.isEmpty()) {
            logger.info("No JAX-RS Application classes with proper path have been found. A default app mapped to '{}', will be configured.", (Object)DEFAULT_BASE_APP_PATH);
            deployment.setApplicationClass(Application.class.getName());
        } else {
            Class<? extends Application> application = applications.iterator().next();
            String path = ((ApplicationPath)AnnotationUtils.findAnnotation(application, ApplicationPath.class)).value();
            if (applications.size() > 1) {
                logger.info("Multiple application classes found. Will only configure one. Application name: {}, Base path: {}", (Object)application.getName(), (Object)path);
            }
            logger.info("Configuring JAX-RS application class {}. Base path: {}", (Object)application.getName(), (Object)path);
            deployment.setApplicationClass(application.getName());
        }
        boolean enableAsyncJob = Boolean.valueOf(env.getProperty(JAXRS_APP_ASYNC_JOB_ENABLE_PROPERTY, JAXRS_APP_ASYNC_JOB_ENABLE_PROPERTY_DEFAULT));
        DeploymentCustomizer.customizeRestEasyDeployment((SpringBeanProcessor)resteasySpringBeanProcessor, (ResteasyDeployment)deployment, (boolean)enableAsyncJob);
        Optional.ofNullable(config.getSslContext()).map(c -> server.setSSLContext(c)).orElse(server).setPort(config.getPort().intValue()).setIdleTimeout(config.getIdleTimeout()).setClientAuth(config.getClientAuth()).setSecurityDomain(config.getSecurityDomain()).setCleanUpTasks(config.getCleanupTasks()).setDeployment(deployment);
    }

    public class ResteasyReactorNettyServerBean {
        private final ReactorNettyJaxrsServer server;
        private final CountDownLatch shutdownLatch = new CountDownLatch(1);

        public ResteasyReactorNettyServerBean(ReactorNettyJaxrsServer server) throws InterruptedException {
            this.server = server;
        }

        @PostConstruct
        private void startServer() throws InterruptedException {
            final CountDownLatch startupLatch = new CountDownLatch(1);
            Thread awaitThread = new Thread("server"){

                @Override
                public void run() {
                    ResteasyReactorNettyServerBean.this.server.start();
                    logger.info("Reactor Netty server started on port: {}", (Object)ResteasyReactorNettyServerBean.this.server.getPort());
                    startupLatch.countDown();
                    try {
                        ResteasyReactorNettyServerBean.this.shutdownLatch.await();
                    }
                    catch (InterruptedException ie) {
                        logger.error("Exception caught while waiting for the Reactor Netty server to stop", (Throwable)ie);
                        Thread.currentThread().interrupt();
                    }
                }
            };
            awaitThread.setContextClassLoader(MethodHandles.lookup().lookupClass().getClassLoader());
            awaitThread.setDaemon(false);
            awaitThread.start();
            startupLatch.await();
        }

        @PreDestroy
        private void stopServer() {
            logger.info("Stopping the JAX-RS+Reactor-Netty server.");
            this.server.stop();
            this.shutdownLatch.countDown();
        }

        public ReactorNettyJaxrsServer getServer() {
            return this.server;
        }
    }
}

