/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.reactor.netty;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.reactor.netty.ReactorNettyHttpRequest;
import org.jboss.resteasy.plugins.server.reactor.netty.ReactorNettyHttpResponse;
import org.jboss.resteasy.plugins.server.reactor.netty.SinkSubscriber;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.EmbeddedServerHelper;
import org.jboss.resteasy.util.PortProvider;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class ReactorNettyJaxrsServer
implements EmbeddedJaxrsServer<ReactorNettyJaxrsServer> {
    private static final Logger log = Logger.getLogger(ReactorNettyJaxrsServer.class);
    private final EmbeddedServerHelper serverHelper = new EmbeddedServerHelper();
    protected String hostname = null;
    protected int configuredPort = PortProvider.getPort();
    protected int runtimePort = -1;
    protected String root = "";
    protected ResteasyDeployment deployment;
    protected SecurityDomain domain;
    private Duration idleTimeout;
    private SSLContext sslContext;
    private ClientAuth clientAuth = ClientAuth.REQUIRE;
    private List<Runnable> cleanUpTasks;
    private UnaryOperator<HttpRequestDecoderSpec> mkDecoderSpec = spec -> spec;
    private DisposableServer server;

    public ReactorNettyJaxrsServer deploy() {
        return this;
    }

    public ReactorNettyJaxrsServer start() {
        log.info((Object)"Starting RestEasy Reactor-based server!");
        this.serverHelper.checkDeployment(this.deployment);
        String appPath = this.serverHelper.checkAppDeployment(this.deployment);
        if (appPath != null && (this.root == null || "".equals(this.root))) {
            this.setRootResourcePath(appPath);
        }
        Handler handler = new Handler();
        HttpServer svrBuilder = HttpServer.create().port(this.configuredPort).httpRequestDecoder(this.mkDecoderSpec).handle(handler::handle);
        if (this.idleTimeout != null) {
            svrBuilder = svrBuilder.idleTimeout(this.idleTimeout);
        }
        if (this.sslContext != null) {
            svrBuilder = svrBuilder.secure(sslContextSpec -> sslContextSpec.sslContext(this.toNettySSLContext(this.sslContext)));
        }
        if (this.hostname != null && !this.hostname.trim().isEmpty()) {
            svrBuilder = svrBuilder.host(this.hostname);
        }
        if (Boolean.parseBoolean(System.getProperty("resteasy.server.reactor-netty.warmup", "true"))) {
            log.info((Object)"Warming up the reactor-netty server");
            svrBuilder.warmup().block();
        }
        this.server = svrBuilder.bindNow();
        this.runtimePort = this.server.port();
        return this;
    }

    public void startAndBlock() {
        this.start();
        this.server.onDispose().block();
    }

    public void stop() {
        this.runtimePort = -1;
        this.server.disposeNow();
        if (this.deployment != null) {
            this.deployment.stop();
        }
    }

    public ResteasyDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new ResteasyDeploymentImpl();
        }
        return this.deployment;
    }

    public ReactorNettyJaxrsServer setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
        return this;
    }

    public ReactorNettyJaxrsServer setPort(int port) {
        this.configuredPort = port;
        return this;
    }

    public int getPort() {
        return this.runtimePort > 0 ? this.runtimePort : this.configuredPort;
    }

    public ReactorNettyJaxrsServer setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public ReactorNettyJaxrsServer setRootResourcePath(String rootResourcePath) {
        this.root = Objects.requireNonNull(rootResourcePath);
        if (this.root != null && this.root.equals("/")) {
            this.root = "";
        } else if (!this.root.startsWith("/")) {
            this.root = "/" + this.root;
        }
        return this;
    }

    public ReactorNettyJaxrsServer setSecurityDomain(SecurityDomain sc) {
        this.domain = sc;
        return this;
    }

    public ReactorNettyJaxrsServer setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public ReactorNettyJaxrsServer setSSLContext(SSLContext sslContext) {
        Objects.requireNonNull(sslContext);
        this.sslContext = sslContext;
        return this;
    }

    public ReactorNettyJaxrsServer setClientAuth(ClientAuth clientAuth) {
        Objects.requireNonNull(clientAuth);
        this.clientAuth = clientAuth;
        return this;
    }

    public ReactorNettyJaxrsServer setCleanUpTasks(List<Runnable> cleanUpTasks) {
        this.cleanUpTasks = cleanUpTasks;
        return this;
    }

    public void setDecoderSpecFn(UnaryOperator<HttpRequestDecoderSpec> decoderSpecFn) {
        this.mkDecoderSpec = decoderSpecFn;
    }

    private SslContext toNettySSLContext(SSLContext sslContext) {
        Objects.requireNonNull(sslContext);
        return new JdkSslContext(sslContext, false, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, this.clientAuth, null, false);
    }

    private ResteasyUriInfo extractUriInfo(HttpServerRequest req, String contextPath) {
        String uri = req.uri();
        String uriString = uri.startsWith(req.scheme() + "://") ? uri : new StringBuilder(100).append(req.scheme()).append("://").append(req.hostAddress().getHostString()).append(":").append(req.hostAddress().getPort()).append(req.uri()).toString();
        return new ResteasyUriInfo(uriString, contextPath);
    }

    class Handler {
        private final Mono<InputStream> empty = Mono.just((Object)new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        });

        Handler() {
        }

        Publisher<Void> handle(HttpServerRequest req, HttpServerResponse resp) {
            ResteasyUriInfo info = ReactorNettyJaxrsServer.this.extractUriInfo(req, ReactorNettyJaxrsServer.this.root);
            Sinks.Empty completionSink = Sinks.empty();
            AtomicBoolean isTimeoutSet = new AtomicBoolean(false);
            ReactorNettyHttpResponse resteasyResp = new ReactorNettyHttpResponse(req.method(), resp, (Sinks.Empty<Void>)completionSink);
            return req.receive().aggregate().asInputStream().doOnDiscard(InputStream.class, is -> {
                try {
                    is.close();
                }
                catch (IOException ie) {
                    log.error((Object)"Problem closing discarded input stream", (Throwable)ie);
                }
            }).switchIfEmpty(this.empty).flatMap(body -> {
                SynchronousDispatcher dispatcher = (SynchronousDispatcher)ReactorNettyJaxrsServer.this.deployment.getDispatcher();
                ReactorNettyHttpRequest resteasyReq = new ReactorNettyHttpRequest(info, req, (InputStream)body, resteasyResp, dispatcher);
                ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
                if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                    ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)ReactorNettyJaxrsServer.this.deployment.getProviderFactory());
                }
                try {
                    ReactorNettyJaxrsServer.this.deployment.getDispatcher().invoke((HttpRequest)resteasyReq, (HttpResponse)resteasyResp);
                }
                finally {
                    if (ReactorNettyJaxrsServer.this.cleanUpTasks != null) {
                        ReactorNettyJaxrsServer.this.cleanUpTasks.forEach(Runnable::run);
                    }
                }
                if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                    ThreadLocalResteasyProviderFactory.pop();
                }
                if (!resteasyReq.getAsyncContext().isSuspended()) {
                    try {
                        resteasyResp.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                Mono actualMono = Optional.ofNullable(resteasyReq.timeout()).map(timeout -> {
                    isTimeoutSet.set(true);
                    return completionSink.asMono().timeout(resteasyReq.timeout());
                }).orElse(completionSink.asMono());
                return actualMono.doFinally(s -> {
                    try {
                        body.close();
                    }
                    catch (IOException ioe) {
                        log.error((Object)"Failure to close the request's input stream.", (Throwable)ioe);
                    }
                });
            }).onErrorResume(t -> {
                if (!resteasyResp.isCommitted()) {
                    Mono sendMono;
                    if (isTimeoutSet.get() && Exceptions.unwrap((Throwable)t) instanceof TimeoutException) {
                        sendMono = resp.status(503).send();
                    } else {
                        log.error((Object)"Unhandled server error.", t);
                        sendMono = resp.status(500).send();
                    }
                    SinkSubscriber.subscribe((Sinks.Empty<Void>)completionSink, (Mono<Void>)sendMono);
                } else {
                    log.error((Object)"Unhandled server error, JAXRS response committed.", t);
                }
                return completionSink.asMono();
            });
        }
    }
}

