/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.providers.validation.GeneralValidator;
import org.jboss.resteasy.plugins.validation.GeneralValidatorImpl;

@Provider
public class ValidatorContextResolver
implements ContextResolver<GeneralValidator> {
    private static final Logger logger = Logger.getLogger(ValidatorContextResolver.class);
    private static volatile GeneralValidator generalValidator;
    static final Object RD_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GeneralValidator getGeneralValidator() {
        GeneralValidator tmpValidator = generalValidator;
        if (tmpValidator == null) {
            Object object = RD_LOCK;
            synchronized (object) {
                tmpValidator = generalValidator;
                if (generalValidator == null) {
                    HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
                    Validator validator = config.buildValidatorFactory().getValidator();
                    generalValidator = tmpValidator = new GeneralValidatorImpl(validator);
                }
            }
        }
        return generalValidator;
    }

    public GeneralValidator getContext(Class<?> type) {
        try {
            return ValidatorContextResolver.getGeneralValidator();
        }
        catch (Exception e) {
            logger.warn("Unable to load Validation support", (Throwable)e);
            return null;
        }
    }

    static {
        RD_LOCK = new Object();
    }
}

