/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.wadl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.wadl.ResteasyWadlMethodParamMetaData;
import org.jboss.resteasy.wadl.ResteasyWadlServiceRegistry;
import org.jboss.resteasy.wadl.i18n.LogMessages;
import org.jboss.resteasy.wadl.i18n.Messages;

public class ResteasyWadlMethodMetaData {
    private ResourceMethodInvoker resourceInvoker;
    private Method method;
    private Class<?> klass;
    private List<String> produces;
    private List<String> consumesMIMETypes;
    private String uri;
    private String functionName;
    private List<ResteasyWadlMethodParamMetaData> parameters = new ArrayList<ResteasyWadlMethodParamMetaData>();
    private Collection<String> httpMethods;
    private ResteasyWadlServiceRegistry registry;
    private String functionPrefix;
    private boolean wantsForm;
    private String methodUri;
    private String klassUri;

    public String getMethodUri() {
        return this.methodUri;
    }

    public void setMethodUri(String methodUri) {
        this.methodUri = methodUri;
    }

    public String getKlassUri() {
        return this.klassUri;
    }

    public void setKlassUri(String klassUri) {
        this.klassUri = klassUri;
    }

    public ResteasyWadlMethodMetaData(ResteasyWadlServiceRegistry serviceRegistry, ResourceMethodInvoker resourceInvoker) {
        this.registry = serviceRegistry;
        this.resourceInvoker = resourceInvoker;
        this.method = resourceInvoker.getMethod();
        this.klass = resourceInvoker.getResourceClass();
        Path methodPath = this.method.getAnnotation(Path.class);
        this.methodUri = methodPath == null ? null : methodPath.value();
        Path klassPath = this.klass.getAnnotation(Path.class);
        this.klassUri = klassPath == null ? null : klassPath.value();
        Produces producesAnnotation = this.method.getAnnotation(Produces.class);
        if (producesAnnotation == null) {
            producesAnnotation = this.klass.getAnnotation(Produces.class);
        }
        this.produces = this.getProduces(producesAnnotation);
        Consumes consumes = this.method.getAnnotation(Consumes.class);
        if (consumes == null) {
            consumes = this.klass.getAnnotation(Consumes.class);
        }
        this.uri = ResteasyWadlMethodMetaData.appendURIFragments(this.registry, klassPath, methodPath);
        this.functionPrefix = serviceRegistry.isRoot() ? this.klass.getSimpleName() : serviceRegistry.getFunctionPrefix();
        this.functionName = this.functionPrefix + "." + this.method.getName();
        this.httpMethods = resourceInvoker.getHttpMethods();
        ArrayList<Method> methodsUntilRoot = new ArrayList<Method>();
        methodsUntilRoot.add(this.method);
        serviceRegistry.collectResourceMethodsUntilRoot(methodsUntilRoot);
        for (Method method : methodsUntilRoot) {
            Annotation[][] allAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.processMetaData(parameterTypes[i], allAnnotations[i], true);
            }
        }
        this.consumesMIMETypes = this.getConsumes(consumes);
        if (this.wantsForm && !"application/x-www-form-urlencoded".equals(this.consumesMIMETypes)) {
            LogMessages.LOGGER.warn(Messages.MESSAGES.overridingConsumesAnnotation());
            this.consumesMIMETypes = Arrays.asList("application/x-www-form-urlencoded");
        }
    }

    protected void processMetaData(Class<?> type, Annotation[] annotations, boolean useBody) {
        QueryParam queryParam = (QueryParam)FindAnnotation.findAnnotation((Annotation[])annotations, QueryParam.class);
        if (queryParam != null) {
            this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.QUERY_PARAMETER, queryParam.value());
        } else {
            HeaderParam headerParam = (HeaderParam)FindAnnotation.findAnnotation((Annotation[])annotations, HeaderParam.class);
            if (headerParam != null) {
                this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.HEADER_PARAMETER, headerParam.value());
            } else {
                CookieParam cookieParam = (CookieParam)FindAnnotation.findAnnotation((Annotation[])annotations, CookieParam.class);
                if (cookieParam != null) {
                    this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.COOKIE_PARAMETER, cookieParam.value());
                } else {
                    PathParam pathParam = (PathParam)FindAnnotation.findAnnotation((Annotation[])annotations, PathParam.class);
                    if (pathParam != null) {
                        this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.PATH_PARAMETER, pathParam.value());
                    } else {
                        MatrixParam matrixParam = (MatrixParam)FindAnnotation.findAnnotation((Annotation[])annotations, MatrixParam.class);
                        if (matrixParam != null) {
                            this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.MATRIX_PARAMETER, matrixParam.value());
                        } else {
                            FormParam formParam = (FormParam)FindAnnotation.findAnnotation((Annotation[])annotations, FormParam.class);
                            if (formParam != null) {
                                this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.FORM_PARAMETER, formParam.value());
                                this.wantsForm = true;
                            } else {
                                Form form = (Form)FindAnnotation.findAnnotation((Annotation[])annotations, Form.class);
                                if (form != null) {
                                    if (type == List.class) {
                                        this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.FORM, form.prefix());
                                        this.wantsForm = true;
                                    } else if (type == Map.class) {
                                        this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.FORM, form.prefix());
                                        this.wantsForm = true;
                                    } else {
                                        this.walkForm(type);
                                    }
                                } else if (FindAnnotation.findAnnotation((Annotation[])annotations, Context.class) == null && useBody) {
                                    this.addParameter(type, annotations, ResteasyWadlMethodParamMetaData.MethodParamType.ENTITY_PARAMETER, null);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void walkForm(Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            this.processMetaData(field.getType(), field.getAnnotations(), false);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (((Method)accessibleObject).getParameterTypes().length != 1 || !((Method)accessibleObject).getReturnType().equals(Void.class)) continue;
            this.processMetaData(((Method)accessibleObject).getParameterTypes()[0], accessibleObject.getAnnotations(), false);
        }
        if (type.getSuperclass() != null) {
            this.walkForm(type.getSuperclass());
        }
    }

    private void addParameter(Class<?> type, Annotation[] annotations, ResteasyWadlMethodParamMetaData.MethodParamType paramType, String value) {
        this.parameters.add(new ResteasyWadlMethodParamMetaData(type, annotations, paramType, value));
    }

    private List<String> getProduces(Produces produces) {
        if (produces == null) {
            return new ArrayList<String>();
        }
        String[] values = produces.value();
        return Arrays.asList(values);
    }

    private List<String> getConsumes(Consumes consumes) {
        if (consumes == null) {
            return Arrays.asList("text/plain");
        }
        if (consumes.value().length > 0) {
            return Arrays.asList(consumes.value());
        }
        return Arrays.asList("text/plain");
    }

    public static String appendURIFragments(String ... fragments) {
        StringBuilder str = new StringBuilder();
        for (String fragment : fragments) {
            if (fragment == null || fragment.length() == 0 || fragment.equals("/")) continue;
            if (fragment.startsWith("/")) {
                fragment = fragment.substring(1);
            }
            if (fragment.endsWith("/")) {
                fragment = fragment.substring(0, fragment.length() - 1);
            }
            str.append('/').append(fragment);
        }
        if (str.length() == 0) {
            return "/";
        }
        return str.toString();
    }

    public ResourceMethodInvoker getResourceInvoker() {
        return this.resourceInvoker;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public List<String> getConsumesMIMETypes() {
        return this.consumesMIMETypes;
    }

    public String getUri() {
        return this.uri;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<ResteasyWadlMethodParamMetaData> getParameters() {
        return this.parameters;
    }

    public Collection<String> getHttpMethods() {
        return this.httpMethods;
    }

    public static String appendURIFragments(ResteasyWadlServiceRegistry registry, Path classPath, Path methodPath) {
        return ResteasyWadlMethodMetaData.appendURIFragments(registry == null ? null : registry.getUri(), classPath != null ? classPath.value() : null, methodPath != null ? methodPath.value() : null);
    }

    public String getFunctionPrefix() {
        return this.functionPrefix;
    }
}

