/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.wadl;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.wadl.ResteasyWadlGenerator;
import org.jboss.resteasy.wadl.ResteasyWadlServiceRegistry;
import org.jboss.resteasy.wadl.ResteasyWadlWriter;
import org.jboss.resteasy.wadl.i18n.LogMessages;
import org.jboss.resteasy.wadl.i18n.Messages;

@Path(value="/")
public class ResteasyWadlDefaultResource {
    private Map<String, ResteasyWadlServiceRegistry> services = new HashMap<String, ResteasyWadlServiceRegistry>();
    ResteasyWadlWriter wadlWriter = new ResteasyWadlWriter();

    private void loadServices(ResteasyDeployment deployment) {
        this.services.put("/", ResteasyWadlGenerator.generateServiceRegistry(deployment));
    }

    public Map<String, ResteasyWadlServiceRegistry> getServices() {
        return this.services;
    }

    public ResteasyWadlWriter getWadlWriter() {
        return this.wadlWriter;
    }

    @GET
    @Path(value="/application.xml")
    @Produces(value={"application/xml"})
    public String output(@Context ResteasyDeployment deployment) {
        this.loadServices(deployment);
        try {
            return this.wadlWriter.getStringWriter("", this.services).toString();
        }
        catch (JAXBException e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.cantProcessWadl(), e);
            return null;
        }
    }

    @GET
    @Path(value="/wadl-extended/{path}")
    @Produces(value={"application/xml"})
    public Response grammars(@PathParam(value="path") String path, @Context ResteasyDeployment deployment) {
        this.loadServices(deployment);
        return Response.ok().type(MediaType.APPLICATION_XML_TYPE).entity((Object)this.wadlWriter.getWadlGrammar().getSchemaOfUrl(path)).build();
    }
}

