/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.wadl;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.jboss.resteasy.wadl.ResteasyWadlMethodMetaData;
import org.jboss.resteasy.wadl.ResteasyWadlMethodParamMetaData;
import org.jboss.resteasy.wadl.ResteasyWadlResourceMetaData;
import org.jboss.resteasy.wadl.ResteasyWadlServiceRegistry;
import org.jboss.resteasy.wadl.i18n.LogMessages;
import org.jboss.resteasy.wadl.i18n.Messages;
import org.jboss.resteasy.wadl.jaxb.Application;
import org.jboss.resteasy.wadl.jaxb.Doc;
import org.jboss.resteasy.wadl.jaxb.Grammars;
import org.jboss.resteasy.wadl.jaxb.Include;
import org.jboss.resteasy.wadl.jaxb.Method;
import org.jboss.resteasy.wadl.jaxb.ObjectFactory;
import org.jboss.resteasy.wadl.jaxb.Param;
import org.jboss.resteasy.wadl.jaxb.ParamStyle;
import org.jboss.resteasy.wadl.jaxb.Representation;
import org.jboss.resteasy.wadl.jaxb.Request;
import org.jboss.resteasy.wadl.jaxb.Resource;
import org.jboss.resteasy.wadl.jaxb.Resources;
import org.jboss.resteasy.wadl.jaxb.Response;

public class ResteasyWadlWriter {
    private ResteasyWadlGrammar wadlGrammar = null;
    private Application wadlApp = null;

    public void setWadlGrammar(ResteasyWadlGrammar wadlGrammar) {
        this.wadlGrammar = wadlGrammar;
    }

    public ResteasyWadlGrammar getWadlGrammar() {
        return this.wadlGrammar;
    }

    @Deprecated
    public byte[] getBytes(String base, Map<String, ResteasyWadlServiceRegistry> serviceRegistries) throws JAXBException {
        StringWriter stringWriter = this.getStringWriter(base, serviceRegistries);
        return stringWriter.toString().getBytes();
    }

    public StringWriter getStringWriter(String base, Map<String, ResteasyWadlServiceRegistry> serviceRegistries) throws JAXBException {
        Application app = this.createApplication(base, serviceRegistries);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Application.class});
        Marshaller marshaller = context.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)app, (Writer)writer);
        return stringWriter;
    }

    private Application createApplication(String base, Map<String, ResteasyWadlServiceRegistry> serviceRegistries) {
        ObjectFactory factory = new ObjectFactory();
        Application app = factory.createApplication();
        for (Map.Entry<String, ResteasyWadlServiceRegistry> entry : serviceRegistries.entrySet()) {
            String uri = base;
            if (entry.getKey() != null) {
                uri = uri + entry.getKey();
            }
            Resources resources = new Resources();
            resources.setBase(uri);
            app.getResources().add(resources);
            this.processWadl(entry.getValue(), resources);
            if (this.wadlGrammar != null && this.wadlGrammar.hasGrammars()) {
                app.setGrammars(this.wadlGrammar.getGrammars());
            }
            this.wadlApp = app;
        }
        return this.wadlApp;
    }

    private void processWadl(ResteasyWadlServiceRegistry serviceRegistry, Resources root) {
        for (Map.Entry<String, ResteasyWadlResourceMetaData> resourceMetaDataEntry : serviceRegistry.getResources().entrySet()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.path(resourceMetaDataEntry.getKey()));
            Resource resourceClass = new Resource();
            resourceClass.setPath(resourceMetaDataEntry.getKey());
            root.getResource().add(resourceClass);
            for (ResteasyWadlMethodMetaData methodMetaData : resourceMetaDataEntry.getValue().getMethodsMetaData()) {
                Method method = new Method();
                if (this.wadlGrammar != null) {
                    this.wadlGrammar.collectClassesForSchemaGeneration(methodMetaData);
                }
                if (methodMetaData.getMethodUri() != null) {
                    Resource methodResource = new Resource();
                    methodResource.setPath(methodMetaData.getMethodUri());
                    methodResource.getMethodOrResource().add(method);
                    resourceClass.getMethodOrResource().add(methodResource);
                    this.processMethodParams(methodResource, methodMetaData, method);
                } else {
                    resourceClass.getMethodOrResource().add(method);
                    this.processMethodParams(resourceClass, methodMetaData, method);
                }
                for (String name : methodMetaData.getHttpMethods()) {
                    method.setName(name);
                }
                method.setId(methodMetaData.getMethod().getName());
                Response response = this.createResponse(serviceRegistry, methodMetaData);
                method.getResponse().add(response);
            }
        }
        for (ResteasyWadlServiceRegistry subService : serviceRegistry.getLocators()) {
            this.processWadl(subService, root);
        }
    }

    private void processMethodParams(Resource currentResourceClass, ResteasyWadlMethodMetaData methodMetaData, Method method) {
        Request request = new Request();
        for (ResteasyWadlMethodParamMetaData paramMetaData : methodMetaData.getParameters()) {
            this.createParam(currentResourceClass, method, paramMetaData, request);
        }
    }

    private Response createResponse(ResteasyWadlServiceRegistry serviceRegistry, ResteasyWadlMethodMetaData methodMetaData) {
        Response response = new Response();
        Class<?> _type = methodMetaData.getMethod().getReturnType();
        Type _generic = methodMetaData.getMethod().getGenericReturnType();
        if (methodMetaData.getProduces() != null) {
            for (String produces : methodMetaData.getProduces()) {
                for (String _produces : produces.split(",")) {
                    MediaType mediaType = MediaType.valueOf((String)_produces);
                    if (mediaType == null && (mediaType = serviceRegistry.getProviderFactory().getConcreteMediaTypeFromMessageBodyWriters(_type, _generic, methodMetaData.getMethod().getAnnotations(), MediaType.WILDCARD_TYPE)) == null) {
                        mediaType = MediaType.WILDCARD_TYPE;
                    }
                    Representation representation = this.createRepresentation(mediaType);
                    response.getRepresentation().add(representation);
                }
            }
        }
        return response;
    }

    private Param createParam(Resource currentResourceClass, Method method, ResteasyWadlMethodParamMetaData paramMetaData, Request request) {
        Param param = new Param();
        this.setType(param, paramMetaData);
        if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.PATH_PARAMETER)) {
            param.setStyle(ParamStyle.TEMPLATE);
            param.setName(paramMetaData.getParamName());
            currentResourceClass.getParam().add(param);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.COOKIE_PARAMETER)) {
            param.setStyle(ParamStyle.HEADER);
            request.getParam().add(param);
            param.setName("Cookie");
            param.setPath(paramMetaData.getParamName());
            method.setRequest(request);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.HEADER_PARAMETER)) {
            param.setStyle(ParamStyle.HEADER);
            request.getParam().add(param);
            param.setName(paramMetaData.getParamName());
            method.setRequest(request);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.MATRIX_PARAMETER)) {
            param.setStyle(ParamStyle.MATRIX);
            param.setName(paramMetaData.getParamName());
            currentResourceClass.getParam().add(param);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.QUERY_PARAMETER)) {
            param.setStyle(ParamStyle.QUERY);
            request.getParam().add(param);
            param.setName(paramMetaData.getParamName());
            method.setRequest(request);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.FORM_PARAMETER)) {
            param.setStyle(ParamStyle.QUERY);
            Representation formRepresentation = this.createFormRepresentation(request);
            param.setName(paramMetaData.getParamName());
            formRepresentation.getParam().add(param);
            method.setRequest(request);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.FORM)) {
            param.setStyle(ParamStyle.QUERY);
            Representation formRepresentation = this.createFormRepresentation(request);
            param.setName(paramMetaData.getParamName());
            formRepresentation.getParam().add(param);
            method.setRequest(request);
        }
        return param;
    }

    private Representation createFormRepresentation(Request request) {
        Representation formRepresentation = this.getRepresentationByMediaType(request.getRepresentation(), MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        if (formRepresentation == null) {
            formRepresentation = this.createRepresentation(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
            request.getRepresentation().add(formRepresentation);
        }
        return formRepresentation;
    }

    private Representation createRepresentation(MediaType mediaType) {
        Representation representation = new Representation();
        representation.setMediaType(mediaType.toString());
        return representation;
    }

    private Representation getRepresentationByMediaType(List<Representation> representations, MediaType mediaType) {
        for (Representation representation : representations) {
            if (!mediaType.toString().equals(representation.getMediaType())) continue;
            return representation;
        }
        return null;
    }

    private void setType(Param param, ResteasyWadlMethodParamMetaData paramMetaData) {
        if (paramMetaData.getType().equals(Integer.TYPE) || paramMetaData.getType().equals(Integer.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        } else if (paramMetaData.getType().equals(Boolean.TYPE) || paramMetaData.getType().equals(Boolean.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        } else if (paramMetaData.getType().equals(Long.TYPE) || paramMetaData.getType().equals(Long.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        } else if (paramMetaData.getType().equals(Short.TYPE) || paramMetaData.getType().equals(Short.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        } else if (paramMetaData.getType().equals(Byte.TYPE) || paramMetaData.getType().equals(Byte.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        } else if (paramMetaData.getType().equals(Float.TYPE) || paramMetaData.getType().equals(Float.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        } else if (paramMetaData.getType().equals(Double.TYPE) || paramMetaData.getType().equals(Double.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        } else if (paramMetaData.getType().equals(Map.class) || paramMetaData.getType().equals(List.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "complex", "xs"));
        } else {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        }
    }

    public static class ResteasyWadlGrammar {
        private Grammars grammars = null;
        private Map<String, byte[]> externalSchemas = new ConcurrentHashMap<String, byte[]>();
        private Map<String, byte[]> generatedSchemas = new ConcurrentHashMap<String, byte[]>();
        private Set<Class> schemaClasses = Collections.synchronizedSet(new HashSet());
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private boolean generateSchema = false;

        public boolean hasGrammars() {
            return this.grammars != null;
        }

        protected Grammars getGrammars() {
            return this.grammars;
        }

        public void includeGrammars(String grammarFileName) {
            this.externalSchemas.clear();
            try (InputStream is = this.loader.getResourceAsStream(grammarFileName);){
                if (is != null) {
                    Grammars grammars = ResteasyWadlGrammar.unmarshall(is);
                    List<Include> includes = grammars.getInclude();
                    for (Include include : includes) {
                        this.addExternalSchema(include.getHref());
                    }
                    this.addGrammars(grammars);
                } else {
                    LogMessages.LOGGER.error(Messages.MESSAGES.cantProcessWadl());
                }
            }
            catch (Exception e) {
                LogMessages.LOGGER.error(Messages.MESSAGES.cantProcessWadl());
            }
        }

        public void enableSchemaGeneration() {
            this.generateSchema = true;
        }

        public boolean schemaGenerationEnabled() {
            return this.generateSchema;
        }

        protected void addGrammars(Grammars grammars) {
            if (this.grammars == null) {
                this.grammars = grammars;
            } else {
                if (!grammars.getAny().isEmpty()) {
                    this.grammars.getAny().addAll(grammars.getAny());
                }
                if (!grammars.getDoc().isEmpty()) {
                    this.grammars.getDoc().addAll(grammars.getDoc());
                }
                if (!grammars.getInclude().isEmpty()) {
                    this.grammars.getInclude().addAll(grammars.getInclude());
                }
            }
        }

        private void collectClassesForSchemaGeneration(ResteasyWadlMethodMetaData methodMetaData) {
            if (!this.schemaGenerationEnabled()) {
                return;
            }
            this.schemaClasses.clear();
            this.generatedSchemas.clear();
            this._addClass(methodMetaData.getMethod().getReturnType());
            for (ResteasyWadlMethodParamMetaData paramMetaData : methodMetaData.getParameters()) {
                this._addClass(paramMetaData.getType());
            }
            this.processClassesForSchema();
        }

        private void _addClass(Class clazz) {
            if (clazz.getAnnotation(XmlRootElement.class) != null) {
                this.schemaClasses.add(clazz);
            }
        }

        private void processClassesForSchema() {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])this.schemaClasses.toArray(new Class[this.schemaClasses.size()]));
                final ArrayList results = new ArrayList();
                context.generateSchema(new SchemaOutputResolver(){
                    int counter = 0;

                    public Result createOutput(String namespaceUri, String suggestedFileName) {
                        StreamResult result = new StreamResult(new CharArrayWriter());
                        String systemId = "xsd" + this.counter++ + ".xsd";
                        result.setSystemId(systemId);
                        results.add(result);
                        return result;
                    }
                });
                if (this.grammars != null) {
                    Iterator<Include> iter = this.grammars.getInclude().iterator();
                    while (iter.hasNext()) {
                        for (Doc doc : iter.next().getDoc()) {
                            if ("Generated".equals(doc.getTitle())) {
                                // empty if block
                            }
                            iter.remove();
                        }
                    }
                }
                this.addGrammars(new Grammars());
                for (StreamResult result : results) {
                    CharArrayWriter writer = (CharArrayWriter)result.getWriter();
                    byte[] contents = writer.toString().getBytes("UTF8");
                    this.generatedSchemas.put(result.getSystemId(), contents);
                    Include inc = new Include();
                    inc.setHref(result.getSystemId());
                    Doc doc = new Doc();
                    doc.setTitle("Generated");
                    doc.setLang("en");
                    inc.getDoc().add(doc);
                    this.grammars.getInclude().add(inc);
                }
            }
            catch (JAXBException e) {
                LogMessages.LOGGER.error(Messages.MESSAGES.cantProcessWadl());
            }
            catch (IOException e) {
                LogMessages.LOGGER.error(Messages.MESSAGES.cantProcessWadl());
            }
        }

        private void addExternalSchema(String href) {
            try (InputStream is = this.loader.getResourceAsStream(href);){
                if (is != null) {
                    this.externalSchemas.put(href, ResteasyWadlGrammar.toBytes(is));
                } else {
                    LogMessages.LOGGER.error(Messages.MESSAGES.cantProcessWadl());
                }
            }
            catch (Exception e) {
                LogMessages.LOGGER.error(Messages.MESSAGES.cantProcessWadl());
            }
        }

        private static byte[] toBytes(InputStream is) throws Exception {
            StringBuilder textBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8.name()));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    textBuilder.append((char)c);
                }
            }
            return textBuilder.toString().getBytes(StandardCharsets.UTF_8);
        }

        private static Grammars unmarshall(InputStream is) throws JAXBException {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Grammars.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            Grammars out = (Grammars)unmarshaller.unmarshal(is);
            return out;
        }

        public byte[] getSchemaOfUrl(String path) {
            byte[] result = this.externalSchemas.get(path);
            if (result == null) {
                result = this.generatedSchemas.get(path);
            }
            return result;
        }
    }
}

