/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token.validator;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.realm.token._private.ElytronMessages;

class JwkManager {
    private final Map<URL, CacheEntry> keys = new LinkedHashMap<URL, CacheEntry>();
    private final SSLContext sslContext;
    private final HostnameVerifier hostnameVerifier;
    private final long updateTimeout;
    private final int minTimeBetweenRequests;
    private final int connectionTimeout;
    private final int readTimeout;

    JwkManager(SSLContext sslContext, HostnameVerifier hostnameVerifier, long updateTimeout, int connectionTimeout, int readTimeout, int minTimeBetweenRequests) {
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
        this.updateTimeout = updateTimeout;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.minTimeBetweenRequests = minTimeBetweenRequests;
    }

    public PublicKey getPublicKey(String kid, URL url) {
        Map<String, RSAPublicKey> urlKeys = this.checkRemote(kid, url);
        if (urlKeys == null) {
            return null;
        }
        PublicKey pk = urlKeys.get(kid);
        if (pk == null) {
            ElytronMessages.log.warn("Unknown kid: " + kid);
            return null;
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RSAPublicKey> checkRemote(String kid, URL url) {
        Map<String, RSAPublicKey> urlKeys;
        long lastUpdate;
        CacheEntry cacheEntry;
        Assert.checkNotNullParam("kid", kid);
        Assert.checkNotNullParam("url", url);
        Map<URL, CacheEntry> map = this.keys;
        synchronized (map) {
            cacheEntry = this.keys.get(url);
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry();
                this.keys.put(url, cacheEntry);
            }
            lastUpdate = cacheEntry.getTimestamp();
            urlKeys = cacheEntry.getKeys();
        }
        long currentTime = System.currentTimeMillis();
        if (urlKeys.containsKey(kid) && lastUpdate + this.updateTimeout > currentTime) {
            return urlKeys;
        }
        if (lastUpdate + (long)this.minTimeBetweenRequests > currentTime) {
            ElytronMessages.log.avoidingFetchJwks(url, currentTime);
            return urlKeys;
        }
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            if (!(cacheEntry.getKeys().containsKey(kid) && cacheEntry.getTimestamp() + this.updateTimeout > currentTime || cacheEntry.getTimestamp() + (long)this.minTimeBetweenRequests > currentTime)) {
                Map<String, RSAPublicKey> newJwks = JwkManager.getJwksFromUrl(url, this.sslContext, this.hostnameVerifier, this.connectionTimeout, this.readTimeout);
                if (newJwks == null) {
                    ElytronMessages.log.unableToFetchJwks(url.toString());
                    return null;
                }
                cacheEntry.setKeys(newJwks);
                cacheEntry.setTimestamp(currentTime);
            }
            return cacheEntry.getKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, RSAPublicKey> getJwksFromUrl(URL url, SSLContext sslContext, HostnameVerifier hostnameVerifier, int connectionTimeout, int readTimeout) {
        JsonObject response = null;
        try (JsonReader jsonReader = null;){
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection conn = (HttpsURLConnection)connection;
                conn.setRequestMethod("GET");
                conn.setSSLSocketFactory(sslContext.getSocketFactory());
                conn.setHostnameVerifier(hostnameVerifier);
                conn.setConnectTimeout(connectionTimeout);
                conn.setReadTimeout(readTimeout);
                conn.connect();
                InputStream inputStream = conn.getInputStream();
                jsonReader = Json.createReader(inputStream);
                response = jsonReader.readObject();
            }
        }
        if (response == null) {
            ElytronMessages.log.warn("No response when fetching jwk set from " + url.toString());
            return null;
        }
        JsonArray jwks = response.getJsonArray("keys");
        if (jwks == null) {
            ElytronMessages.log.warn("Unable to parse jwks");
            return null;
        }
        LinkedHashMap<String, RSAPublicKey> res = new LinkedHashMap<String, RSAPublicKey>();
        for (int i = 0; i < jwks.size(); ++i) {
            JsonObject jwk = jwks.getJsonObject(i);
            String kid = jwk.getString("kid", null);
            String kty = jwk.getString("kty", null);
            String e1 = jwk.getString("e", null);
            String n1 = jwk.getString("n", null);
            if (kid == null) {
                ElytronMessages.log.tokenRealmJwkMissingClaim("kid");
                continue;
            }
            if (!"RSA".equals(kty)) {
                ElytronMessages.log.tokenRealmJwkMissingClaim("kty");
                continue;
            }
            if (e1 == null) {
                ElytronMessages.log.tokenRealmJwkMissingClaim("e");
                continue;
            }
            if (n1 == null) {
                ElytronMessages.log.tokenRealmJwkMissingClaim("n");
                continue;
            }
            BigInteger e = new BigInteger(1, Base64.getUrlDecoder().decode(e1));
            BigInteger n = new BigInteger(1, Base64.getUrlDecoder().decode(n1));
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(n, e);
            try {
                RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(keySpec);
                res.put(kid, publicKey);
                continue;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
                ElytronMessages.log.info("Fetched jwk could not be parsed, ignoring...", ex);
            }
        }
        return res;
    }

    private static class CacheEntry {
        private Map<String, RSAPublicKey> keys = Collections.emptyMap();
        private long timestamp = 0L;

        public Map<String, RSAPublicKey> getKeys() {
            return this.keys;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setKeys(Map<String, RSAPublicKey> keys) {
            this.keys = keys;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

