/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import java.io.File;
import java.util.ArrayList;
import org.jboss.resteasy.utils.maven.MavenUtil;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class TestUtilSpring {
    private static final String defaultSpringVersion = "5.3.7";

    private static String getSpringVersion() {
        return System.getProperty("version.org.springframework", defaultSpringVersion);
    }

    private static File[] resolveSpringDependencies(String springVersion) {
        MavenUtil mavenUtil = MavenUtil.create((boolean)true);
        ArrayList<File> runtimeDependencies = new ArrayList<File>();
        try {
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.springframework:spring-core:" + springVersion));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.springframework:spring-web:" + springVersion));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.springframework:spring-webmvc:" + springVersion));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.springframework:spring-context:" + springVersion));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.springframework:spring-expression:" + springVersion));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.springframework:spring-beans:" + springVersion));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.springframework:spring-aop:" + springVersion));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get artifacts from maven via Aether library", e);
        }
        File[] dependencies = runtimeDependencies.toArray(new File[0]);
        return dependencies;
    }

    public static void addSpringLibraries(WebArchive archive) {
        archive.addAsLibraries(TestUtilSpring.resolveSpringDependencies(TestUtilSpring.getSpringVersion()));
    }
}

