/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.examples.timeanddate.worldclock;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.inject.Produces;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Singleton
@Startup
public class AvailableTimeZonesBean {
    public static final String STANDARD_DATE_TIME_FORMAT = "HH:mm:ss MM/dd/yyyy";
    @Inject
    List<DateTimeZone> timeZones;
    @Inject
    DateTimeZone applicationTimeZone;
    @Inject
    private Logger log;

    @PostConstruct
    public void startupTimeAroundTheWorld() {
        this.log.info((Object)"This bean started on: ");
        for (DateTimeZone dtz : this.timeZones) {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)STANDARD_DATE_TIME_FORMAT);
            DateTime dt = new DateTime().withZone(dtz);
            this.log.info((Object)(dtz.getID() + " - " + fmt.print((ReadableInstant)dt)));
        }
    }

    @Produces
    @Named(value="availableDateTimesFromTimeZones")
    public List<DateTime> getAvailableTimeZones() {
        List filteredTimeZones = this.filterTimeZones();
        LinkedList<DateTime> list = new LinkedList<DateTime>();
        for (DateTimeZone dtz : filteredTimeZones) {
            DateTime dateTime = new DateTime().withZone(dtz);
            list.add(dateTime);
        }
        return list;
    }

    private List<DateTimeZone> filterTimeZones() {
        String region = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("region");
        if (region != null) {
            LinkedList<DateTimeZone> filteredTimeZones = new LinkedList<DateTimeZone>();
            for (DateTimeZone dtz : this.timeZones) {
                if (!dtz.getID().startsWith(region)) continue;
                filteredTimeZones.add(dtz);
            }
            return filteredTimeZones;
        }
        return this.timeZones;
    }
}

