/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.status.builder;

import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.international.status.Bundles;
import org.jboss.seam.international.status.Level;
import org.jboss.seam.international.status.Message;
import org.jboss.seam.international.status.builder.BundleKey;
import org.jboss.seam.international.status.builder.BundleTemplateMessage;
import org.jboss.seam.international.status.builder.TemplateMessage;

public class BundleTemplateMessageImpl
implements BundleTemplateMessage {
    @Inject
    TemplateMessage template;
    private String textDefault;
    private BundleKey textKey;
    @Inject
    Bundles bundles;
    private final Logger log = Logger.getLogger(BundleTemplateMessageImpl.class);

    public Message build() {
        String text;
        try {
            text = this.bundles.get((Object)this.textKey.getBundle()).getString(this.textKey.getKey());
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not load bundle: " + this.textKey));
            text = this.textDefault;
        }
        if (text == null || "".equals(text)) {
            text = this.textKey.toString();
        }
        this.template.text(text);
        return this.template.build();
    }

    public BundleTemplateMessageImpl key(BundleKey text) {
        this.textKey = text;
        return this;
    }

    public BundleTemplateMessage defaults(String text) {
        this.textDefault = text;
        return this;
    }

    public BundleTemplateMessageImpl params(Object ... textParams) {
        this.template.textParams(textParams);
        return this;
    }

    public BundleTemplateMessage targets(String targets) {
        this.template.targets(targets);
        return this;
    }

    public BundleTemplateMessage level(Level level) {
        this.template.level(level);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        result = 31 * result + (this.textDefault == null ? 0 : this.textDefault.hashCode());
        result = 31 * result + (this.textKey == null ? 0 : this.textKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleTemplateMessageImpl other = (BundleTemplateMessageImpl)obj;
        if (this.template == null ? other.template != null : !this.template.equals(other.template)) {
            return false;
        }
        if (this.textDefault == null ? other.textDefault != null : !this.textDefault.equals(other.textDefault)) {
            return false;
        }
        return !(this.textKey == null ? other.textKey != null : !this.textKey.equals((Object)other.textKey));
    }
}

