/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.datetimezone;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.logging.Logger;
import org.jboss.seam.international.datetimezone.ForwardingDateTimeZone;
import org.jboss.seam.international.timezone.DefaultTimeZone;
import org.joda.time.DateTimeZone;

@ApplicationScoped
public class DefaultDateTimeZoneProducer
implements Serializable {
    private static final long serialVersionUID = 6181892144731122500L;
    @Inject
    @DefaultTimeZone
    private Instance<String> defaultTimeZoneId;
    private final Logger log = Logger.getLogger(DefaultDateTimeZoneProducer.class);
    @Produces
    @Named
    private DateTimeZone defaultDateTimeZone = null;

    @PostConstruct
    public void init() {
        if (!this.defaultTimeZoneId.isUnsatisfied()) {
            try {
                String id = (String)this.defaultTimeZoneId.get();
                DateTimeZone dtz = DateTimeZone.forID((String)id);
                this.defaultDateTimeZone = this.constructTimeZone(dtz);
            }
            catch (IllegalArgumentException e) {
                this.log.warn((Object)("DefaultDateTimeZoneProducer: Default TimeZone Id of " + this.defaultTimeZoneId + " was not found"));
            }
        }
        if (null == this.defaultDateTimeZone) {
            DateTimeZone dtz = DateTimeZone.getDefault();
            this.defaultDateTimeZone = this.constructTimeZone(dtz);
        }
    }

    private ForwardingDateTimeZone constructTimeZone(final DateTimeZone dtz) {
        return new ForwardingDateTimeZone(dtz.getID()){

            protected DateTimeZone delegate() {
                return dtz;
            }
        };
    }
}

