/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.reveng.AbstractDatabaseCollector;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Table;

public class DefaultDatabaseCollector
extends AbstractDatabaseCollector {
    private Map tables = new HashMap();
    private Map qualifiers = new HashMap();

    public DefaultDatabaseCollector(MetaDataDialect metaDataDialect) {
        super(metaDataDialect);
    }

    public Iterator iterateTables() {
        return this.tables.values().iterator();
    }

    public Table addTable(String schema, String catalog, String name) {
        String key = Table.qualify((String)this.quote(catalog), (String)this.quote(schema), (String)this.quote(name));
        Table table = (Table)this.tables.get(key);
        if (table == null) {
            table = new Table();
            table.setAbstract(false);
            table.setName(name);
            table.setSchema(schema);
            table.setCatalog(catalog);
            this.tables.put(key, table);
            String qualifier = StringHelper.qualifier((String)key);
            ArrayList<Table> schemaList = (ArrayList<Table>)this.qualifiers.get(qualifier);
            if (schemaList == null) {
                schemaList = new ArrayList<Table>();
                this.qualifiers.put(qualifier, schemaList);
            }
            schemaList.add(table);
        } else {
            table.setAbstract(false);
        }
        return table;
    }

    public Table getTable(String schema, String catalog, String name) {
        String key = Table.qualify((String)this.quote(catalog), (String)this.quote(schema), (String)this.quote(name));
        return (Table)this.tables.get(key);
    }

    public Iterator getQualifierEntries() {
        return this.qualifiers.entrySet().iterator();
    }
}

