/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.ioc.IoCComponent;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringComponent
extends IoCComponent {
    private static final String SPRING_COMPONENT_NAME_MAP = "org.jboss.seam.SpringComponentNameMap";
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = String.valueOf(IoCComponent.class.getName()) + ".DESTRUCTION_CALLBACK.";
    private BeanFactory beanfactory;
    private Boolean interceptionEnabled;
    private String springBeanName;
    private static final ThreadLocal<ObjectFactory> objectFactory = new ThreadLocal();

    public static ObjectFactory getObjectFactory() {
        return objectFactory.get();
    }

    public static void setObjectFactory(ObjectFactory bean) {
        objectFactory.set(bean);
    }

    public static void addSpringComponent(String componentName, String springBeanName, String beanClassName, ScopeType scopeType, BeanFactory beanFactory, Boolean intercept) {
        boolean unmockApplication = false;
        if (!Contexts.isApplicationContextActive()) {
            Lifecycle.setupApplication();
            unmockApplication = true;
        }
        try {
            try {
                if (Component.forName((String)componentName) != null) {
                    throw new IllegalStateException("Cannot add spring component to seam with name: " + componentName + ".  There is already a seam component with that name.");
                }
                Map<String, String> springComponentNameMap = SpringComponent.getSpringComponentNameMap();
                springComponentNameMap.put(springBeanName, componentName);
                Class beanClass = ClassUtils.forName((String)beanClassName);
                Contexts.getApplicationContext().set(String.valueOf(componentName) + ".component", (Object)new SpringComponent(beanClass, componentName, springBeanName, scopeType, beanFactory, intercept));
            }
            catch (ClassNotFoundException e) {
                throw new FatalBeanException("Error", (Throwable)e);
            }
        }
        finally {
            if (unmockApplication) {
                Lifecycle.cleanupApplication();
            }
        }
    }

    private static Map<String, String> getSpringComponentNameMap() {
        if (Contexts.getApplicationContext().get(SPRING_COMPONENT_NAME_MAP) == null) {
            Contexts.getApplicationContext().set(SPRING_COMPONENT_NAME_MAP, new HashMap());
        }
        return (Map)Contexts.getApplicationContext().get(SPRING_COMPONENT_NAME_MAP);
    }

    public static SpringComponent forSpringBeanName(String springBeanName) {
        boolean unmockApplication = false;
        if (!Contexts.isApplicationContextActive()) {
            Lifecycle.setupApplication();
            unmockApplication = true;
        }
        try {
            SpringComponent springComponent = (SpringComponent)Component.forName((String)SpringComponent.getSpringComponentNameMap().get(springBeanName));
            return springComponent;
        }
        finally {
            if (unmockApplication) {
                Lifecycle.cleanupApplication();
            }
        }
    }

    public SpringComponent(Class clazz, String componentName, String springBeanName, ScopeType scope, BeanFactory factory, Boolean intercept) {
        super(clazz, componentName, scope);
        this.springBeanName = springBeanName;
        this.beanfactory = factory;
        this.interceptionEnabled = intercept;
    }

    @Override
    protected String getIoCName() {
        return "Spring";
    }

    @Override
    protected Object instantiateIoCBean() throws Exception {
        ObjectFactory objectFactory = SpringComponent.getObjectFactory();
        if (objectFactory == null) {
            return this.beanfactory.getBean(this.springBeanName);
        }
        SpringComponent.setObjectFactory(null);
        return objectFactory.getObject();
    }

    public void destroy(Object instance) {
        Runnable callback;
        super.destroy(instance);
        if (this.getScope() != ScopeType.STATELESS && (callback = (Runnable)this.getScope().getContext().get(String.valueOf(DESTRUCTION_CALLBACK_NAME_PREFIX) + this.getName())) != null) {
            callback.run();
        }
    }

    public void registerDestroyCallback(String name, Runnable destroy) {
        if (this.getScope() != ScopeType.STATELESS) {
            this.getScope().getContext().set(String.valueOf(DESTRUCTION_CALLBACK_NAME_PREFIX) + name, (Object)destroy);
        }
    }

    public void inject(Object bean, boolean enforceRequired) {
        if (bean instanceof Advised) {
            try {
                this.inject(((Advised)bean).getTargetSource().getTarget(), enforceRequired);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        super.inject(bean, enforceRequired);
    }

    public boolean isInterceptionEnabled() {
        if (this.interceptionEnabled == null) {
            return super.isInterceptionEnabled();
        }
        return this.interceptionEnabled;
    }

    protected void checkSynchronizedForComponentType() {
    }

    protected void checkPersistenceContextForComponentType() {
    }

    public List<Component.BijectedAttribute> getPersistenceContextAttributes() {
        if (this.getScope().equals((Object)ScopeType.STATELESS)) {
            return Collections.emptyList();
        }
        return super.getPersistenceContextAttributes();
    }
}

