/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.jboss.seam.transaction.Synchronizations;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Name(value="org.jboss.seam.transaction.transaction")
@Scope(value=ScopeType.EVENT)
@Install(value=false, precedence=10)
@BypassInterceptors
public class SpringTransaction
extends AbstractUserTransaction {
    private static final LogProvider log = Logging.getLogProvider(SpringTransaction.class);
    private Expressions.ValueExpression<PlatformTransactionManager> platformTransactionManager;
    private String platformTransactionManagerName;
    private DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
    private boolean conversationContextRequired = true;
    private TransactionStatus currentTransaction;
    private Boolean joinTransaction;

    public void registerSynchronization(Synchronization sync) {
        SpringTransaction.getSynchronizations().registerSynchronization(sync);
    }

    public void begin() throws NotSupportedException, SystemException {
        log.debug((Object)"beginning Spring transaction");
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new NotSupportedException("A Spring transaction is already active.");
        }
        this.currentTransaction = this.getPlatformTransactionManagerRequired().getTransaction((TransactionDefinition)this.definition);
        SpringTransaction.getSynchronizations().afterTransactionBegin();
    }

    protected PlatformTransactionManager getPlatformTransactionManager() {
        if ((this.platformTransactionManagerName == null || "".equals(this.platformTransactionManagerName)) && this.platformTransactionManager == null || this.platformTransactionManagerName != null && !"".equals(this.platformTransactionManagerName) && this.platformTransactionManager != null) {
            throw new IllegalArgumentException("When configuring spring:spring-transaction you must specify either platformTransactionManager or platformTransactionManagerName.");
        }
        if (this.platformTransactionManagerName == null || "".equals(this.platformTransactionManagerName)) {
            return (PlatformTransactionManager)this.platformTransactionManager.getValue();
        }
        BeanFactory beanFactory = this.findBeanFactory();
        if (beanFactory == null) {
            log.debug((Object)"BeanFactory either not found or not yet available.");
            return null;
        }
        PlatformTransactionManager ptm = (PlatformTransactionManager)beanFactory.getBean(this.platformTransactionManagerName);
        return ptm;
    }

    private PlatformTransactionManager getPlatformTransactionManagerRequired() {
        PlatformTransactionManager ptm = this.getPlatformTransactionManager();
        if (ptm == null) {
            throw new IllegalStateException("Unable to find PlatformTransactionManager");
        }
        return ptm;
    }

    protected BeanFactory findBeanFactory() {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)ServletLifecycle.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        log.debug((Object)"committing Spring transaction");
        this.assertActive();
        boolean success = false;
        Synchronizations synchronizations = SpringTransaction.getSynchronizations();
        synchronizations.beforeTransactionCommit();
        try {
            this.getPlatformTransactionManagerRequired().commit(this.currentTransaction);
            success = true;
        }
        finally {
            this.currentTransaction = null;
            synchronizations.afterTransactionCommit(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() throws SystemException {
        PlatformTransactionManager ptm = this.getPlatformTransactionManager();
        if (ptm == null) {
            return 6;
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionStatus transaction = null;
            try {
                if (this.currentTransaction == null) {
                    transaction = ptm.getTransaction((TransactionDefinition)this.definition);
                    if (transaction.isNewTransaction()) {
                        int n = 3;
                        return n;
                    }
                } else {
                    transaction = this.currentTransaction;
                }
                if (transaction.isCompleted()) {
                    if (transaction.isRollbackOnly()) {
                        int n = 4;
                        return n;
                    }
                    int n = 3;
                    return n;
                }
                if (transaction.isRollbackOnly()) {
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                if (this.currentTransaction == null) {
                    ptm.commit(transaction);
                }
            }
        }
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        log.debug((Object)"rolling back Spring transaction");
        this.assertActive();
        try {
            this.getPlatformTransactionManagerRequired().rollback(this.currentTransaction);
        }
        finally {
            this.currentTransaction = null;
            SpringTransaction.getSynchronizations().afterTransactionRollback();
        }
    }

    private void assertActive() {
        if (!TransactionSynchronizationManager.isActualTransactionActive() || this.currentTransaction == null) {
            throw new IllegalStateException("No transaction currently active that Seam started.Seam should only be able to committ or rollback transactions it started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new IllegalStateException("No Spring Transaction is currently available.");
        }
        TransactionStatus transaction = null;
        PlatformTransactionManager ptm = this.getPlatformTransactionManagerRequired();
        try {
            transaction = this.currentTransaction == null ? ptm.getTransaction((TransactionDefinition)this.definition) : this.currentTransaction;
            transaction.setRollbackOnly();
        }
        finally {
            if (this.currentTransaction == null) {
                ptm.commit(transaction);
            }
        }
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            return;
        }
        this.definition.setTimeout(timeout);
    }

    public void enlist(EntityManager entityManager) throws SystemException {
        if (this.joinTransaction == null) {
            if (!(this.getPlatformTransactionManagerRequired() instanceof JpaTransactionManager)) {
                super.enlist(entityManager);
            }
        } else if (this.joinTransaction.booleanValue()) {
            super.enlist(entityManager);
        }
    }

    @Destroy
    public void cleanupCurrentTransaction() {
        if (this.currentTransaction != null) {
            try {
                log.debug((Object)"Attempting to rollback left over transaction.  Should never be called.");
                this.getPlatformTransactionManagerRequired().rollback(this.currentTransaction);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setPlatformTransactionManager(Expressions.ValueExpression<PlatformTransactionManager> platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    public void setPlatformTransactionManagerName(String platformTransactionManagerName) {
        this.platformTransactionManagerName = platformTransactionManagerName;
    }

    public boolean isConversationContextRequired() {
        return this.conversationContextRequired;
    }

    public void setConversationContextRequired(boolean conversationContextRequired) {
        this.conversationContextRequired = conversationContextRequired;
    }

    public void setJoinTransaction(Boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }
}

