/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.servlet.ServletExtension;
import org.jboss.seam.servlet.http.CookieParam;
import org.jboss.seam.servlet.http.DefaultValue;
import org.jboss.seam.servlet.http.TypedParamValue;
import org.jboss.seam.solder.reflection.PrimitiveTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieParamProducer {
    @Inject
    private HttpServletRequest request;

    @Produces
    @TypedParamValue
    protected Object getTypedParamValue(InjectionPoint ip, ServletExtension ext) {
        String cookieName = this.getCookieName(ip);
        Class t = PrimitiveTypes.box(this.resolveExpectedType(ip));
        if (t.equals(Cookie.class)) {
            return this.getCookie(cookieName, ip);
        }
        String v = this.getCookieValue(cookieName, ip);
        if (t.equals(String.class)) {
            return v;
        }
        try {
            Member converter = ext.getConverterMember(t);
            return converter instanceof Constructor ? ((Constructor)converter).newInstance(v) : ((Method)converter).invoke(null, v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getCookieName(InjectionPoint ip) {
        String headerName = ((CookieParam)ip.getAnnotated().getAnnotation(CookieParam.class)).value();
        if ("".equals(headerName)) {
            headerName = ip.getMember().getName();
        }
        return headerName;
    }

    private Cookie getCookie(String cookieName, InjectionPoint ip) {
        String defaultValue;
        Cookie cookie = null;
        for (Cookie c : this.request.getCookies()) {
            if (!c.getName().equals(cookieName)) continue;
            cookie = c;
            break;
        }
        if (cookie == null && (defaultValue = this.getDefaultValue(ip)) != null) {
            cookie = new Cookie(cookieName, defaultValue);
        }
        return cookie;
    }

    private String getCookieValue(String cookieName, InjectionPoint ip) {
        for (Cookie c : this.request.getCookies()) {
            if (!c.getName().equals(cookieName)) continue;
            return c.getValue();
        }
        return this.getDefaultValue(ip);
    }

    private String getDefaultValue(InjectionPoint ip) {
        DefaultValue defaultValueAnnotation = (DefaultValue)ip.getAnnotated().getAnnotation(DefaultValue.class);
        return defaultValueAnnotation == null ? null : defaultValueAnnotation.value();
    }

    private Class<?> resolveExpectedType(InjectionPoint ip) {
        Type t = ip.getType();
        if (t instanceof ParameterizedType && ((ParameterizedType)t).getActualTypeArguments().length == 1) {
            return (Class)((ParameterizedType)t).getActualTypeArguments()[0];
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        return Object.class;
    }
}

