/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.servlet.http.RedirectBuilder;

public class RedirectBuilderImpl
implements RedirectBuilder {
    @Inject
    private HttpServletRequest request;
    @Inject
    private HttpServletResponse response;
    private String path = null;
    private String fragment = null;
    private Map<String, String[]> paramMap = new LinkedHashMap<String, String[]>();
    private Map<String, String[]> headerMap = new LinkedHashMap<String, String[]>();
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private int status = 302;
    private boolean encode = false;

    @Override
    public RedirectBuilder mirror() {
        this.paramMap = new LinkedHashMap<String, String[]>(this.request.getParameterMap());
        this.headerMap = new LinkedHashMap<String, String[]>();
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList v = new ArrayList();
            Enumeration values = this.request.getHeaders(name);
            while (values.hasMoreElements()) {
                v.add(values.nextElement());
            }
            this.headerMap.put(name, v.toArray(new String[0]));
        }
        this.path = this.request.getRequestURI();
        if (this.path.indexOf("#") >= 0) {
            this.fragment = this.path.substring(this.path.indexOf("#") + 1);
        }
        return this;
    }

    @Override
    public RedirectBuilder header(String name, Object ... values) {
        return this.header(true, name, values);
    }

    @Override
    public RedirectBuilder header(boolean replace, String name, Object ... values) {
        ArrayList<Object> stringValues = new ArrayList<Object>(values.length);
        if (!replace && this.headerMap.containsKey(name)) {
            for (String existing : this.headerMap.get(name)) {
                stringValues.add(existing);
            }
        }
        for (Object value : values) {
            if (value == null) continue;
            stringValues.add(value.toString());
        }
        this.headerMap.put(name, stringValues.toArray(new String[0]));
        return this;
    }

    @Override
    public RedirectBuilder param(String name, Object ... values) {
        return this.param(true, name, values);
    }

    @Override
    public RedirectBuilder param(boolean replace, String name, Object ... values) {
        ArrayList<Object> stringValues = new ArrayList<Object>(values.length);
        if (!replace && this.paramMap.containsKey(name)) {
            for (String existing : this.paramMap.get(name)) {
                stringValues.add(existing);
            }
        }
        for (Object value : values) {
            if (value == null) continue;
            stringValues.add(value.toString());
        }
        this.paramMap.put(name, stringValues.toArray(new String[0]));
        return this;
    }

    @Override
    public RedirectBuilder cookie(Cookie ... cookies) {
        for (Cookie c : cookies) {
            this.cookies.add(c);
        }
        return this;
    }

    @Override
    public RedirectBuilder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    @Override
    public RedirectBuilder seeOther(String path) {
        this.status = 303;
        this.path = path;
        return this;
    }

    @Override
    public RedirectBuilder temporaryRedirect(String path) {
        this.status = 307;
        this.path = path;
        return this;
    }

    @Override
    public RedirectBuilder redirect() {
        return this.redirect(null);
    }

    @Override
    public RedirectBuilder redirect(String path) {
        this.status = 302;
        this.path = path;
        return this;
    }

    @Override
    public RedirectBuilder encodeSessionId() {
        this.encode = true;
        return this;
    }

    @Override
    public void send() {
        if (this.response.isCommitted()) {
            throw new RuntimeException("Cannot issue redirect. Response already committed.");
        }
        String location = this.path;
        if (location == null) {
            location = this.request.getRequestURI();
        } else if (!location.startsWith("/")) {
            location = this.request.getContextPath() + location;
        }
        for (Map.Entry<String, String[]> headers : this.headerMap.entrySet()) {
            String name = headers.getKey();
            for (String value : headers.getValue()) {
                this.response.addHeader(name, value);
            }
        }
        for (Cookie c : this.cookies) {
            this.response.addCookie(c);
        }
        String query = "";
        for (Map.Entry<String, String[]> params : this.paramMap.entrySet()) {
            String name = params.getKey();
            for (String value : params.getValue()) {
                query = query + (query.length() == 0 ? "?" : "&amp;") + name + "=" + value;
            }
        }
        location = location + query;
        if (this.fragment != null) {
            location = location + "#" + this.fragment;
        }
        try {
            this.response.resetBuffer();
            if (this.encode) {
                location = this.response.encodeRedirectURL(location);
            }
            this.response.setHeader("Location", location);
            this.response.setStatus(this.status);
            this.response.getWriter().flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to issue redirect. " + e.getMessage());
        }
    }
}

