/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.classmetamodel;

import gnu.trove.TLongObjectHashMap;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.serial.classmetamodel.ClassMetadataField;
import org.jboss.serial.classmetamodel.FieldsManager;
import org.jboss.serial.references.MethodPersistentReference;
import org.jboss.serial.references.PersistentReference;
import org.jboss.serial.util.ClassMetaConsts;
import org.jboss.serial.util.HashStringUtil;

public class ClassMetaDataSlot
implements ClassMetaConsts {
    WeakReference slotClass;
    String name;
    HashMap fields = new HashMap();
    TLongObjectHashMap hashFields = new TLongObjectHashMap();
    long shaHash;
    PersistentReference privateMethodWrite = emptyReference;
    PersistentReference privateMethodRead = emptyReference;
    ClassMetadataField[] fieldsCollection;

    public ClassMetaDataSlot(Class slotClass) {
        this.slotClass = new WeakReference<Class>(slotClass);
        this.name = slotClass.getName();
        this.shaHash = HashStringUtil.hashName(this.name);
        if (!Serializable.class.isAssignableFrom(slotClass)) {
            this.explorefieldsNonSerializable(slotClass);
        } else {
            this.exploreFields(slotClass);
        }
        this.explorePrivateMethod(slotClass);
    }

    private void explorePrivateMethod(Class slotClass) {
        Method method = null;
        try {
            method = slotClass.getDeclaredMethod("readObject", ObjectInputStream.class);
            method.setAccessible(true);
            this.setPrivateMethodRead(method);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            method = slotClass.getDeclaredMethod("writeObject", ObjectOutputStream.class);
            method.setAccessible(true);
            this.setPrivateMethodWrite(method);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void exploreFields(Class slotClass) {
        Field[] fields = slotClass.getDeclaredFields();
        ArrayList<ClassMetadataField> fieldsList = new ArrayList<ClassMetadataField>();
        for (int i = 0; i < fields.length; i = (int)((short)(i + 1))) {
            if ((fields[i].getModifiers() & 0x88) != 0) continue;
            fields[i].setAccessible(true);
            ClassMetadataField classfield = new ClassMetadataField(fields[i]);
            FieldsManager.getFieldsManager().fillMetadata(classfield);
            this.addField(classfield.getShaHash(), classfield.getFieldName(), classfield);
            classfield.setOrder((short)fieldsList.size());
            fieldsList.add(classfield);
        }
        this.fieldsCollection = fieldsList.toArray(new ClassMetadataField[fieldsList.size()]);
    }

    private void explorefieldsNonSerializable(Class slotClass) {
        ArrayList<ClassMetadataField> fieldsList = new ArrayList<ClassMetadataField>();
        while (slotClass != null && slotClass != Object.class) {
            Field[] fields = slotClass.getDeclaredFields();
            for (int i = 0; i < fields.length; i = (int)((short)(i + 1))) {
                if ((fields[i].getModifiers() & 0x88) != 0) continue;
                fields[i].setAccessible(true);
                ClassMetadataField classfield = new ClassMetadataField(fields[i]);
                FieldsManager.getFieldsManager().fillMetadata(classfield);
                this.addField(classfield.getShaHash(), classfield.getFieldName(), classfield);
                classfield.setOrder((short)fieldsList.size());
                fieldsList.add(classfield);
            }
            slotClass = slotClass.getSuperclass();
        }
        this.fieldsCollection = fieldsList.toArray(new ClassMetadataField[fieldsList.size()]);
    }

    public Class getSlotClass() {
        return (Class)this.slotClass.get();
    }

    public void setSlotClass(Class newSlotClass) {
        this.slotClass = new WeakReference<Class>(newSlotClass);
    }

    private void addField(long shaHashKey, String fieldName, ClassMetadataField classfield) {
        this.fields.put(fieldName, classfield);
        this.hashFields.put(shaHashKey, (Object)classfield);
    }

    public ClassMetadataField getField(String name) {
        return (ClassMetadataField)this.fields.get(name);
    }

    public ClassMetadataField getField(long shaKey) {
        return (ClassMetadataField)this.hashFields.get(shaKey);
    }

    public ClassMetadataField[] getFields() {
        return this.fieldsCollection;
    }

    public Method getPrivateMethodRead() {
        return (Method)this.privateMethodRead.get();
    }

    public void setPrivateMethodRead(Method privateMethodRead) {
        this.privateMethodRead = new MethodPersistentReference(privateMethodRead, 2);
    }

    public Method getPrivateMethodWrite() {
        return (Method)this.privateMethodWrite.get();
    }

    public void setPrivateMethodWrite(Method privateMethodWrite) {
        this.privateMethodWrite = new MethodPersistentReference(privateMethodWrite, 2);
    }

    public long getShaHash() {
        return this.shaHash;
    }

    public void setShaHash(long shaHash) {
        this.shaHash = shaHash;
    }
}

