/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jboss.serial.classmetamodel.ClassDescriptorStrategy;
import org.jboss.serial.classmetamodel.ClassResolver;
import org.jboss.serial.classmetamodel.DefaultClassDescriptorStrategy;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.DataContainer;
import org.jboss.serial.objectmetamodel.DataContainerConstants;
import org.jboss.serial.objectmetamodel.DefaultObjectDescriptorStrategy;
import org.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.util.ClassMetaConsts;
import org.jboss.serial.util.StringUtil;
import org.jboss.serial.util.StringUtilBuffer;

public class JBossObjectInputStream
extends ObjectInputStream
implements DataContainerConstants {
    InputStream is;
    DataInputStream dis;
    DataContainer container;
    ClassLoader classLoader;
    StringUtilBuffer buffer;
    private static Constructor constructorObjectStreamClass;
    private static Field setNameField;
    ClassDescriptorStrategy classDescriptorStrategy = new DefaultClassDescriptorStrategy();
    ObjectDescriptorStrategy objectDescriptorStrategy = new DefaultObjectDescriptorStrategy();
    private static Field fieldEnableResolve;
    ClassResolver resolver = new ClassResolver(){

        public Class resolveClass(String name) throws ClassNotFoundException {
            if (constructorObjectStreamClass != null) {
                try {
                    ObjectStreamClass streamClass = (ObjectStreamClass)constructorObjectStreamClass.newInstance(ClassMetaConsts.EMPTY_OBJECT_ARRAY);
                    setNameField.set(streamClass, name);
                    return JBossObjectInputStream.this.resolveClass(streamClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
    };

    protected ObjectSubstitutionInterface getSubstitutionInterface() throws IOException {
        try {
            if (fieldEnableResolve.getBoolean(this)) {
                return new ObjectSubstitutionInterface(){

                    public Object replaceObject(Object obj) throws IOException {
                        return JBossObjectInputStream.this.resolveObject(obj);
                    }
                };
            }
            return null;
        }
        catch (IllegalAccessException ex) {
            throw new SerializationException(ex.getMessage(), ex);
        }
    }

    public JBossObjectInputStream(InputStream is) throws IOException {
        this(is, Thread.currentThread().getContextClassLoader());
    }

    public JBossObjectInputStream(InputStream is, StringUtilBuffer buffer) throws IOException {
        this(is, Thread.currentThread().getContextClassLoader(), buffer);
    }

    public JBossObjectInputStream(InputStream is, ClassLoader loader) throws IOException {
        this(is, loader, null);
    }

    public JBossObjectInputStream(InputStream is, ClassLoader loader, StringUtilBuffer buffer) throws IOException {
        this.buffer = buffer;
        if (is != null) {
            this.is = is;
            this.readStreamHeader();
            this.dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
        }
        this.classLoader = loader;
    }

    private void checkSignature(InputStream is) throws IOException {
        byte[] signature = new byte[openSign.length];
        is.read(signature);
        if (!Arrays.equals(signature, openSign)) {
            throw new IOException("Mismatch version of JBossSerialization signature");
        }
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return Class.forName(desc.getName(), false, this.getClassLoader());
    }

    public Object readObjectUsingDataContainer() throws IOException, ClassNotFoundException {
        DataContainer container = new DataContainer(this.classLoader, false, this.buffer);
        container.setClassResolver(this.resolver);
        container.loadData(this.dis);
        ObjectInput input = container.getInput();
        return input.readObject();
    }

    public Object readObjectOverride() throws IOException, ClassNotFoundException {
        DataContainer container = new DataContainer(this.classLoader, this.getSubstitutionInterface(), false, this.buffer, this.classDescriptorStrategy, this.objectDescriptorStrategy);
        container.setClassResolver(this.resolver);
        ObjectInput input = container.getDirectInput(this.dis);
        return input.readObject();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObjectOverride();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        this.checkSignature(this.is);
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        return null;
    }

    protected ClassDescriptorStrategy getClassDescriptorStrategy() {
        return this.classDescriptorStrategy;
    }

    protected void setClassDescriptorStrategy(ClassDescriptorStrategy classDescriptorStrategy) {
        this.classDescriptorStrategy = classDescriptorStrategy;
    }

    protected ObjectDescriptorStrategy getObjectDescriptorStrategy() {
        return this.objectDescriptorStrategy;
    }

    protected void setObjectDescriptorStrategy(ObjectDescriptorStrategy objectDescriptorStrategy) {
        this.objectDescriptorStrategy = objectDescriptorStrategy;
    }

    public int read() throws IOException {
        return this.dis.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.dis.read(buf, off, len);
    }

    public int available() throws IOException {
        return 1;
    }

    public void close() throws IOException {
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public void readFully(byte[] buf) throws IOException {
        this.dis.readFully(buf);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        this.dis.readFully(buf, off, len);
    }

    public int skipBytes(int len) throws IOException {
        return this.dis.skipBytes(len);
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public String readUTF() throws IOException {
        return StringUtil.readString(this.dis, this.buffer);
    }

    public int read(byte[] b) throws IOException {
        return this.dis.read(b);
    }

    public long skip(long n) throws IOException {
        return this.dis.skip(n);
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static {
        try {
            constructorObjectStreamClass = ObjectStreamClass.class.getDeclaredConstructor(ClassMetaConsts.EMPTY_CLASS_ARRY);
            constructorObjectStreamClass.setAccessible(true);
            setNameField = ObjectStreamClass.class.getDeclaredField("name");
            setNameField.setAccessible(true);
        }
        catch (Exception e) {
            constructorObjectStreamClass = null;
            setNameField = null;
            e.printStackTrace();
        }
        try {
            fieldEnableResolve = ObjectInputStream.class.getDeclaredField("enableResolve");
            fieldEnableResolve.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

