/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.classmetamodel.StreamingClass;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import org.jboss.serial.objectmetamodel.ObjectsCache;
import org.jboss.serial.persister.ClassReferencePersister;
import org.jboss.serial.persister.PersistResolver;
import org.jboss.serial.persister.Persister;
import org.jboss.serial.util.ClassMetaConsts;

public class DefaultObjectDescriptorStrategy
implements ObjectDescriptorStrategy,
ClassMetaConsts {
    private static final Logger log = Logger.getLogger(DefaultObjectDescriptorStrategy.class);
    private static final boolean isDebug = log.isDebugEnabled();

    public boolean writeObjectSpecialCase(ObjectsCache.JBossSeralizationOutputInterface output, ObjectsCache cache, Object obj) throws IOException {
        if (obj == null) {
            output.writeByte(99);
            return true;
        }
        if (obj != null && ClassMetamodelFactory.isImmutable(obj.getClass())) {
            output.saveImmutable(cache, obj);
            return true;
        }
        return false;
    }

    public boolean writeDuplicateObject(ObjectsCache.JBossSeralizationOutputInterface output, ObjectsCache cache, Object obj, ClassMetaData metaData) throws IOException {
        int description = cache.findIdInCacheWrite(obj, metaData.isImmutable());
        if (description != 0) {
            if (isDebug) {
                log.debug((Object)("describeObject::a circular reference " + description));
            }
            output.writeByte(3);
            cache.getOutput().addObjectReference(description);
            return true;
        }
        return false;
    }

    public Object replaceObjectByClass(ObjectsCache cache, Object obj, ClassMetaData metaData) throws IOException {
        if (obj instanceof Class) {
            return obj;
        }
        if (metaData.getWriteReplaceMethod() != null) {
            if (isDebug) {
                log.debug((Object)("describeObject::Calling writeReplace for " + metaData.getClazz().getName()));
            }
            try {
                return metaData.getWriteReplaceMethod().invoke(obj, EMPTY_OBJECT_ARRAY);
            }
            catch (Exception e) {
                IOException io = new IOException("Metadata Serialization Error");
                io.initCause(e);
                throw io;
            }
        }
        return obj;
    }

    public Object replaceObjectByStream(ObjectsCache cache, Object obj, ClassMetaData metaData) throws IOException {
        if (cache.getSubstitution() != null) {
            if (isDebug) {
                log.debug((Object)"describeObject::checking substitution on interface");
            }
            return cache.getSubstitution().replaceObject(obj);
        }
        return obj;
    }

    public boolean doneReplacing(ObjectsCache cache, Object newObject, Object oldObject, ClassMetaData oldMetaData) throws IOException {
        return newObject == null || newObject == oldObject || newObject.getClass() == oldMetaData.getClazz();
    }

    public void writeObject(ObjectsCache.JBossSeralizationOutputInterface output, ObjectsCache cache, ClassMetaData metadata, Object obj) throws IOException {
        Persister persister = PersistResolver.resolvePersister(obj, metadata);
        output.writeByte(persister.getId());
        persister.writeData(metadata, cache.getOutput(), obj, cache.getSubstitution());
    }

    public Object readObjectSpecialCase(ObjectsCache.JBossSeralizationInputInterface input, ObjectsCache cache, byte byteIdentify) throws IOException {
        return input.readImmutable(byteIdentify, cache);
    }

    public Object readObject(ObjectsCache.JBossSeralizationInputInterface input, ObjectsCache cache, StreamingClass streamingClass, int reference) throws IOException {
        ClassMetaData metaData = streamingClass.getMetadata();
        if (isDebug) {
            log.debug((Object)("Reading object for id=" + reference + " classLoader=" + cache.getLoader() + " className = " + metaData.getClassName()));
        }
        byte persisterId = input.readByte();
        Persister persister = PersistResolver.resolvePersister(persisterId);
        Object value = persister.readData(cache.getLoader(), streamingClass, metaData, reference, cache, cache.getInput(), cache.getSubstitution());
        if (!(persister instanceof ClassReferencePersister)) {
            if (cache.getSubstitution() != null) {
                value = cache.getSubstitution().replaceObject(value);
            }
            try {
                if (metaData.getReadResolveMethod() != null) {
                    if (isDebug) {
                        log.debug((Object)("readObjectDescriptionFromStreaming::calling readResolve for className = " + metaData.getClassName()));
                    }
                    value = metaData.getReadResolveMethod().invoke(value, new Object[0]);
                    cache.reassignObjectInCacheRead(reference, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
            catch (InvocationTargetException e) {
                throw new SerializationException(e);
            }
        }
        return value;
    }
}

