/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.classmetamodel.StreamingClass;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import org.jboss.serial.objectmetamodel.ObjectsCache;
import org.jboss.serial.util.ClassMetaConsts;

public class ObjectDescriptorFactory
implements ClassMetaConsts {
    private static final Logger log = Logger.getLogger(ObjectDescriptorFactory.class);
    private static final boolean isDebug = log.isDebugEnabled();

    static Object objectFromDescription(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input) throws IOException {
        if (cache.getSubstitution() != null) {
            return cache.getSubstitution().replaceObject(ObjectDescriptorFactory.objectFromDescriptionInternal(cache, input));
        }
        return ObjectDescriptorFactory.objectFromDescriptionInternal(cache, input);
    }

    private static Object objectFromDescriptionInternal(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input) throws IOException {
        Object description = null;
        byte byteIdentify = cache.getInput().readByte();
        if (byteIdentify == 60) {
            cache.reset();
            return ObjectDescriptorFactory.objectFromDescription(cache, input);
        }
        if (byteIdentify == 99) {
            return null;
        }
        if (byteIdentify == 51) {
            if (isDebug) {
                log.debug((Object)"objectFromDescription::reading new definition");
            }
            return ObjectDescriptorFactory.readObjectDescriptionFromStreaming(cache, input);
        }
        if (byteIdentify == 50) {
            int reference = input.readObjectReference();
            if (isDebug) {
                log.debug((Object)("objectFromDescription::reading reference from safeClone=" + reference));
            }
            if (cache.getSafeToReuse() == null) {
                throw new IOException("SafeClone repository mismatch");
            }
            description = cache.getSafeToReuse().findReference(reference);
            if (description == null) {
                throw new IOException("SafeClone repository mismatch - didn't find reference " + reference);
            }
            return description;
        }
        if (byteIdentify == 3) {
            int reference = input.readObjectReference();
            if (isDebug) {
                log.debug((Object)("objectFromDescription::reading circular definition reference=" + reference));
            }
            if (description == null) {
                description = cache.findObjectInCacheRead(reference);
            }
            if (description == null) {
                throw new SerializationException("Object reference " + reference + " was not found");
            }
            return description;
        }
        return cache.getObjectDescriptorStrategy().readObjectSpecialCase(input, cache, byteIdentify);
    }

    static void describeObject(ObjectsCache cache, Object obj) throws IOException {
        ObjectsCache.JBossSeralizationOutputInterface outputParent = cache.getOutput();
        ObjectDescriptorStrategy objectDescriptorStrategy = cache.getObjectDescriptorStrategy();
        if (objectDescriptorStrategy.writeObjectSpecialCase(outputParent, cache, obj)) {
            return;
        }
        ClassMetaData metaData = ObjectDescriptorFactory.getMetaData(obj, cache);
        if (objectDescriptorStrategy.writeDuplicateObject(outputParent, cache, obj, metaData)) {
            return;
        }
        Object originalObject = obj;
        Object newObject = obj;
        do {
            if (!objectDescriptorStrategy.writeObjectSpecialCase(outputParent, cache, newObject = objectDescriptorStrategy.replaceObjectByClass(cache, obj = newObject, metaData = ObjectDescriptorFactory.getMetaData(obj, cache)))) continue;
            return;
        } while (!objectDescriptorStrategy.doneReplacing(cache, newObject, obj, metaData));
        obj = newObject;
        metaData = ObjectDescriptorFactory.getMetaData(obj, cache);
        if (cache.getSubstitution() != null) {
            if (isDebug) {
                log.debug((Object)"describeObject::checking substitution on interface");
            }
            Object orig = obj;
            obj = cache.getSubstitution().replaceObject(obj);
            if (obj != orig) {
                if (isDebug) {
                    log.debug((Object)("describeObject::on check interface, original object[" + orig.getClass().getName() + "] was replaced by [" + obj.getClass().getName() + "]"));
                }
                if (objectDescriptorStrategy.writeObjectSpecialCase(outputParent, cache, obj)) {
                    return;
                }
                metaData = ObjectDescriptorFactory.getMetaData(obj, cache);
            }
        }
        if (isDebug && obj == null) {
            log.debug((Object)"obj==null", (Throwable)new Exception());
        }
        if (isDebug) {
            log.debug((Object)("describeObject for class=" + obj.getClass().getName()));
        }
        int description = 0;
        if (cache.getSafeToReuse() != null && (description = cache.getSafeToReuse().storeSafe(obj)) != 0) {
            if (isDebug) {
                log.debug((Object)("describeObject::a safeClone reference " + description));
            }
            outputParent.writeByte(50);
            cache.getOutput().addObjectReference(description);
            return;
        }
        description = cache.findIdInCacheWrite(obj, metaData.isImmutable());
        if (description != 0) {
            if (isDebug) {
                log.debug((Object)("describeObject::a circular reference " + description));
            }
            outputParent.writeByte(3);
            cache.getOutput().addObjectReference(description);
            return;
        }
        ClassMetaData originalMetaData = metaData;
        if (obj != originalObject) {
            originalMetaData = ObjectDescriptorFactory.getMetaData(originalObject, cache);
        }
        description = cache.putObjectInCacheWrite(originalObject, originalMetaData.isImmutable());
        if (isDebug) {
            log.debug((Object)("describeObject::a new reference " + description));
        }
        outputParent.writeByte(51);
        cache.getOutput().addObjectReference(description);
        cache.getClassDescriptorStrategy().writeClassDescription(obj, metaData, cache, description);
        cache.getObjectDescriptorStrategy().writeObject(outputParent, cache, metaData, obj);
    }

    private static Object readObjectDescriptionFromStreaming(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input) throws IOException {
        int reference = input.readObjectReference();
        StreamingClass streamingClass = cache.getClassDescriptorStrategy().readClassDescription(cache, input, cache.getClassResolver(), null);
        return cache.getObjectDescriptorStrategy().readObject(input, cache, streamingClass, reference);
    }

    private static ClassMetaData getMetaData(Object obj, ObjectsCache cache) throws IOException {
        if (obj instanceof Class) {
            return ClassMetamodelFactory.getClassMetaData((Class)obj, false);
        }
        return ClassMetamodelFactory.getClassMetaData(obj.getClass(), cache.isCheckSerializableClass());
    }
}

