/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.ClassUtils;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventPublisherImpl
implements EventPublisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventDispatcher eventDispatcher;
    private final List<ListenerHandler> listenerHandlers;
    private final Multimap<Class<?>, KeyedListenerInvoker> listenerInvokers;

    public EventPublisherImpl(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this.eventDispatcher = Preconditions.checkNotNull(eventDispatcher);
        this.listenerHandlers = Preconditions.checkNotNull(Preconditions.checkNotNull(listenerHandlersConfiguration).getListenerHandlers());
        this.listenerInvokers = this.newMultimap();
    }

    @Override
    public void publish(Object event) {
        this.invokeListeners(this.findListenerInvokersForEvent(Preconditions.checkNotNull(event)), event);
    }

    @Override
    public void register(Object listener) {
        this.registerListener(ObjectUtils.identityToString(Preconditions.checkNotNull(listener)), listener);
    }

    @Override
    public void unregister(Object listener) {
        this.unregisterListener(ObjectUtils.identityToString(Preconditions.checkNotNull(listener)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAll() {
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.listenerInvokers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListener(String listenerKey) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(listenerKey), "Key for the listener must not be empty");
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            Iterator<Map.Entry<Class<?>, KeyedListenerInvoker>> invokerIterator = this.listenerInvokers.entries().iterator();
            while (invokerIterator.hasNext()) {
                if (!invokerIterator.next().getValue().getKey().equals(listenerKey)) continue;
                invokerIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(String listenerKey, Object listener) {
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.unregisterListener(listenerKey);
            ArrayList<? extends ListenerInvoker> invokers = Lists.newArrayList();
            for (ListenerHandler listenerHandler : this.listenerHandlers) {
                invokers.addAll(listenerHandler.getInvokers(listener));
            }
            if (invokers.isEmpty()) {
                throw new IllegalArgumentException("No listener invokers were found for listener <" + listener + ">");
            }
            this.registerListenerInvokers(listenerKey, invokers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<KeyedListenerInvoker> findListenerInvokersForEvent(Object event) {
        LinkedHashSet<KeyedListenerInvoker> invokersForEvent = Sets.newLinkedHashSet();
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            for (Class<?> eventClass : ClassUtils.findAllTypes(Preconditions.checkNotNull(event).getClass())) {
                invokersForEvent.addAll(this.listenerInvokers.get(eventClass));
            }
        }
        return invokersForEvent;
    }

    private void invokeListeners(Collection<KeyedListenerInvoker> listenerInvokers, Object event) {
        for (KeyedListenerInvoker keyedInvoker : listenerInvokers) {
            try {
                this.eventDispatcher.dispatch(keyedInvoker.getInvoker(), event);
            }
            catch (Exception e) {
                this.log.error("There was an exception thrown trying to dispatch event '" + event + "' from the invoker '" + keyedInvoker.getInvoker() + "'.", e);
            }
        }
    }

    private void registerListenerInvokers(String listenerKey, List<? extends ListenerInvoker> invokers) {
        for (ListenerInvoker listenerInvoker : invokers) {
            this.registerListenerInvoker(listenerKey, listenerInvoker);
        }
    }

    private void registerListenerInvoker(String listenerKey, ListenerInvoker invoker) {
        if (invoker.getSupportedEventTypes().isEmpty()) {
            this.listenerInvokers.put(Object.class, new KeyedListenerInvoker(listenerKey, invoker));
        }
        for (Class<?> eventClass : invoker.getSupportedEventTypes()) {
            this.listenerInvokers.put(eventClass, new KeyedListenerInvoker(listenerKey, invoker));
        }
    }

    private Multimap<Class<?>, KeyedListenerInvoker> newMultimap() {
        return Multimaps.synchronizedMultimap(Multimaps.newMultimap(Maps.newHashMap(), new Supplier<Collection<KeyedListenerInvoker>>(){

            @Override
            public Collection<KeyedListenerInvoker> get() {
                return Sets.newHashSet();
            }
        }));
    }

    private static final class KeyedListenerInvoker {
        private final String key;
        private final ListenerInvoker invoker;

        KeyedListenerInvoker(String key, ListenerInvoker invoker) {
            this.invoker = invoker;
            this.key = key;
        }

        String getKey() {
            return this.key;
        }

        ListenerInvoker getInvoker() {
            return this.invoker;
        }

        public int hashCode() {
            return new HashCodeBuilder(5, 23).append(this.key).append(this.invoker).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            KeyedListenerInvoker kli = (KeyedListenerInvoker)obj;
            return new EqualsBuilder().append(this.key, kli.key).append(this.invoker, kli.invoker).isEquals();
        }
    }
}

