/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fugue.retry;

import com.atlassian.fugue.retry.ExceptionHandler;
import com.atlassian.fugue.retry.ExceptionHandlers;
import com.atlassian.fugue.retry.NoOp;
import com.atlassian.fugue.retry.RetrySupplier;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;

public class RetryFunction<F, T>
implements Function<F, T> {
    private final Function<F, T> function;
    private final int tries;
    private final ExceptionHandler handler;
    private final Runnable beforeRetry;

    public RetryFunction(Function<F, T> function, int tries) {
        this(function, tries, ExceptionHandlers.ignoreExceptionHandler());
    }

    public RetryFunction(Function<F, T> function, int tries, ExceptionHandler handler) {
        this(function, tries, handler, new NoOp());
    }

    public RetryFunction(Function<F, T> function, int tries, ExceptionHandler handler, Runnable beforeRetry) {
        this.function = Preconditions.checkNotNull(function);
        this.handler = Preconditions.checkNotNull(handler);
        Preconditions.checkArgument(tries >= 0, "Tries must not be negative");
        this.tries = tries;
        this.beforeRetry = Preconditions.checkNotNull(beforeRetry);
    }

    @Override
    public T apply(F parameter) {
        return new RetrySupplier<T>(Suppliers.compose(this.function, Suppliers.ofInstance(parameter)), this.tries, this.handler, this.beforeRetry).get();
    }
}

