/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.domain.Operation;
import com.atlassian.jira.rest.client.api.domain.OperationGroup;
import com.atlassian.jira.rest.client.api.domain.OperationVisitor;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;

public class Operations {
    private final Iterable<OperationGroup> linkGroups;

    public Operations(Iterable<OperationGroup> linkGroups) {
        this.linkGroups = linkGroups;
    }

    public Iterable<OperationGroup> getLinkGroups() {
        return this.linkGroups;
    }

    public <T> Optional<T> accept(OperationVisitor<T> visitor) {
        return OperationGroup.accept(this.getLinkGroups(), visitor);
    }

    public Operation getOperationById(final String operationId) {
        return this.accept(new OperationVisitor<Operation>(){

            @Override
            public Optional<Operation> visit(Operation operation) {
                return operationId.equals(operation.getId()) ? Optional.of(operation) : Optional.absent();
            }
        }).orNull();
    }

    public int hashCode() {
        return Objects.hashCode(this.linkGroups);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Operations other = (Operations)obj;
        return Iterables.elementsEqual(this.linkGroups, other.linkGroups);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("linkGroups", this.linkGroups).toString();
    }
}

