/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.ExceptionPolicy;
import com.atlassian.util.concurrent.Functions;
import com.atlassian.util.concurrent.LimitedExecutor;
import com.atlassian.util.concurrent.NotNull;
import com.atlassian.util.concurrent.RuntimeExecutionException;
import com.atlassian.util.concurrent.RuntimeInterruptedException;
import com.atlassian.util.concurrent.Timeout;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class AsyncCompleter {
    private final Executor executor;
    private final ExceptionPolicy policy;
    private final ExecutorCompletionServiceFactory completionServiceFactory;

    AsyncCompleter(Executor executor, ExceptionPolicy policy, ExecutorCompletionServiceFactory completionServiceFactory) {
        this.executor = Assertions.notNull("executor", executor);
        this.policy = Assertions.notNull("policy", policy);
        this.completionServiceFactory = Assertions.notNull("completionServiceFactory", completionServiceFactory);
    }

    public <T> Iterable<T> invokeAll(Iterable<? extends Callable<T>> callables) {
        return this.invokeAllTasks(callables, new BlockingAccessor());
    }

    public <T> Iterable<T> invokeAll(Iterable<? extends Callable<T>> callables, long time, TimeUnit unit) {
        return this.invokeAllTasks(callables, new TimeoutAccessor(Timeout.getNanosTimeout(time, unit)));
    }

    <T> Iterable<T> invokeAllTasks(Iterable<? extends Callable<T>> callables, Accessor<T> accessor) {
        CompletionService apply = this.completionServiceFactory.create().apply(this.executor);
        ImmutableList lazyAsyncSuppliers = ImmutableList.copyOf(Iterables.transform(callables, new AsyncCompletionFunction(apply, accessor)));
        Iterable handled = Iterables.transform(lazyAsyncSuppliers, this.policy.handler());
        return Iterables.filter(Iterables.transform(handled, Functions.fromSupplier()), Predicates.notNull());
    }

    static final class ExecutorCompletionServiceFunction<T>
    implements Function<Executor, CompletionService<T>> {
        ExecutorCompletionServiceFunction() {
        }

        @Override
        public CompletionService<T> apply(Executor executor) {
            return new ExecutorCompletionService(executor);
        }
    }

    static final class DefaultExecutorCompletionServiceFactory
    implements ExecutorCompletionServiceFactory {
        DefaultExecutorCompletionServiceFactory() {
        }

        @Override
        public <T> Function<Executor, CompletionService<T>> create() {
            return new ExecutorCompletionServiceFunction();
        }
    }

    static final class BlockingAccessor<T>
    implements Accessor<T> {
        BlockingAccessor() {
        }

        @Override
        public T apply(CompletionService<T> completionService) {
            try {
                return completionService.take().get();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeExecutionException(e);
            }
        }

        @Override
        public void register(Future<T> f) {
        }
    }

    static final class TimeoutAccessor<T>
    implements Accessor<T> {
        private final Timeout timeout;
        private final Collection<Future<T>> futures = new ConcurrentLinkedQueue<Future<T>>();

        TimeoutAccessor(Timeout timeout) {
            this.timeout = timeout;
        }

        @Override
        public T apply(CompletionService<T> completionService) {
            try {
                Future<T> future = completionService.poll(this.timeout.getTime(), this.timeout.getUnit());
                if (future == null) {
                    this.cancelRemaining();
                    throw this.timeout.getTimeoutException();
                }
                this.futures.remove(future);
                return future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeExecutionException(e);
            }
        }

        @Override
        public void register(Future<T> f) {
            this.futures.add(f);
        }

        private void cancelRemaining() {
            for (Future<T> f : this.futures) {
                f.cancel(true);
            }
            this.futures.clear();
        }
    }

    static interface Accessor<T>
    extends Function<CompletionService<T>, T> {
        public void register(Future<T> var1);
    }

    private static class AsyncCompletionFunction<T>
    implements Function<Callable<T>, Supplier<T>> {
        private final CompletionService<T> completionService;
        private final Accessor<T> accessor;
        private final Supplier<T> nextCompleteItem = new Supplier<T>(){

            @Override
            public T get() {
                return AsyncCompletionFunction.this.accessor.apply(AsyncCompletionFunction.this.completionService);
            }
        };

        AsyncCompletionFunction(CompletionService<T> completionService, Accessor<T> accessor) {
            this.completionService = completionService;
            this.accessor = accessor;
        }

        @Override
        public Supplier<T> apply(Callable<T> task) {
            this.accessor.register(this.completionService.submit(task));
            return Suppliers.memoize(this.nextCompleteItem);
        }
    }

    public static interface ExecutorCompletionServiceFactory {
        public <T> Function<Executor, CompletionService<T>> create();
    }

    public static class Builder {
        Executor executor;
        ExceptionPolicy policy = ExceptionPolicy.Policies.THROW;
        ExecutorCompletionServiceFactory completionServiceFactory = new DefaultExecutorCompletionServiceFactory();

        public Builder(@NotNull Executor executor) {
            this.executor = Assertions.notNull("executor", executor);
        }

        public Builder ignoreExceptions() {
            return this.handleExceptions(ExceptionPolicy.Policies.IGNORE_EXCEPTIONS);
        }

        public Builder handleExceptions(ExceptionPolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder completionServiceFactory(ExecutorCompletionServiceFactory completionServiceFactory) {
            this.completionServiceFactory = Assertions.notNull("completionServiceFactory", completionServiceFactory);
            return this;
        }

        public AsyncCompleter limitParallelExecutionTo(int limit) {
            return new AsyncCompleter(new LimitedExecutor(this.executor, limit), this.policy, this.completionServiceFactory);
        }

        public AsyncCompleter build() {
            return new AsyncCompleter(this.executor, this.policy, this.completionServiceFactory);
        }
    }
}

