/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.config;

import java.io.File;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.jboss.set.aphrodite.config.StreamType;

public class StreamConfig {
    private File streamFile;
    private StreamType streamType;
    private URL url;

    public StreamConfig(URL url, StreamType streamType) {
        Objects.requireNonNull(url, "A 'url' must be specified for each service.");
        Objects.requireNonNull(streamType, "A 'streamType' must be specified for each service.");
        this.url = url;
        this.streamType = streamType;
    }

    public StreamConfig(File streamFile, StreamType streamType) {
        Objects.requireNonNull(streamFile, "A 'streamFile' must be specified for each service.");
        Objects.requireNonNull(streamType, "A 'streamType' must be specified for each service.");
        this.streamFile = streamFile;
        this.streamType = streamType;
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public Optional<File> getStreamFile() {
        return Optional.ofNullable(this.streamFile);
    }

    public Optional<URL> getURL() {
        return Optional.ofNullable(this.url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamConfig that = (StreamConfig)o;
        if (this.streamFile != null ? !this.streamFile.equals(that.streamFile) : that.streamFile != null) {
            return false;
        }
        if (this.streamType != that.streamType) {
            return false;
        }
        return this.url != null ? this.url.equals(that.url) : that.url == null;
    }

    public int hashCode() {
        int result = this.streamFile != null ? this.streamFile.hashCode() : 0;
        result = 31 * result + (this.streamType != null ? this.streamType.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StreamConfig{streamFile='" + this.streamFile + '\'' + ", streamType=" + (Object)((Object)this.streamType) + ", url=" + this.url + '}';
    }
}

